/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.utils.Connections;

public final class ConnectionsAdapter
implements ConnectionListener {
    public void connectionAdded(ConnectionEvent evt) {
    }

    public void connectionRemoved(ConnectionEvent evt) {
        RepositoryManager.removeDbNameFromconfig(evt.getConnectionName());
    }

    public void connectionRenamed(ConnectionEvent evt) {
        String newName = evt.getConnectionName();
        String oldName = evt.getOldName();
        if (MigrationAddin.getMigrationConfig().isRepository(oldName)) {
            RepositoryManager.renameConnection(oldName, newName);
        }
    }

    public void connectionModified(ConnectionEvent evt) {
    }

    public void connectionOpened(ConnectionEvent evt) {
        String currentRepoName;
        String name = evt.getConnectionName();
        String defaultRepo = MigrationAddin.getMigrationConfig().getDefaultRepository();
        if (defaultRepo != null && name.toLowerCase().equals(defaultRepo.toLowerCase()) && Connections.getInstance().isConnectionOpen(name) && ((currentRepoName = MigrationAddin.getRepositoryConnectionName()) == null || !currentRepoName.equals(name))) {
            MigrationAddin.openRepository(name);
        }
    }

    public void connectionClosed(ConnectionEvent evt) {
        String currentRepoName;
        String name = evt.getConnectionName();
        String defaultRepo = MigrationAddin.getMigrationConfig().getDefaultRepository();
        if (defaultRepo != null && name.toLowerCase().equals(defaultRepo.toLowerCase()) && (currentRepoName = MigrationAddin.getRepositoryConnectionName()) != null && currentRepoName.equals(name)) {
            MigrationAddin.disconnectRepository();
        }
    }
}

