/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.io.IOException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.raptor.navigator.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.CustomNode;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.ide.net.URLFactory;
import oracle.javatools.db.DBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MigrationConnectionNode
extends AbstractConnectionNode
implements CustomNode {
    protected HashMap<String, Object> m_dict = new HashMap();
    private String m_cName;
    private MdConnection m_connection;
    private String m_label;

    public MigrationConnectionNode(String label, String connectionName, MdConnection connection) {
        this.m_cName = connectionName;
        this.m_connection = connection;
        this.setShortLabel(label);
        this.setURL(URLFactory.newURL((String)"sqldev.migration", (String)(connectionName + "/" + connection.getKey().toString())));
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this.closeConnection();
    }

    protected void openImpl() throws IOException {
        super.openImpl();
        try {
            ObjectFactory objFact = ObjectFactory.getFactory((String)this.getShortLabel(), (Connection)this.getConnection());
        }
        catch (DBException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (IOException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public String getShortLabel() {
        return this.m_label;
    }

    public String getQualifiedConnectionName() {
        return this.m_cName;
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public String getObjectName() {
        return this.m_label;
    }

    public abstract String getSchemaName();

    public String getObjectId() {
        return this.getMdConnection().getKey().toString();
    }

    public String getObjectType() {
        return "CATALOGS";
    }

    public String getChildName() {
        return null;
    }

    public Object getObject() {
        return this.getMdConnection();
    }

    public Connection getConn() {
        try {
            return this.getConnection();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public String getCatalog() {
        return null;
    }

    public MdConnection getMdConnection() {
        return this.m_connection;
    }

    protected abstract void closeConnection();

    protected abstract Connection openConnection() throws IOException;

    public HashMap<String, Object> getDict() {
        return this.m_dict;
    }

    public abstract String getConnType();

    public void setShortLabel(String label) {
        this.m_label = label;
    }

    public String getToolTipText() {
        return this.getSchemaName() + ":" + this.getObjectName();
    }

    public String getLongLabel() {
        return this.getToolTipText();
    }
}

