/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import oracle.dbtools.migration.workbench.core.navigator.CaptureRepositoryDatabaseManager;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedRepositoryDatabaseManager;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.migration.workbench.core.repository.DeleteCapturedConnection;
import oracle.dbtools.migration.workbench.core.repository.DeleteConvertedConnection;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorController;
import oracle.dbtools.raptor.navigator.NavActionListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;

public class MigrationNavigatorController
extends DatabaseNavigatorController {
    private int cmdDebugId = Ide.findOrCreateCmdID((String)"DebugSelectionCommand");
    private int cmdRunId = Ide.findOrCreateCmdID((String)"RunSelectionCommand");

    public MigrationNavigatorController(Controller parent) {
        super(parent);
        IdeAction actionRun;
        IdeAction actionDebug;
        IdeAction actionDelete = IdeAction.find((int)20);
        if (actionDelete != null) {
            actionDelete.addController((Controller)this);
        }
        if ((actionDebug = IdeAction.find((int)this.cmdDebugId)) != null) {
            actionDebug.addController((Controller)this);
        }
        if ((actionRun = IdeAction.find((int)this.cmdRunId)) != null) {
            actionRun.addController((Controller)this);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        Element element = context.getElement();
        int id = action.getCommandId();
        if (id == 20) {
            if (element instanceof DatabaseConnection) {
                return super.handleEvent(action, context);
            }
            if (element instanceof CapturedConnectionNode || element instanceof ConvertedConnectionNode) {
                this.deleteSelectedNodes(context);
                return true;
            }
        }
        return super.handleEvent(action, context);
    }

    private void deleteSelectedNodes(Context context) {
        Element[] selections = context.getSelection();
        if (selections != null && selections.length > 0) {
            AbstractMenuAction actionController = null;
            if (selections[0] instanceof CapturedConnectionNode) {
                actionController = new DeleteCapturedConnection();
            } else if (selections[0] instanceof ConvertedConnectionNode) {
                actionController = new DeleteConvertedConnection();
            }
            actionController.setContext(context);
            actionController.launch();
        }
    }

    public boolean update(IdeAction action, Context context) {
        boolean result = false;
        int id = action.getCommandId();
        Element selection = context.getElement();
        if (id == 20) {
            if (selection instanceof DatabaseConnection) {
                result = super.update(action, context);
            } else {
                action.setEnabled(selection instanceof CapturedConnectionNode || selection instanceof ConvertedConnectionNode);
                result = true;
            }
        }
        if (selection instanceof CapturedNode && (id == this.cmdDebugId || id == this.cmdRunId)) {
            action.setEnabled(false);
            result = true;
        }
        return result || super.update(action, context);
    }

    static {
        ObjectActionController.addListener((IObjectActionListener)new NavActionListener(CaptureRepositoryDatabaseManager.getInstance()));
        ObjectActionController.addListener((IObjectActionListener)new NavActionListener(ConvertedRepositoryDatabaseManager.getInstance()));
    }
}

