/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryStateListener;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.Assert;

public abstract class MigrationRepositoryDatabases
extends DefaultContainer
implements MigrationRepositoryStateListener {
    protected HashSet<String> m_names = new HashSet();
    protected PersistenceUtility m_utility;
    protected PersistenceManager m_persistenceManager;
    protected Connection m_connection;
    private boolean _closing;

    public MigrationRepositoryDatabases() {
        MigrationAddin.addMigrationRepositoryStateListener(this);
    }

    public abstract String getShortLabel();

    protected abstract MigrationConnectionNode createMdConnectionNode(String var1, String var2, MdConnection var3);

    protected abstract CloseableIterator getMdConnectionsIterator() throws PersistenceException;

    protected String findUniqueName(String label) {
        String name = label;
        int i = 2;
        while (this.m_names.contains(name)) {
            name = label + "(" + i++ + ")";
        }
        return name;
    }

    protected void addChild(MdConnection mdconnection, String connectionName) {
        for (Object o : this._children) {
            MigrationConnectionNode mcn = (MigrationConnectionNode)((Object)o);
            if (!mcn.getMdConnection().equals(mdconnection)) continue;
            UpdateMessage.fireStructureChanged((Subject)mcn);
            return;
        }
        String name = this.findUniqueName(mdconnection.getName());
        this.m_names.add(name);
        MigrationConnectionNode newNode = this.createMdConnectionNode(name, connectionName, mdconnection);
        this._children.add(newNode);
        UpdateMessage.fireChildAdded((Subject)this, (Element)newNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        if (!MigrationAddin.isRepositoryOpen()) {
            return;
        }
        this.m_utility = PersistenceUtility.getInstance(this.getPersistenceManager());
        String connName = MigrationAddin.getRepositoryConnectionName();
        CloseableIterator mdConnectionsIterator = null;
        try {
            try {
                mdConnectionsIterator = this.getMdConnectionsIterator();
                while (mdConnectionsIterator.hasNext()) {
                    MdConnection mdconnection = (MdConnection)mdConnectionsIterator.next();
                    this.addChild(mdconnection, connName);
                }
                Object var5_5 = null;
                if (mdConnectionsIterator != null) {
                    mdConnectionsIterator.close();
                }
            }
            catch (PersistenceException pex) {
                Assert.printStackTrace((Throwable)pex);
                Object var5_6 = null;
                if (mdConnectionsIterator != null) {
                    mdConnectionsIterator.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (mdConnectionsIterator != null) {
                mdConnectionsIterator.close();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeImpl() throws IOException {
        try {
            if (!this._closing) {
                this._closing = true;
                ArrayList arrayList = this._children;
                synchronized (arrayList) {
                    this._children.clear();
                }
                this.m_persistenceManager = null;
                this.m_utility = null;
                this.m_names.clear();
            }
            Object var4_3 = null;
            this._closing = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this._closing = false;
            throw throwable;
        }
    }

    public void addMdConnection(MdConnection mdconnection) {
        this.addChild(mdconnection, MigrationAddin.getDefaultMigrationRepository());
    }

    protected abstract PersistenceManager getPersistenceManager();

    public PersistenceUtility getUtility() {
        return this.m_utility;
    }

    public boolean deleteConnection(MigrationConnectionNode nodeToRemove) {
        MdConnection mdConnection = nodeToRemove.getMdConnection();
        boolean tobeDeleted = false;
        for (MigrationConnectionNode nextNode : this._children) {
            if (!nodeToRemove.getShortLabel().equals(nextNode.getShortLabel())) continue;
            tobeDeleted = true;
            break;
        }
        if (!tobeDeleted) {
            return false;
        }
        try {
            mdConnection.delete(this.getPersistenceManager());
            this.getPersistenceManager().commit();
            this.m_names.remove(nodeToRemove.getShortLabel());
            this.remove((Element)nodeToRemove);
            UpdateMessage.fireStructureChanged((Subject)this);
            this.markDirty(false);
            this.repositoryClosed();
            try {
                this.open();
            }
            catch (IOException e) {
                Logger.getLogger("oracle.dbtools.migration").severe(e.getLocalizedMessage());
            }
        }
        catch (PersistenceException pex) {
            return false;
        }
        catch (SQLException sqlex) {
            return false;
        }
        return true;
    }

    public boolean renameConnection(MigrationConnectionNode nodeToRename, String newName) {
        MdConnection mdConnection = nodeToRename.getMdConnection();
        mdConnection.setName(newName);
        try {
            mdConnection.save(this.getPersistenceManager());
            this.getPersistenceManager().commit();
        }
        catch (PersistenceException pex) {
            return false;
        }
        catch (SQLException sqlex) {
            return false;
        }
        this.m_names.remove(nodeToRename.getShortLabel());
        String sLabel = this.findUniqueName(newName);
        nodeToRename.setShortLabel(sLabel);
        UpdateMessage.fireObjectRenamed((Subject)this);
        return true;
    }

    public MigrationConnectionNode[] getMigrationConnectionNodes() {
        return this._children.toArray(new MigrationConnectionNode[this._children.size()]);
    }

    public boolean isConnected() {
        return this.m_persistenceManager != null;
    }

    public void nullConnection() {
        this.m_connection = null;
    }

    public void repositoryClosed() {
        try {
            this.close();
        }
        catch (IOException ioe) {
            Logger.getLogger("oracle.dbtools.migration").severe(ioe.getLocalizedMessage());
        }
    }

    public void repositoryOpened(String name) {
        try {
            if (this.isOpen()) {
                this.revert();
            } else {
                this.open();
            }
        }
        catch (IOException ioe) {
            Logger.getLogger("oracle.dbtools.migration").severe(ioe.getLocalizedMessage());
        }
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public MigrationConnectionNode[] findMatchingConnections(String dbURL) {
        ArrayList<MigrationConnectionNode> ret = new ArrayList<MigrationConnectionNode>();
        for (Object o : this._children) {
            MigrationConnectionNode mcn = (MigrationConnectionNode)((Object)o);
            if (!mcn.getMdConnection().getDburl().equals(dbURL)) continue;
            ret.add(mcn);
        }
        return ret.toArray(new MigrationConnectionNode[ret.size()]);
    }
}

