/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.net;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.net.URLFileSystem;

public class MigrationURLFormatHelper
extends DBURLFormatHelper {
    public MigrationURLFormatHelper() {
        super("sqldev.migration");
    }

    protected String getConnectionNameImpl(URL uRL) {
        return MigrationURLFormatHelper.extractPart(uRL, 0);
    }

    protected Icon getIconImpl(URL uRL) {
        return null;
    }

    protected String getCatalogImpl(URL uRL) {
        String catalogPart = MigrationURLFormatHelper.extractPart(uRL, 1);
        return MigrationURLFormatHelper.extractNameFromRef(catalogPart);
    }

    public DBObjectId getCatalogId(URL uRL) {
        String catalogPart = MigrationURLFormatHelper.extractPart(uRL, 1);
        return MigrationURLFormatHelper.extractIdFromRef(catalogPart);
    }

    protected String getSchemaImpl(URL uRL) {
        String schemaPart = MigrationURLFormatHelper.extractPart(uRL, 2);
        return MigrationURLFormatHelper.extractNameFromRef(schemaPart);
    }

    public static DBObjectId getSchemaId(URL uRL) {
        String schemaPart = MigrationURLFormatHelper.extractPart(uRL, 2);
        return MigrationURLFormatHelper.extractIdFromRef(schemaPart);
    }

    public static DBObjectId getColumnId(URL uRL) {
        String schemaPart = null;
        try {
            schemaPart = MigrationURLFormatHelper.extractPart(new URL(uRL.getProtocol() + "://" + uRL.getRef()), 1);
        }
        catch (MalformedURLException e) {
            Logger.getLogger(MigrationURLFormatHelper.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return MigrationURLFormatHelper.extractIdFromRef(schemaPart);
    }

    protected String getBaseTypeImpl(URL uRL) {
        return MigrationURLFormatHelper.extractPart(uRL, 3);
    }

    protected String getNameImpl(URL uRL) {
        String namePart = MigrationURLFormatHelper.extractPart(uRL, 4);
        return MigrationURLFormatHelper.extractNameFromRef(namePart);
    }

    public static DBObjectId getObjectId(URL uRL) {
        String namePart = MigrationURLFormatHelper.extractPart(uRL, 4);
        return MigrationURLFormatHelper.extractIdFromRef(namePart);
    }

    protected String getChildTypeImpl(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equals("sqldev.migration")) {
            return null;
        }
        String ref = uRL.getRef();
        String[] parts = ref.split("/");
        if (parts == null || parts.length < 2) {
            return null;
        }
        return MigrationURLFormatHelper.decode(parts[0]);
    }

    protected String getChildNameImpl(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equals("sqldev.migration")) {
            return null;
        }
        String ref = uRL.getRef();
        String[] parts = ref.split("/");
        if (parts == null || parts.length < 2) {
            return null;
        }
        return MigrationURLFormatHelper.extractNameFromRef(parts[1]);
    }

    public DBObjectId getChildObjectId(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equals("sqldev.migration")) {
            return null;
        }
        String ref = uRL.getRef();
        String[] parts = ref.split("/");
        if (parts == null || parts.length < 2) {
            return null;
        }
        return MigrationURLFormatHelper.extractIdFromRef(parts[1]);
    }

    private static String extractPart(URL uRL, int partNum) {
        if (uRL == null || !uRL.getProtocol().equals("sqldev.migration")) {
            return null;
        }
        String path = URLFileSystem.getPath((URL)uRL);
        String[] parts = path.split("/");
        if (parts == null || parts.length < partNum + 1) {
            return null;
        }
        return MigrationURLFormatHelper.decode(parts[partNum]);
    }

    private static String extractNameFromRef(String refStr) {
        if (refStr == null) {
            return null;
        }
        int indx = refStr.indexOf(95);
        if (indx == -1 || indx == refStr.length()) {
            return refStr;
        }
        return MigrationURLFormatHelper.decode(refStr.substring(indx + 1));
    }

    private static DBObjectId extractIdFromRef(String refStr) {
        if (refStr == null) {
            return null;
        }
        int indx = refStr.indexOf(95);
        String sub = indx == -1 ? refStr : refStr.substring(0, indx);
        try {
            return new DBObjectId(Long.parseLong(sub));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    protected static String decode(String s) {
        String decoded = s;
        try {
            decoded = URLDecoder.decode(s, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }
}

