/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.workbench.core.ConvertInitiator;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.Assert;
import oracle.javatools.buffer.TextBuffer;

public class CapturedNode
extends PlSqlNode {
    private static final String MD_PROCEDURE = "MD_PROCEDURE";
    private static final String MD_VIEW = "MD_VIEW";
    private static final String MD_FUNCTION = "MD_FUNCTION";
    private static final String MD_TRIGGER = "MD_TRIGGER";
    private String m_name;
    private String m_cName;
    private String m_type;
    private String m_schema;
    private boolean m_reconvert_flag;

    public CapturedNode() {
        this.getAttributes().set(ElementAttributes.DELETEABLE | ElementAttributes.RENAMEABLE | ElementAttributes.SAVEABLE | ElementAttributes.EDITOR_SAVEABLE_AS | ElementAttributes.CLOSEABLE | ElementAttributes.PRINTABLE);
        this.getAttributes().unset(ElementAttributes.BUILDABLE);
        this.setReadOnly(false);
    }

    public void setURL(URL url) {
        super.setURL(url);
        if (url != null) {
            this.m_name = DBURLFormatHelper.getName((URL)url);
            this.m_cName = DBURLFormatHelper.getConnectionName((URL)url);
            this.m_type = DBURLFormatHelper.getBaseType((URL)url);
            this.m_schema = DBURLFormatHelper.getSchema((URL)url);
        }
    }

    public void setNodeInstance(DBObjectInstance inst) {
        this.m_node = inst;
    }

    public DBObjectInstance getNodeInstance() {
        return this.m_node;
    }

    public void setProperty(String key, Object value) {
        this.m_node.setProperty(key, value);
    }

    public Object getProperty(String key) {
        Object value = null;
        if ("NAME".equals(key)) {
            value = this.m_name;
        } else if ("SCHEMA".equals(key)) {
            value = this.m_schema;
        } else if ("TYPE".equals(key)) {
            value = this.m_type;
        } else if ("ConnectionName".equals(key)) {
            value = this.m_cName;
        } else if (this.m_node != null) {
            value = this.m_node.getProperty(key);
        }
        return value;
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public NavigationPoint getNavigationPoint(ChildObjectElement child) {
        OffsetNavigationPoint point = null;
        Integer offset = (Integer)child.getProperty("CODE_OFFSET");
        if (offset != null) {
            Integer length = (Integer)child.getProperty("CODE_LENGTH");
            point = new OffsetNavigationPoint(Context.newIdeContext((Node)this), offset.intValue(), length != null ? length : 0);
            point.setPreferredEditorType(null);
        }
        return point;
    }

    public boolean isValid() {
        return this.m_type != null;
    }

    protected Reader createReader(URL url) throws IOException {
        DBObjectId objId = MigrationURLFormatHelper.getObjectId(url);
        if (objId == null) {
            return null;
        }
        try {
            if (MD_PROCEDURE.equals(this.m_type)) {
                MdStoredProgram program = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objId);
                return program.getNativeSql().getReader();
            }
            if (MD_VIEW.equals(this.m_type)) {
                MdView view = MdView.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objId);
                return view.getNativeSql().getReader();
            }
            if (MD_FUNCTION.equals(this.m_type)) {
                MdStoredProgram function = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objId);
                return function.getNativeSql().getReader();
            }
            if (MD_TRIGGER.equals(this.m_type)) {
                MdTrigger trigger = MdTrigger.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objId);
                return trigger.getNativeSql().getReader();
            }
        }
        catch (PersistenceException e) {
            Assert.printStackTrace((Throwable)e);
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        catch (NoSuchObjectException e) {
            Assert.printStackTrace((Throwable)e);
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        return null;
    }

    protected void saveImpl() throws IOException {
        URL url = this.getURL();
        DBObjectId objId = MigrationURLFormatHelper.getObjectId(url);
        if (objId == null) {
            return;
        }
        TextBuffer textBuffer = this.getTextBufferDirectly();
        if (textBuffer != null) {
            textBuffer.clearModified();
        }
        try {
            if (MD_PROCEDURE.equals(this.m_type)) {
                MdStoredProgram program = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objId);
                program.setNativeSql(textBuffer.getString(0, textBuffer.getLength()));
                program.save(MigrationAddin.getPersistenceManager());
                if (this.isSetReconvertFlag()) {
                    this.doReconvert(program);
                }
            } else if (MD_VIEW.equals(this.m_type)) {
                MdView view = MdView.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objId);
                view.setNativeSql(textBuffer.getString(0, textBuffer.getLength()));
                view.save(MigrationAddin.getPersistenceManager());
            } else if (MD_FUNCTION.equals(this.m_type)) {
                MdStoredProgram function = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objId);
                function.setNativeSql(textBuffer.getString(0, textBuffer.getLength()));
                function.save(MigrationAddin.getPersistenceManager());
            } else if (MD_TRIGGER.equals(this.m_type)) {
                MdTrigger trigger = MdTrigger.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objId);
                trigger.setNativeSql(textBuffer.getString(0, textBuffer.getLength()));
                trigger.save(MigrationAddin.getPersistenceManager());
            }
        }
        catch (PersistenceException e) {
            MigrationLogUtil.logThrowable("Save failed for object:", new Object[]{MigrationURLFormatHelper.getName((URL)url)}, (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            MigrationLogUtil.logThrowable("Save failed for object:", new Object[]{MigrationURLFormatHelper.getName((URL)url)}, (Throwable)e);
        }
    }

    private void doReconvert(MdStoredProgram program) {
        ConvertInitiator initiator = new ConvertInitiator();
        initiator.setContext(Context.newIdeContext((Node)this));
        initiator.setDBObject(new DBObject((Element)this));
        initiator.launch();
    }

    public boolean isSetReconvertFlag() {
        return this.m_reconvert_flag;
    }

    public void setReconvertFlag(boolean reconvertFlag) {
        this.m_reconvert_flag = reconvertFlag;
    }
}

