/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.navigation.NavigationPoint;
import oracle.ide.util.Assert;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;

public class TSQLNode
extends TextNode
implements DatabaseNode {
    public static final String RUNNABLE_KEY = "RUNNABLE";
    private String m_name;
    private String m_cName;
    private String m_type;
    private String m_schema;
    private DBObjectInstance m_node;

    public void setURL(URL url) {
        super.setURL(url);
        if (url != null) {
            this.m_name = DBURLFormatHelper.getName((URL)url);
            this.m_cName = DBURLFormatHelper.getConnectionName((URL)url);
            this.m_type = DBURLFormatHelper.getBaseType((URL)url);
            this.m_schema = DBURLFormatHelper.getSchema((URL)url);
        }
    }

    public TSQLNode getRunTarget() {
        return null;
    }

    public final String getSource() {
        return "hello World";
    }

    public void setNodeInstance(DBObjectInstance inst) {
        this.m_node = inst;
    }

    public DBObjectInstance getNodeInstance() {
        return this.m_node;
    }

    public void setProperty(String key, Object value) {
        this.m_node.setProperty(key, value);
    }

    public Object getProperty(String key) {
        Object value = null;
        if ("NAME".equals(key)) {
            value = this.m_name;
        } else if ("SCHEMA".equals(key)) {
            value = this.m_schema;
        } else if ("TYPE".equals(key)) {
            value = this.m_type;
        } else if ("ConnectionName".equals(key)) {
            value = this.m_cName;
        } else if (this.m_node != null) {
            value = this.m_node.getProperty(key);
        }
        return value;
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public NavigationPoint getNavigationPoint(ChildObjectElement child) {
        OffsetNavigationPoint point = null;
        Integer offset = (Integer)child.getProperty("CODE_OFFSET");
        if (offset != null) {
            Integer length = (Integer)child.getProperty("CODE_LENGTH");
            point = new OffsetNavigationPoint(Context.newIdeContext((Node)this), offset.intValue(), length != null ? length : 0);
            point.setPreferredEditorType(null);
        }
        return point;
    }

    public final boolean isValid() {
        return this.m_type != null;
    }

    private Reader tryMSLoad() {
        Object o = this.getProperty("MSIDSP");
        if (o == null) {
            return null;
        }
        Integer id = (Integer)o;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            Connection conn = Connections.getInstance().getConnection((String)this.getProperty("ConnectionName"));
            stmt = conn.prepareStatement("SELECT TOP 1 CAST(TEXT AS VARCHAR(4000)) from syscomments WHERE ID=?");
            stmt.setInt(1, id);
            rs = stmt.executeQuery();
            rs.next();
            String text = rs.getString(1);
            StringReader reader = new StringReader(text);
            return reader;
        }
        catch (SQLException sqlex) {
            CloseableResultSet.close(stmt, rs);
        }
        catch (DBException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return null;
    }

    protected Reader createReader(URL arg0) throws IOException {
        MdStoredProgram program;
        Object o = this.getProperty("IDSP");
        if (o == null) {
            Reader r = this.tryMSLoad();
            if (r != null) {
                return r;
            }
            return super.createReader(arg0);
        }
        BigDecimal bd = (BigDecimal)o;
        long l = bd.longValue();
        DBObjectId objId = new DBObjectId(l);
        try {
            program = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objId);
        }
        catch (PersistenceException e) {
            Assert.printStackTrace((Throwable)e);
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        catch (NoSuchObjectException e) {
            Assert.printStackTrace((Throwable)e);
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        return program.getNativeSql().getReader();
    }

    public String getObjectType() {
        return null;
    }

    public String getSchemaName() {
        return null;
    }

    public Object getProviderIdentifier() {
        return null;
    }

    public String getStoreName() {
        return null;
    }

    public String getObjectName() {
        return null;
    }

    public DBObject getDBObject() {
        return null;
    }

    public DBObjectProvider getProvider() {
        return null;
    }

    public void init(DBObject arg0, DBObjectProvider arg1) {
    }
}

