/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.awt.Color;
import oracle.dbtools.migration.translation.api.prefs.ConfigurationOptions;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

public final class ConfigurationData
extends HashStructureAdapter {
    public static final String KEY = "IdeSettings4GenEditor1.0";
    private static final String COLORLIST = "ColorList";
    private static final ListStructure DEFAULT_COLORLIST = ListStructure.newInstance();
    private static final String DEFAULT_DATEFORMAT = "dd/mm/yyyy";
    private static final String DATEFORMAT = "DATEFORMAT";
    private static final String QUERYASSIGNMENT = "QUERYASSIGNMENT";
    private static final String VARPREFIX = "VARPREFIX";
    private static final String INPARAMPREFIX = "INPARAMPREFIX";
    private static final String GENERATEENTIREEMULATIONPKG = "GENERATEENTIREEMULATIONPKG";

    private ConfigurationData(HashStructure hash) {
        super(hash);
        DEFAULT_COLORLIST.clear();
        for (int i = 0; i < ConfigurationOptions.getLevelNumber(); ++i) {
            DEFAULT_COLORLIST.add((Object)this.getString(ConfigurationOptions.colors[i]));
        }
    }

    public static ConfigurationData getInstance(PropertyStorage prefs) {
        return new ConfigurationData(ConfigurationData.findOrCreate((PropertyStorage)prefs, (String)KEY));
    }

    public ListStructure getColorList() {
        ListStructure ls = this._hash.getListStructure(COLORLIST);
        if (ls == null) {
            ls = DEFAULT_COLORLIST;
        }
        return ls;
    }

    public void setColorList(ListStructure ls) {
        this._hash.putListStructure(COLORLIST, ls);
    }

    private String getString(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return String.format("%1$d,%2$d,%3$d", red, green, blue);
    }

    public String getDateFormat() {
        return this._hash.getString(DATEFORMAT, DEFAULT_DATEFORMAT);
    }

    public void setDateFormat(String dateFormat) {
        this._hash.putString(DATEFORMAT, dateFormat);
    }

    public String getQueryAssignment() {
        String queryType = this._hash.getString(QUERYASSIGNMENT);
        if (queryType == null) {
            queryType = "SELECT INTO assignment";
        }
        return queryType;
    }

    public void setQueryAssignment(String queryAssignment) {
        this._hash.putString(QUERYASSIGNMENT, queryAssignment);
    }

    public String getVarPrefix() {
        String varPrefix = this._hash.getString(VARPREFIX);
        if (varPrefix == null) {
            varPrefix = "v_";
        }
        return varPrefix;
    }

    public void setVarPrefix(String varPrefix) {
        this._hash.putString(VARPREFIX, varPrefix);
    }

    public String getInParamPrefix() {
        String varPrefix = this._hash.getString(INPARAMPREFIX);
        if (varPrefix == null) {
            varPrefix = "iv_";
        }
        return varPrefix;
    }

    public void setInParamPrefix(String varPrefix) {
        this._hash.putString(INPARAMPREFIX, varPrefix);
    }

    public boolean getGenerateEntireEmulationPkg() {
        Boolean genPkg = true;
        if (this._hash.containsKey(GENERATEENTIREEMULATIONPKG)) {
            genPkg = this._hash.getBoolean(GENERATEENTIREEMULATIONPKG);
        }
        return genPkg;
    }

    public void setGenerateEntireEmulationPkg(boolean genPkg) {
        this._hash.putBoolean(GENERATEENTIREEMULATIONPKG, genPkg);
    }
}

