/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class GeneratePreferencesPanel
extends DefaultTraversablePanel {
    public static final String TITLE = MigrationAddinArb.getString(224);
    private static final long serialVersionUID = 4843227636357117485L;
    private JButton m_buttonChooseOutput;
    private JCheckBox m_checkComments;
    private JCheckBox m_checkGenControlScript;
    private JCheckBox m_checkMaxLines;
    private JTextField m_labelUserOutputDir;
    private JRadioButton m_radioPerObject;
    private JRadioButton m_radioSingle;
    private JTextField m_textNumLines;
    private JCheckBox m_checkSingleSchema;
    private JCheckBox m_generateDataMoveUserFlag;
    private JCheckBox m_generateFailedObjects;
    private JCheckBox m_generateClobToBlob;

    public GeneratePreferencesPanel() {
        this.initComponents();
        this.setMaxLinesState();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_migprefgeneration_html");
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        ButtonGroup m_fileOptionsGroup = new ButtonGroup();
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        this.add(panel, gridBagConstraints);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(new TitledBorder(null, MigrationAddinArb.getString(226), 0, 0, null, null));
        panel_1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints_1 = new GridBagConstraints();
        gridBagConstraints_1.insets = new Insets(5, 15, 0, 0);
        gridBagConstraints_1.fill = 1;
        gridBagConstraints_1.gridy = 1;
        gridBagConstraints_1.gridx = 0;
        this.add(panel_1, gridBagConstraints_1);
        this.m_radioSingle = new JRadioButton();
        this.m_radioSingle.setText(MigrationAddinArb.getString(227));
        GridBagConstraints gridBagConstraints_7 = new GridBagConstraints();
        gridBagConstraints_7.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints_7.anchor = 18;
        gridBagConstraints_7.gridx = 0;
        gridBagConstraints_7.gridy = 0;
        panel_1.add((Component)this.m_radioSingle, gridBagConstraints_7);
        this.m_radioPerObject = new JRadioButton();
        this.m_radioPerObject.setText(MigrationAddinArb.getString(228));
        GridBagConstraints gridBagConstraints_8 = new GridBagConstraints();
        gridBagConstraints_8.insets = new Insets(5, 5, 5, 0);
        gridBagConstraints_8.weightx = 1.0;
        gridBagConstraints_8.fill = 2;
        gridBagConstraints_8.gridy = 2;
        gridBagConstraints_8.gridx = 0;
        panel_1.add((Component)this.m_radioPerObject, gridBagConstraints_8);
        m_fileOptionsGroup.add(this.m_radioSingle);
        m_fileOptionsGroup.add(this.m_radioPerObject);
        JPanel panel_2 = new JPanel();
        panel_2.setBorder(new TitledBorder(null, MigrationAddinArb.getString(229), 0, 0, null, null));
        panel_2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints_3 = new GridBagConstraints();
        gridBagConstraints_3.insets = new Insets(5, 15, 0, 0);
        gridBagConstraints_3.fill = 1;
        gridBagConstraints_3.gridy = 2;
        gridBagConstraints_3.gridx = 0;
        this.add(panel_2, gridBagConstraints_3);
        this.m_labelUserOutputDir = new JTextField();
        GridBagConstraints gridBagConstraints_4 = new GridBagConstraints();
        gridBagConstraints_4.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints_4.weightx = 1.0;
        gridBagConstraints_4.weighty = 0.0;
        gridBagConstraints_4.fill = 2;
        gridBagConstraints_4.gridy = 0;
        gridBagConstraints_4.gridx = 0;
        panel_2.add((Component)this.m_labelUserOutputDir, gridBagConstraints_4);
        this.m_buttonChooseOutput = new JButton();
        this.m_buttonChooseOutput.setText(MigrationAddinArb.getString(230));
        GridBagConstraints gridBagConstraints_10 = new GridBagConstraints();
        gridBagConstraints_10.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints_10.gridy = 0;
        gridBagConstraints_10.gridx = 1;
        panel_2.add((Component)this.m_buttonChooseOutput, gridBagConstraints_10);
        JPanel panel_3 = new JPanel();
        panel_3.setBorder(new TitledBorder(null, MigrationAddinArb.getString(231), 0, 0, null, null));
        panel_3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints_5 = new GridBagConstraints();
        gridBagConstraints_5.insets = new Insets(5, 15, 0, 0);
        gridBagConstraints_5.weighty = 1.0;
        gridBagConstraints_5.weightx = 1.0;
        gridBagConstraints_5.fill = 1;
        gridBagConstraints_5.gridy = 3;
        gridBagConstraints_5.gridx = 0;
        this.add(panel_3, gridBagConstraints_5);
        this.m_checkComments = new JCheckBox();
        this.m_checkComments.setText(MigrationAddinArb.getString(232));
        GridBagConstraints gridBagConstraints_6 = new GridBagConstraints();
        gridBagConstraints_6.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints_6.weightx = 1.0;
        gridBagConstraints_6.fill = 2;
        gridBagConstraints_6.anchor = 18;
        gridBagConstraints_6.gridy = 0;
        gridBagConstraints_6.gridx = 0;
        panel_3.add((Component)this.m_checkComments, gridBagConstraints_6);
        this.m_checkGenControlScript = new JCheckBox();
        this.m_checkGenControlScript.setText(MigrationAddinArb.getString(233));
        GridBagConstraints gridBagConstraints_12 = new GridBagConstraints();
        gridBagConstraints_12.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints_12.fill = 2;
        gridBagConstraints_12.anchor = 18;
        gridBagConstraints_12.gridy = 2;
        gridBagConstraints_12.gridx = 0;
        panel_3.add((Component)this.m_checkGenControlScript, gridBagConstraints_12);
        JPanel panel_4 = new JPanel();
        panel_4.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints_9 = new GridBagConstraints();
        gridBagConstraints_9.anchor = 18;
        gridBagConstraints_9.fill = 1;
        gridBagConstraints_9.gridy = 3;
        gridBagConstraints_9.gridx = 0;
        panel_3.add((Component)panel_4, gridBagConstraints_9);
        this.m_checkSingleSchema = new JCheckBox();
        this.m_checkSingleSchema.setText(MigrationAddinArb.getString(234));
        GridBagConstraints gridBagConstraints_13 = new GridBagConstraints();
        gridBagConstraints_13.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints_13.weighty = 0.0;
        gridBagConstraints_13.fill = 2;
        gridBagConstraints_13.anchor = 18;
        gridBagConstraints_13.gridy = 4;
        gridBagConstraints_13.gridx = 0;
        panel_3.add((Component)this.m_checkSingleSchema, gridBagConstraints_13);
        this.m_checkMaxLines = new JCheckBox();
        this.m_checkMaxLines.setText(MigrationAddinArb.getString(235));
        GridBagConstraints gridBagConstraints_15 = new GridBagConstraints();
        gridBagConstraints_15.insets = new Insets(0, 5, 0, 15);
        gridBagConstraints_15.weighty = 0.0;
        gridBagConstraints_15.weightx = 0.0;
        gridBagConstraints_15.anchor = 18;
        gridBagConstraints_15.fill = 2;
        gridBagConstraints_15.gridy = 0;
        gridBagConstraints_15.gridx = 0;
        panel_4.add((Component)this.m_checkMaxLines, gridBagConstraints_15);
        this.m_textNumLines = new JTextField();
        this.m_textNumLines.setPreferredSize(new Dimension(40, 20));
        GridBagConstraints gridBagConstraints_16 = new GridBagConstraints();
        gridBagConstraints_16.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints_16.gridy = 0;
        gridBagConstraints_16.gridx = 1;
        panel_4.add((Component)this.m_textNumLines, gridBagConstraints_16);
        JLabel m_fillerLabel = new JLabel();
        GridBagConstraints gridBagConstraints_14 = new GridBagConstraints();
        gridBagConstraints_14.weightx = 1.0;
        gridBagConstraints_14.fill = 2;
        gridBagConstraints_14.gridy = 0;
        gridBagConstraints_14.gridx = 2;
        panel_4.add((Component)m_fillerLabel, gridBagConstraints_14);
        this.m_radioSingle.setText(MigrationAddinArb.getString(238));
        this.m_radioSingle.setMnemonic(MigrationAddinArb.getMnemonic(241));
        this.m_radioPerObject.setText(MigrationAddinArb.getString(240));
        this.m_radioPerObject.setMnemonic(MigrationAddinArb.getMnemonic(243));
        this.m_buttonChooseOutput.setText(MigrationAddinArb.getString(246));
        this.m_buttonChooseOutput.setMnemonic(MigrationAddinArb.getMnemonic(247));
        this.m_buttonChooseOutput.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneratePreferencesPanel.this.chooseFile(evt);
            }
        });
        this.m_checkComments.setText(MigrationAddinArb.getString(250));
        this.m_checkComments.setMnemonic(MigrationAddinArb.getMnemonic(254));
        this.m_checkGenControlScript.setText(MigrationAddinArb.getString(251));
        this.m_checkGenControlScript.setMnemonic(MigrationAddinArb.getMnemonic(254));
        this.m_checkMaxLines.setText(MigrationAddinArb.getString(252));
        this.m_checkMaxLines.setMnemonic(MigrationAddinArb.getMnemonic(256));
        this.m_checkMaxLines.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                GeneratePreferencesPanel.this.setMaxLinesState();
            }
        });
        KeyListener kl = new KeyListener(){

            public void keyTyped(KeyEvent e) {
                char k = e.getKeyChar();
                if ((k <= '/' || k >= ':') && k != '\b') {
                    e.setKeyChar('\f');
                }
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }
        };
        this.m_textNumLines.addKeyListener(kl);
        this.m_generateDataMoveUserFlag = new JCheckBox();
        this.m_generateDataMoveUserFlag.setText(MigrationAddinArb.getString(277));
        GridBagConstraints gridBagConstraints_17 = new GridBagConstraints();
        gridBagConstraints_17.weighty = 0.0;
        gridBagConstraints_17.anchor = 18;
        gridBagConstraints_17.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints_17.fill = 2;
        gridBagConstraints_17.gridy = 5;
        gridBagConstraints_17.gridx = 0;
        panel_3.add((Component)this.m_generateDataMoveUserFlag, gridBagConstraints_17);
        this.m_generateFailedObjects = new JCheckBox();
        this.m_generateFailedObjects.setText(MigrationAddinArb.getString(279));
        GridBagConstraints gridBagConstraints_18 = new GridBagConstraints();
        gridBagConstraints_18.weighty = 0.0;
        gridBagConstraints_18.anchor = 18;
        gridBagConstraints_18.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints_18.fill = 2;
        gridBagConstraints_18.gridy = 6;
        gridBagConstraints_18.gridx = 0;
        panel_3.add((Component)this.m_generateFailedObjects, gridBagConstraints_18);
        this.m_generateClobToBlob = new JCheckBox();
        this.m_generateClobToBlob.setText(MigrationAddinArb.getString(278));
        GridBagConstraints gridBagConstraints_19 = new GridBagConstraints();
        gridBagConstraints_19.weighty = 1.0;
        gridBagConstraints_19.anchor = 18;
        gridBagConstraints_19.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints_19.fill = 2;
        gridBagConstraints_19.gridy = 7;
        gridBagConstraints_19.gridx = 0;
        panel_3.add((Component)this.m_generateClobToBlob, gridBagConstraints_19);
    }

    private void setMaxLinesState() {
        this.m_textNumLines.setEnabled(this.m_checkMaxLines.isSelected());
    }

    private void chooseFile(ActionEvent evt) {
        int retVal;
        JFileChooser jf = new JFileChooser();
        jf.setFileSelectionMode(1);
        if (this.m_radioPerObject.isSelected()) {
            jf.setDialogTitle(MigrationAddinArb.getString(258));
            jf.setFileSelectionMode(1);
            retVal = jf.showOpenDialog((Component)((Object)this));
        } else {
            jf.setDialogTitle(MigrationAddinArb.getString(257));
            retVal = jf.showSaveDialog((Component)((Object)this));
        }
        if (retVal == 0) {
            this.m_labelUserOutputDir.setText(jf.getSelectedFile().getAbsolutePath());
        }
    }

    public void onEntry(TraversableContext tc) {
        MigrationConfig options = MigrationConfig.getInstance(tc.getPropertyStorage());
        super.onEntry(tc);
        if (options.getMaxNumberOfLines() == -1) {
            this.m_checkMaxLines.setSelected(false);
            this.m_textNumLines.setText("");
        } else if (options.getMaxNumberOfLines() >= 0) {
            this.m_checkMaxLines.setSelected(true);
            this.m_textNumLines.setText(Integer.toString(options.getMaxNumberOfLines()));
        }
        String offlineGenDir = options.getOfflineGenerationDirectory();
        if (offlineGenDir == null || offlineGenDir.equals("")) {
            this.m_labelUserOutputDir.setText("");
        } else {
            this.m_labelUserOutputDir.setText(offlineGenDir);
        }
        this.m_checkComments.setSelected(options.getGenerateComments());
        this.m_checkGenControlScript.setSelected(options.getGenerateControllingScript());
        switch (options.getFileOutputOption()) {
            case 2: {
                this.m_radioPerObject.setSelected(true);
                break;
            }
            case 0: {
                this.m_radioSingle.setSelected(true);
            }
        }
        this.m_checkSingleSchema.setSelected(options.getSingleSchemaLeastPrivilege());
        this.m_generateDataMoveUserFlag.setSelected(options.getGenerateDataMoveUserFlag());
        this.m_generateFailedObjects.setSelected(options.getGenerateFailedObjects());
        this.m_generateClobToBlob.setSelected(options.getGenerateClobToBlob());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        MigrationConfig options = MigrationConfig.getInstance(tc.getPropertyStorage());
        super.onExit(tc);
        if (this.m_checkMaxLines.isSelected() && !this.m_textNumLines.getText().equals("")) {
            options.setMaxNumberOfLines(Integer.parseInt(this.m_textNumLines.getText()));
        } else if (!this.m_checkMaxLines.isSelected() || this.m_textNumLines.getText().equals("") || this.m_textNumLines.getText().equals("0")) {
            options.setMaxNumberOfLines(-1);
        }
        if (this.m_labelUserOutputDir.getText() == null || this.m_labelUserOutputDir.getText().equals("")) {
            options.setOfflineGenerationDirectory("");
        } else {
            options.setOfflineGenerationDirectory(this.m_labelUserOutputDir.getText());
        }
        options.setGenerateControllingScript(this.m_checkGenControlScript.isSelected());
        options.setGenerateComments(this.m_checkComments.isSelected());
        if (this.m_radioPerObject.isSelected()) {
            options.setFileOutputOption(2);
        } else if (this.m_radioSingle.isSelected()) {
            options.setFileOutputOption(0);
        }
        options.setSingleSchemaLeastPrivilege(this.m_checkSingleSchema.isSelected());
        options.setDataMoveUserFlag(this.m_generateDataMoveUserFlag.isSelected());
        options.setGenerateFailedObjects(this.m_generateFailedObjects.isSelected());
        options.setGenerateClobToBlob(this.m_generateClobToBlob.isSelected());
    }
}

