/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.text.ParseException;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.MaskFormatter;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class IdentitiferPreferencesPanel
extends DefaultTraversablePanel {
    public static final String TITLE = MigrationAddinArb.getString(223);
    private static final long serialVersionUID = 4843227636357117486L;
    private JTextField m_prefixText;
    private JLabel m_prefixTextLabel;
    private JCheckBox m_isQuotedIdentifierOn;
    private JLabel m_isQuotedIdentifierOnLabel;

    public IdentitiferPreferencesPanel() {
        this.initComponents();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_identprefgeneration_html");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        MaskFormatter prefixTextFormat = null;
        try {
            prefixTextFormat = new MaskFormatter("****");
        }
        catch (ParseException e) {
            // empty catch block
        }
        this.m_prefixText = new JTextField();
        this.m_prefixText.setColumns(4);
        this.m_prefixText.setSize(4, 2);
        this.m_prefixText.setAlignmentY(2.0f);
        this.m_prefixText.setHorizontalAlignment(2);
        this.m_prefixText.setText("");
        this.m_prefixTextLabel = new JLabel(MigrationAddinArb.getString(236));
        this.m_prefixTextLabel.setToolTipText(MigrationAddinArb.getString(237));
        this.m_prefixTextLabel.setLabelFor(this.m_prefixText);
        this.m_isQuotedIdentifierOn = new JCheckBox();
        this.m_isQuotedIdentifierOn.setAlignmentY(2.0f);
        this.m_isQuotedIdentifierOn.setHorizontalAlignment(2);
        this.m_isQuotedIdentifierOnLabel = new JLabel("Is Quoted Identifier On");
        this.m_isQuotedIdentifierOnLabel.setToolTipText("Is Quoted Identifier On");
        this.m_isQuotedIdentifierOnLabel.setLabelFor(this.m_isQuotedIdentifierOn);
        Box rootPanel = new Box(1);
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        FlowLayout panel1FlowLayout = new FlowLayout(0);
        panel1.setLayout(panel1FlowLayout);
        panel2.setLayout(new FlowLayout(0));
        panel1.add(this.m_prefixTextLabel);
        panel1.add(this.m_prefixText);
        panel2.add(this.m_isQuotedIdentifierOnLabel);
        panel2.add(this.m_isQuotedIdentifierOn);
        rootPanel.add(panel1);
        rootPanel.add(panel2);
        this.add(rootPanel, "North");
    }

    public void onEntry(TraversableContext tc) {
        MigrationConfig options = MigrationConfig.getInstance(tc.getPropertyStorage());
        super.onEntry(tc);
        this.load(options);
    }

    private void load(MigrationConfig options) {
        this.m_prefixText.setText(options.getNamePrefix());
        this.m_isQuotedIdentifierOn.setSelected(options.isQuotedIdentifierOn());
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        MigrationConfig options = MigrationConfig.getInstance(tc.getPropertyStorage());
        super.onExit(tc);
        String prependStr = this.m_prefixText.getText().trim();
        if (prependStr.length() > 4) {
            prependStr = prependStr.substring(0, 4);
        }
        options.setNamePrefix(prependStr);
        options.setisQuotedIdentifierOn(this.m_isQuotedIdentifierOn.isSelected());
    }
}

