/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeListener;

public final class MigrationConfig
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.dbtools.migration.workbench.core.preferences.MigrationWorkbenchOptions";
    private static final String KEY_END_ROW_DELIMITER = "EndRowDelimiter";
    private static final String DEFAULT_END_ROW_DELIMITER = "<EORD>";
    private static final String KEY_NAME_PREFIX = "NamePrefix";
    private static final String DEFAULT_NAME_PREFIX = "";
    private static final String KEY_END_COLUMN_DELIMITER = "EndColumnDelimiter";
    private static final String DEFAULT_END_COLUMN_DELIMITER = "<EOFD>";
    private static final String KEY_GENERATION_DIRECTORY = "OfflineGenerationDirectory";
    private static final String KEY_OFFLINE_DATAMOVE_SCRIPT_DIRECTORY = "DataMoveScriptDirectory";
    private static final String KEY_DATAMOVE_PARALLELISM = "DataMoveParallelism";
    private static final int DEFAULT_DATA_MOVE_PARALLELISM = 5;
    private static final String KEY_DATAMOVE_COMMITINTERVAL = "DataMoveCommitInterval";
    private static final int DEFAULT_DATA_MOVE_COMMIT_INTERVAL = 100;
    public static final int FILE_OUTPUT_SINGLE = 0;
    public static final int FILE_OUTPUT_PER_OBJECT = 2;
    public static final int UNLIMITED_LINES = -1;
    private static final String KEY_FILE_OUTPUT_OPTION = "FileOutputOption";
    private static final int DEFAULT_FILE_OUTPUT_OPTION = 0;
    private static final String KEY_OUTPUT_FILE_OR_DIR = "FileOutputTarget";
    private static final String KEY_GENERATE_CREATE_OR_REPLACE = "GenerateCreateOrReplace";
    private static final String KEY_GENERATE_COMMENTS = "GenerateComments";
    private static final String KEY_GENERATE_CONTROLLING_SCRIPT = "GenerateControllingScript";
    private static final String KEY_MAX_LINES = "MaxLinesPerFile";
    public static final String KEY_MIGRATION_REPOSITORIES = "MigrationRepositories";
    public static final String KEY_DEFAULT_REPOSITORY = "DefaultRepository";
    private static final String EMPTY_REPOSITORY = "";
    private static final String KEY_UA_CODE = "UserAgentCode";
    private static final String KEY_SINGLE_SCHEMA_LEAST_PRIVILEGE = "SingleSchemaLeastPrivilege";
    private static final String KEY_GENERATE_DATA_MOVE_USER = "GenerateDataMoveUser";
    private static final String DEFAULT_DATE_OFFLINE_DATA_MOVE_DATEMASK = "yyyy-mm-dd HH24:mi:ss";
    private static final String DEFAULT_TIMESTAMP_OFFLINE_DATA_MOVE_DATEMASK = "yyyy-mm-dd HH24:mi:ss.ff3";
    private static final String KEY_DATE_OFFLINE_DATA_MOVE_DATEMASK = "OfflineDateMask";
    private static final String KEY_TIMESTAMP_OFFLINE_DATA_MOVE_DATEMASK = "OfflineTimestampMask";
    private static final String KEY_GENERATE_FAILED_OBJECTS = "GeneratedFailedObjects";
    private static final String KEY_DATA_MOVE_ZERO_LENGTH_STRING_IS_SPACE = "DataMoveZeroLengthStringIsSpace";
    private static final String KEY_GENERATE_CLOB_TO_BLOB = "OfflineClobToBlob";
    public static final boolean DEFAULT_ISQUOTEDIDENTIFIERON = true;
    private static final String KEY_ISQUOTEDIDENTIFIERON = "ISQUOTEDIDENTIFIERON";

    private MigrationConfig(HashStructure hash) {
        super(hash);
    }

    public static MigrationConfig getInstance(PropertyStorage prefs) {
        return new MigrationConfig(MigrationConfig.findOrCreate((PropertyStorage)prefs, (String)DATA_KEY));
    }

    public void setTimestampOfflineDateMask(String timestampMask) {
        if (timestampMask != null) {
            this._hash.putString(KEY_TIMESTAMP_OFFLINE_DATA_MOVE_DATEMASK, timestampMask);
        }
    }

    public String getDateOfflineDateMask() {
        return this._hash.getString(KEY_DATE_OFFLINE_DATA_MOVE_DATEMASK, DEFAULT_DATE_OFFLINE_DATA_MOVE_DATEMASK);
    }

    public void setDateOfflineDateMask(String dateMask) {
        if (dateMask != null) {
            this._hash.putString(KEY_DATE_OFFLINE_DATA_MOVE_DATEMASK, dateMask);
        }
    }

    public String getTimeStampOfflineDateMask() {
        return this._hash.getString(KEY_TIMESTAMP_OFFLINE_DATA_MOVE_DATEMASK, DEFAULT_TIMESTAMP_OFFLINE_DATA_MOVE_DATEMASK);
    }

    public String getEndColumnDelimiter() {
        return this._hash.getString(KEY_END_COLUMN_DELIMITER, DEFAULT_END_COLUMN_DELIMITER);
    }

    public void setEndColumnDelimiter(String endColumnDelimiter) {
        if (endColumnDelimiter != null) {
            this._hash.putString(KEY_END_COLUMN_DELIMITER, endColumnDelimiter);
        }
    }

    public String getEndRowDelimiter() {
        return this._hash.getString(KEY_END_ROW_DELIMITER, DEFAULT_END_ROW_DELIMITER);
    }

    public void setEndRowDelimiter(String endRowDelimiter) {
        if (endRowDelimiter != null) {
            this._hash.putString(KEY_END_ROW_DELIMITER, endRowDelimiter);
        }
    }

    public String getNamePrefix() {
        return this._hash.getString(KEY_NAME_PREFIX, "");
    }

    public void setNamePrefix(String namePrefix) {
        if (namePrefix != null) {
            this._hash.putString(KEY_NAME_PREFIX, namePrefix);
        }
    }

    public boolean isQuotedIdentifierOn() {
        return this._hash.getBoolean(KEY_ISQUOTEDIDENTIFIERON, true);
    }

    public void setisQuotedIdentifierOn(boolean isQuotedIdentifierOn) {
        this._hash.putBoolean(KEY_ISQUOTEDIDENTIFIERON, isQuotedIdentifierOn);
    }

    public int getFileOutputOption() {
        return this._hash.getInt(KEY_FILE_OUTPUT_OPTION, 0);
    }

    public void setFileOutputOption(int fileOutputOption) {
        if (fileOutputOption >= 0 && fileOutputOption <= 2) {
            this._hash.putInt(KEY_FILE_OUTPUT_OPTION, fileOutputOption);
        }
    }

    public boolean getGenerateComments() {
        return this._hash.getBoolean(KEY_GENERATE_COMMENTS, true);
    }

    public void setEmptyStringIsSpace(boolean bVal) {
        this._hash.putBoolean(KEY_DATA_MOVE_ZERO_LENGTH_STRING_IS_SPACE, bVal);
    }

    public boolean getEmptyStringIsSpace() {
        return this._hash.getBoolean(KEY_DATA_MOVE_ZERO_LENGTH_STRING_IS_SPACE, true);
    }

    public void setGenerateComments(boolean bVal) {
        this._hash.putBoolean(KEY_GENERATE_COMMENTS, bVal);
    }

    public boolean getGenerateControllingScript() {
        return this._hash.getBoolean(KEY_GENERATE_CONTROLLING_SCRIPT, true);
    }

    public void setGenerateControllingScript(boolean bVal) {
        this._hash.putBoolean(KEY_GENERATE_CONTROLLING_SCRIPT, bVal);
    }

    public boolean getCreateOrReplaceFlag() {
        return this._hash.getBoolean(KEY_GENERATE_CREATE_OR_REPLACE, true);
    }

    public void setCreateOrReplaceFlag(boolean bVal) {
        this._hash.putBoolean(KEY_GENERATE_CREATE_OR_REPLACE, bVal);
    }

    public int getMaxNumberOfLines() {
        return this._hash.getInt(KEY_MAX_LINES, -1);
    }

    public void setMaxNumberOfLines(int n) {
        if (n <= 0) {
            this._hash.putInt(KEY_MAX_LINES, -1);
        } else {
            this._hash.putInt(KEY_MAX_LINES, n);
        }
    }

    public String getDefaultRepository() {
        return this._hash.getString(KEY_DEFAULT_REPOSITORY, "");
    }

    public synchronized void setDefaultRepository(String defaultRepository) {
        if (defaultRepository != null) {
            this._hash.putString(KEY_DEFAULT_REPOSITORY, defaultRepository);
        }
    }

    public int getNumDataMoveThreads() {
        return this._hash.getInt(KEY_DATAMOVE_PARALLELISM, 5);
    }

    public void setNumDataMoveThreads(int numThreads) {
        if (numThreads > 0) {
            this._hash.putInt(KEY_DATAMOVE_PARALLELISM, numThreads);
        }
    }

    public String getOfflineGenerationDirectory() {
        return this._hash.getString(KEY_GENERATION_DIRECTORY, System.getProperty("user.home"));
    }

    public void setOfflineGenerationDirectory(String directory) {
        if (directory != null) {
            this._hash.putString(KEY_GENERATION_DIRECTORY, directory);
        }
    }

    public String getOfflineDataMoveScriptDirectory() {
        return this._hash.getString(KEY_OFFLINE_DATAMOVE_SCRIPT_DIRECTORY, System.getProperty("user.home"));
    }

    public void setOfflinedataMoveScriptDirectory(String directory) {
        if (directory != null) {
            this._hash.putString(KEY_OFFLINE_DATAMOVE_SCRIPT_DIRECTORY, directory);
        }
    }

    private ListStructure getRepositoryListStructure() {
        ListStructure l = this._hash.getListStructure(KEY_MIGRATION_REPOSITORIES);
        if (l == null) {
            l = ListStructure.newInstance();
            this._hash.putListStructure(KEY_MIGRATION_REPOSITORIES, l);
        }
        return l;
    }

    public void addRepository(String migrepo) {
        ListStructure l = this.getRepositoryListStructure();
        if (!l.contains((Object)migrepo)) {
            l.add((Object)migrepo);
        }
    }

    public void removeRepository(String migrepo) {
        ListStructure l = this.getRepositoryListStructure();
        if (l.contains((Object)migrepo)) {
            l.remove((Object)migrepo);
            if (this.getDefaultRepository().equals(migrepo)) {
                if (l.size() > 0) {
                    String newDefaultRepo = (String)l.get(0);
                    this.setDefaultRepository(newDefaultRepo);
                } else {
                    this.setDefaultRepository("");
                }
            }
        }
    }

    public String[] getRepositories() {
        ListStructure l = this.getRepositoryListStructure();
        if (l == null) {
            String[] empty = new String[]{};
            return empty;
        }
        return (String[])l.toArray((Object[])new String[l.size()]);
    }

    public boolean isRepository(String name) {
        String[] repos;
        for (String repo : repos = this.getRepositories()) {
            if (!repo.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addStructureChangeListener(StructureChangeListener l) {
        this._hash.addStructureChangeListener(l);
    }

    public void removeStructureChangeListener(StructureChangeListener l) {
        this._hash.removeStructureChangeListener(l);
    }

    public int getDataMoveCommitInterval() {
        return this._hash.getInt(KEY_DATAMOVE_COMMITINTERVAL, 100);
    }

    public void setDataMoveCommitInterval(int i) {
        if (i < 1) {
            this._hash.putInt(KEY_DATAMOVE_COMMITINTERVAL, 1);
        } else {
            this._hash.putInt(KEY_DATAMOVE_COMMITINTERVAL, i);
        }
    }

    public int getUACode() {
        return this._hash.getInt(KEY_UA_CODE, 0);
    }

    public void setUACode(int uaCode) {
        this._hash.putInt(KEY_UA_CODE, uaCode);
    }

    public void updateUACode(int val) {
        int curr = this.getUACode();
        this.setUACode(curr |= val);
    }

    public boolean getSingleSchemaLeastPrivilege() {
        return this._hash.getBoolean(KEY_SINGLE_SCHEMA_LEAST_PRIVILEGE, false);
    }

    public void setSingleSchemaLeastPrivilege(boolean flag) {
        this._hash.putBoolean(KEY_SINGLE_SCHEMA_LEAST_PRIVILEGE, flag);
    }

    public boolean getGenerateDataMoveUserFlag() {
        return this._hash.getBoolean(KEY_GENERATE_DATA_MOVE_USER, false);
    }

    public void setDataMoveUserFlag(boolean flag) {
        this._hash.putBoolean(KEY_GENERATE_DATA_MOVE_USER, flag);
    }

    public boolean getGenerateClobToBlob() {
        return this._hash.getBoolean(KEY_GENERATE_CLOB_TO_BLOB, false);
    }

    public void setGenerateClobToBlob(boolean flag) {
        this._hash.putBoolean(KEY_GENERATE_CLOB_TO_BLOB, flag);
    }

    public boolean getBooleanProperty(String key) {
        return this._hash.getBoolean(key, false);
    }

    public void setBooleanProperty(String key, boolean flag) {
        this._hash.putBoolean(key, flag);
    }

    public void setStringProperty(String key, String property) {
        if (property != null) {
            this._hash.putString(key, property);
        }
    }

    public String getStringProperty(String key, String defaultString) {
        return this._hash.getString(key, defaultString);
    }

    public boolean getGenerateFailedObjects() {
        return this._hash.getBoolean(KEY_GENERATE_FAILED_OBJECTS, false);
    }

    public void setGenerateFailedObjects(boolean flag) {
        this._hash.putBoolean(KEY_GENERATE_FAILED_OBJECTS, flag);
    }
}

