/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPreferencesListener;
import oracle.dbtools.migration.workbench.core.ui.RepoRenderer;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public final class MigrationPreferences
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 7975900654635892548L;
    ArrayList<MigrationPreferencesListener> m_listeners = null;
    public static final String TITLE = "Migration";
    private static MigrationPreferences s_instance = null;
    private String[] m_repositoryTuples;
    private JComboBox m_repositoryCombo;

    public MigrationPreferences() {
        this.init();
        this.setHelpID("f1_migprefcore_html");
    }

    public static MigrationPreferences getInstance() {
        if (s_instance == null) {
            s_instance = new MigrationPreferences();
        }
        return s_instance;
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        JLabel defaultRepositoryLabel = new JLabel();
        defaultRepositoryLabel.setText(MigrationAddinArb.getString(452));
        GridBagConstraints repositoryLabelConstraints = new GridBagConstraints();
        repositoryLabelConstraints.anchor = 11;
        repositoryLabelConstraints.weighty = 1.0;
        repositoryLabelConstraints.weightx = 0.0;
        repositoryLabelConstraints.insets = new Insets(10, 10, 0, 10);
        repositoryLabelConstraints.gridy = 0;
        repositoryLabelConstraints.gridx = 0;
        this.add(defaultRepositoryLabel, repositoryLabelConstraints);
        this.m_repositoryCombo = new JComboBox();
        GridBagConstraints comboConstraints = new GridBagConstraints();
        comboConstraints.anchor = 11;
        comboConstraints.insets = new Insets(10, 0, 0, 10);
        comboConstraints.weightx = 4.0;
        comboConstraints.fill = 2;
        comboConstraints.gridy = 0;
        comboConstraints.gridx = 1;
        this.add(this.m_repositoryCombo, comboConstraints);
        this.m_repositoryCombo.setRenderer(new RepoRenderer());
    }

    public void onEntry(TraversableContext tc) {
        MigrationConfig options = MigrationConfig.getInstance(tc.getPropertyStorage());
        this.m_repositoryTuples = options.getRepositories();
        this.m_repositoryCombo.removeAllItems();
        String defaultRepo = options.getDefaultRepository();
        for (String s : this.m_repositoryTuples) {
            this.m_repositoryCombo.addItem(s);
            if (!s.equals(defaultRepo)) continue;
            this.m_repositoryCombo.setSelectedItem(s);
        }
    }

    public void onExit(TraversableContext tc) {
        MigrationConfig options = MigrationConfig.getInstance(tc.getPropertyStorage());
        if (this.m_repositoryCombo.getSelectedItem() != null) {
            options.setDefaultRepository((String)this.m_repositoryCombo.getSelectedItem());
        }
    }
}

