/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.Component;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.ui.YesToAllDialog;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.oviewer.base.ViewerEditor;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.model.Element;

public class DeleteCapturedConnection
extends AbstractMenuAction {
    public void launch() {
        Context ctx = this.getContext();
        Element[] els = ctx.getSelection();
        if (els == null || els.length == 0) {
            Element element = this.getDBObject().getElement();
            if (this.getContext().getView() instanceof ViewerEditor && element instanceof MigrationConnectionNode) {
                els = new Element[]{element};
            }
        }
        boolean deleteSuccess = false;
        boolean yesToAll = false;
        YesToAllDialog yesToAllDialog = null;
        String title = MigrationAddinArb.getString(69);
        String text = MigrationAddinArb.getString(68);
        for (int i = 0; i < els.length; ++i) {
            MigrationConnectionNode node;
            if (yesToAll) {
                node = (MigrationConnectionNode)els[i];
                deleteSuccess = CapturedDatabases.getInstance().deleteConnection(node);
                if (deleteSuccess) continue;
                this.showFailure();
                continue;
            }
            yesToAllDialog = new YesToAllDialog(title, "<html>" + text + "<br>" + els[i].getShortLabel() + "</html >", els.length > 1);
            if (yesToAllDialog.isYes() || yesToAllDialog.isYesToAll()) {
                node = (MigrationConnectionNode)els[i];
                deleteSuccess = CapturedDatabases.getInstance().deleteConnection(node);
                if (!deleteSuccess) {
                    this.showFailure();
                }
            } else if (yesToAllDialog.isNoToAll()) break;
            if (!yesToAllDialog.isYesToAll()) continue;
            yesToAll = true;
        }
    }

    private void showFailure() {
        MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(170), (String)MigrationAddinArb.getString(169), (String)"help", (boolean)false);
    }

    public void setArgs(String arg) {
    }
}

