/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.sql.Connection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.createRepository.RepositoryRegistry;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;

public final class DeleteRepoProgressRunnable
extends AbstractMigrationProgressRunnable {
    private final Connection _conn;
    private JPanel m_downJpanel;
    private JLabel m_downJlabel;
    private boolean _deleteStatus = true;

    public DeleteRepoProgressRunnable(Connection conn) {
        this._conn = conn;
    }

    public boolean getStatus() {
        return this._deleteStatus;
    }

    protected Object doWork() throws Exception {
        this.getProgBar().getCancelButton().setEnabled(false);
        this.getProgBar().setExitOnDone(true);
        this._deleteStatus = RepositoryRegistry.dropRepository(this._conn, this);
        return this._deleteStatus;
    }

    protected void finish(Object result) {
    }

    public JPanel getDownPanel() {
        if (this.m_downJpanel == null) {
            this.m_downJpanel = new JPanel();
            BorderLayout secondLayout = new BorderLayout();
            this.m_downJpanel.setLayout(secondLayout);
            this.m_downJlabel = new JLabel();
            this.m_downJpanel.add((Component)this.m_downJlabel, "West");
            this.m_downJlabel.setText(MigrationAddinArb.getString(45));
        }
        return this.m_downJpanel;
    }

    public JPanel getTopPanel() {
        return null;
    }

    public void updateAbovePanel(Object object) {
    }

    public void updateBelowPanel(final Object text) {
        if (text instanceof String) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        DeleteRepoProgressRunnable.this.m_downJlabel.setText((String)text);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

