/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import oracle.dbtools.metadata.persistence.CloseableResultSet;

public class PrivilegeManager {
    private Hashtable<String, Privilege> m_privileges;
    private Hashtable<String, Privilege> m_roles;
    private boolean m_sysDba = false;

    public PrivilegeManager(Connection conn) throws SQLException {
        this.loadPrivileges(conn);
        if (!this.m_sysDba) {
            this.loadRoles(conn);
        }
    }

    public boolean hasRole(String roleName) {
        if (this.m_sysDba) {
            return true;
        }
        return this.m_roles.containsKey(roleName);
    }

    public boolean hasPrivilege(String privName) {
        if (this.m_sysDba) {
            return true;
        }
        return this.m_privileges.containsKey(privName);
    }

    public boolean hasPrivilegeWithAdmin(String privName) {
        if (this.m_sysDba) {
            return true;
        }
        Privilege p = this.m_privileges.get(privName);
        return p != null && p.isGrantable();
    }

    public boolean hasRoleWithAdmin(String roleName) {
        if (this.m_sysDba) {
            return true;
        }
        Privilege role = this.m_roles.get(roleName);
        return role != null && role.isGrantable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrivileges(Connection conn) throws SQLException {
        this.m_sysDba = this.checkSysDba(conn);
        if (this.m_sysDba) {
            return;
        }
        this.m_privileges = new Hashtable();
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            String sql = "select PRIVILEGE, ADMIN_OPTION from role_sys_privs where role in (select role from session_roles)UNION select PRIVILEGE, ADMIN_OPTION from user_sys_privs";
            stmt = conn.prepareStatement(sql);
            rset = stmt.executeQuery();
            while (rset.next()) {
                String name = rset.getString("PRIVILEGE");
                String admin = rset.getString("ADMIN_OPTION");
                this.m_privileges.put(name, new Privilege(name, !admin.equals("NO")));
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                rset.close();
                stmt.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            rset.close();
            stmt.close();
        }
        catch (Exception e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRoles(Connection conn) throws SQLException {
        this.m_roles = new Hashtable();
        String sql = "SELECT GRANTED_ROLE, ADMIN_OPTION FROM USER_ROLE_PRIVS A, USER_USERS B WHERE A.USERNAME = B.USERNAME";
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            stmt = conn.prepareStatement(sql);
            rset = stmt.executeQuery();
            while (rset.next()) {
                String name = rset.getString("GRANTED_ROLE");
                String admin = rset.getString("ADMIN_OPTION");
                this.m_roles.put(name, new Privilege(name, !admin.equals("NO")));
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                rset.close();
                stmt.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            rset.close();
            stmt.close();
        }
        catch (Exception e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSysDba(Connection conn) throws SQLException {
        boolean bl;
        String sql = "select count(*) from session_privs where privilege = 'SYSDBA'";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            rs.next();
            int res = rs.getInt(1);
            bl = res != 0;
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close(stmt, rs);
        return bl;
    }

    public static class Privilege {
        private String m_name;
        private boolean m_grantable;

        public Privilege(String name, boolean grantable) {
            this.setName(name);
            this.setGrantable(grantable);
        }

        public boolean isGrantable() {
            return this.m_grantable;
        }

        public String getName() {
            return this.m_name;
        }

        protected void setGrantable(boolean grantable) {
            this.m_grantable = grantable;
        }

        protected void setName(String name) {
            this.m_name = name;
        }
    }
}

