/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.Component;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSequence;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationRepositoryDatabases;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class RenameNodeAction
extends AbstractMenuAction {
    private static final String RENAME_TITLE = MigrationAddinArb.getString(176);
    private MigrationRepositoryDatabases m_instance;

    public void launch() {
        DBObject dbo = this.getDBObject();
        try {
            if ("MD_VIEW".equals(dbo.getObjectType())) {
                this.handleViewRename(dbo);
            } else if ("USER".equals(dbo.getObjectType())) {
                this.handleSchemaRename(dbo);
            } else if ("MD_TABLE".equals(dbo.getObjectType())) {
                this.handleTableRename(dbo);
            } else if ("MD_PROCEDURE".equals(dbo.getObjectType())) {
                this.handleProcedureRename(dbo);
            } else if ("MD_FUNCTION".equals(dbo.getObjectType())) {
                this.handleFunctionRename(dbo);
            } else if ("MD_COLUMNS".equals(dbo.getObjectType())) {
                this.handleColumnRename(dbo);
            } else if ("MD_SEQUENCE".equals(dbo.getObjectType())) {
                this.handleSequenceRename(dbo);
            } else if ("MD_TRIGGER".equals(dbo.getObjectType())) {
                this.handleTriggerRename(dbo);
            } else if ("MD_INDEX".equals(dbo.getObjectType())) {
                this.handleIndexRename(dbo);
            }
        }
        catch (PersistenceException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.SEVERE, e.getMessage(), e);
        }
        catch (NoSuchObjectException e) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void handleIndexRename(DBObject dbo) throws PersistenceException, NoSuchObjectException {
        if (dbo.getElement() instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)dbo.getElement();
            DBObjectId objectId = MigrationURLFormatHelper.getObjectId(dbo.getURL());
            SimpleInputDialog dlg = new SimpleInputDialog((Component)Ide.getMainWindow());
            String shortLabel = node.getShortLabel();
            String[] split = shortLabel.split("\\(");
            dlg.setInputValue(split[0].trim());
            if (dlg.show(RENAME_TITLE, MigrationAddinArb.getString(177), "helprenameindex")) {
                MdIndexe indexInstance = MdIndexe.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objectId);
                String newName = dlg.getInputValue();
                indexInstance.rename(newName);
                indexInstance.save(MigrationAddin.getPersistenceManager());
                UpdateMessage.fireObjectRenamed((Subject)this.m_instance);
            }
        }
    }

    private void handleTriggerRename(DBObject dbo) throws PersistenceException, NoSuchObjectException {
        if (dbo.getElement() instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)dbo.getElement();
            DBObjectId objectId = MigrationURLFormatHelper.getObjectId(dbo.getURL());
            SimpleInputDialog dlg = new SimpleInputDialog((Component)Ide.getMainWindow());
            dlg.setInputValue(node.getShortLabel());
            if (dlg.show(RENAME_TITLE, MigrationAddinArb.getString(177), "helprenametrigger")) {
                MdTrigger triggerInstance = MdTrigger.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objectId);
                String newName = dlg.getInputValue();
                triggerInstance.rename(newName);
                triggerInstance.save(MigrationAddin.getPersistenceManager());
                UpdateMessage.fireObjectRenamed((Subject)this.m_instance);
            }
        }
    }

    private void handleSequenceRename(DBObject dbo) throws PersistenceException, NoSuchObjectException {
        if (dbo.getElement() instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)dbo.getElement();
            DBObjectId objectId = MigrationURLFormatHelper.getObjectId(dbo.getURL());
            SimpleInputDialog dlg = new SimpleInputDialog((Component)Ide.getMainWindow());
            dlg.setInputValue(node.getShortLabel());
            if (dlg.show(RENAME_TITLE, MigrationAddinArb.getString(177), "helprenamesequence")) {
                MdSequence sequenceInstance = MdSequence.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objectId);
                String newName = dlg.getInputValue();
                sequenceInstance.rename(newName);
                sequenceInstance.save(MigrationAddin.getPersistenceManager());
                UpdateMessage.fireObjectRenamed((Subject)this.m_instance);
            }
        }
    }

    private void handleColumnRename(DBObject dbo) throws PersistenceException, NoSuchObjectException {
        if (dbo.getElement() instanceof ChildObjectElement) {
            ChildObjectElement node = (ChildObjectElement)dbo.getElement();
            DBObjectId objectId = MigrationURLFormatHelper.getColumnId(dbo.getURL());
            SimpleInputDialog dlg = new SimpleInputDialog((Component)Ide.getMainWindow());
            dlg.setInputValue(node.getShortLabel());
            if (dlg.show(RENAME_TITLE, MigrationAddinArb.getString(177), "helprenamecolumn")) {
                MdColumn columnInstance = MdColumn.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objectId);
                String newName = dlg.getInputValue();
                columnInstance.rename(newName);
                columnInstance.save(MigrationAddin.getPersistenceManager());
                UpdateMessage.fireObjectRenamed((Subject)this.m_instance);
            }
        }
    }

    private void handleFunctionRename(DBObject dbo) throws PersistenceException, NoSuchObjectException {
        if (dbo.getElement() instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)dbo.getElement();
            DBObjectId objectId = MigrationURLFormatHelper.getObjectId(dbo.getURL());
            SimpleInputDialog dlg = new SimpleInputDialog((Component)Ide.getMainWindow());
            dlg.setInputValue(node.getShortLabel());
            if (dlg.show(RENAME_TITLE, MigrationAddinArb.getString(177), "helprenamefunction")) {
                MdStoredProgram functionInstance = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objectId);
                String newName = dlg.getInputValue();
                functionInstance.setName(newName);
                functionInstance.save(MigrationAddin.getPersistenceManager());
                UpdateMessage.fireObjectRenamed((Subject)this.m_instance);
            }
        }
    }

    private void handleProcedureRename(DBObject dbo) throws PersistenceException, NoSuchObjectException {
        if (dbo.getElement() instanceof CapturedNode || dbo.getElement() instanceof ObjectNode) {
            Node node = (Node)dbo.getElement();
            DBObjectId objectId = MigrationURLFormatHelper.getObjectId(dbo.getURL());
            SimpleInputDialog dlg = new SimpleInputDialog((Component)Ide.getMainWindow());
            dlg.setInputValue(node.getShortLabel());
            if (dlg.show(RENAME_TITLE, MigrationAddinArb.getString(177), "helprenameprocedure")) {
                MdStoredProgram procedureInstance = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objectId);
                String newName = dlg.getInputValue();
                procedureInstance.rename(newName);
                procedureInstance.save(MigrationAddin.getPersistenceManager());
                UpdateMessage.fireObjectRenamed((Subject)this.m_instance);
            }
        }
    }

    private void handleTableRename(DBObject dbo) throws PersistenceException, NoSuchObjectException {
        if (dbo.getElement() instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)dbo.getElement();
            DBObjectId objectId = MigrationURLFormatHelper.getObjectId(dbo.getURL());
            SimpleInputDialog dlg = new SimpleInputDialog((Component)Ide.getMainWindow());
            dlg.setInputValue(node.getShortLabel());
            if (dlg.show(RENAME_TITLE, MigrationAddinArb.getString(177), "helprenametable")) {
                MdTable tableInstance = MdTable.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objectId);
                String newName = dlg.getInputValue();
                tableInstance.rename(newName);
                tableInstance.save(MigrationAddin.getPersistenceManager());
                UpdateMessage.fireObjectRenamed((Subject)this.m_instance);
            }
        }
    }

    private void handleSchemaRename(DBObject dbo) throws PersistenceException, NoSuchObjectException {
        if (dbo.getElement() instanceof SchemaFolder) {
            SchemaFolder node = (SchemaFolder)dbo.getElement();
            DBObjectId objectId = MigrationURLFormatHelper.getSchemaId(dbo.getURL());
            MdSchema schemaInstance = MdSchema.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objectId);
            SimpleInputDialog dlg = new SimpleInputDialog((Component)Ide.getMainWindow());
            dlg.setInputValue(node.getShortLabel());
            if (dlg.show(RENAME_TITLE, MigrationAddinArb.getString(177), "helprenameschema")) {
                String newName = dlg.getInputValue();
                schemaInstance.setName(newName);
                schemaInstance.save(MigrationAddin.getPersistenceManager());
                UpdateMessage.fireObjectRenamed((Subject)this.m_instance);
                UpdateMessage.fireStructureChanged((Subject)this.m_instance, Collections.singletonList(schemaInstance));
            }
        }
    }

    private void handleViewRename(DBObject dbo) throws PersistenceException, NoSuchObjectException {
        if (dbo.getElement() instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)dbo.getElement();
            DBObjectId objectId = MigrationURLFormatHelper.getObjectId(dbo.getURL());
            SimpleInputDialog dlg = new SimpleInputDialog((Component)Ide.getMainWindow());
            dlg.setInputValue(node.getShortLabel());
            if (dlg.show(RENAME_TITLE, MigrationAddinArb.getString(177), "helprenameview")) {
                MdView viewInstance = MdView.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objectId);
                String newName = dlg.getInputValue();
                viewInstance.setViewName(newName);
                viewInstance.save(MigrationAddin.getPersistenceManager());
                UpdateMessage.fireObjectRenamed((Subject)this.m_instance);
            }
        }
    }

    public void setArgs(String args) {
        this.m_instance = "CAPTURED".equals(args) ? CapturedDatabases.getInstance() : ConvertedDatabases.getInstance();
    }
}

