/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Connection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;

public final class RepositoryDialog {
    private JEWTDialog m_dlg = null;
    private String m_dbName = null;
    private DBObject m_dbObject;
    private static final long serialVersionUID = -1190029218127406490L;

    public RepositoryDialog(DBObject object) {
        this.setDbName(object.getObjectName());
        this.m_dbObject = object;
        this.initialize();
    }

    private void initialize() {
        String title = "";
        String message = "";
        JButton button = null;
        boolean exists = true;
        MigrationConfig config = MigrationAddin.getMigrationConfig();
        exists = config.isRepository(this.getDbName());
        if (exists) {
            title = MigrationAddinArb.getString(106);
            message = MigrationAddinArb.getString(108);
            button = new JButton(MigrationAddinArb.getString(112));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RepositoryManager.removeRepository(RepositoryDialog.this.getDbName());
                    RepositoryDialog.this.m_dlg.closeDialog(true);
                }
            });
        } else {
            title = MigrationAddinArb.getString(105);
            message = MigrationAddinArb.getString(107);
            button = new JButton(MigrationAddinArb.getString(111));
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    RepositoryDialog.this.m_dlg.closeDialog(true);
                    URL u = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)RepositoryDialog.this.getDbName());
                    DBObject object = new DBObject(u);
                    if (!RepositoryManager.gotUserPermission(object)) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(418), null, null);
                        return;
                    }
                    RepositoryManager.findOrCreateRepositoryTables(object.getConnectionName());
                }
            });
        }
        JPanel msgPanel = new JPanel();
        JLabel msgLabel = new JLabel(message);
        msgPanel.add(msgLabel);
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)msgPanel, null, (String)title, (int)6);
        Dimension dim = msgPanel.getPreferredSize();
        int h = (int)dim.getHeight() + 100;
        int w = (int)dim.getWidth() + 100;
        this.m_dlg.setSize(w, h);
        this.m_dlg.setPreferredSize(w, h);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.m_dlg);
        this.m_dlg.addCustomButton((Component)button);
        JButton otherButton = new JButton("Test");
        otherButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    URL u = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)RepositoryDialog.this.getDbName());
                    DBObject object = new DBObject(u);
                    Connection conn = Connections.getInstance().getConnection(RepositoryDialog.this.getDbName());
                    int currentRepoVersion = RepositoryManager.getCurentRepoVersion(conn);
                    if (!RepositoryManager.gotUserPermission(object)) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(420), null, null);
                        return;
                    }
                    RepositoryManager.upgradeRepository(object.getConnectionName(), currentRepoVersion);
                }
                catch (DBException dbe) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Cannot identify Connection to upgrade repository", null, null);
                }
            }
        });
        this.m_dlg.addCustomButton((Component)otherButton);
    }

    protected JEWTDialog getDialog() {
        return this.m_dlg;
    }

    private String getDbName() {
        return this.m_dbName;
    }

    private void setDbName(String dbName) {
        this.m_dbName = dbName;
    }

    public void setVisible(boolean b) {
        this.getDialog().setVisible(b);
    }
}

