/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.Component;
import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.metadata.createRepository.CallRunScripts;
import oracle.dbtools.metadata.createRepository.RunRepositoryScripts;
import oracle.dbtools.metadata.createRepository.UpgradeRunner;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.repository.DeleteRepoProgressRunnable;
import oracle.dbtools.migration.workbench.core.repository.RepositoryDialog;
import oracle.dbtools.migration.workbench.core.repository.RepositoryException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.db.DBException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryManager {
    public static final String CREATE_SCRIPT_NAME = "CREATE_REPOSITORY.sql";
    public static final String REMOVE_SCRIPT_NAME = "removeRepository.sql";
    public static final String PURGE_SCRIPT_NAME = "purgeRepository.sql";
    public static final int REPO_VERSION = 19;
    private static final String REPO_CREATE_SCRIPT = "CREATE_REPOSITORY.sql";
    RepositoryManager m_rman = null;
    private static DBObject m_dbObject;
    private static int FAILED_TO_GET_VERSION;
    private static final String UPGRADE_STUB = "upgrade_";
    private static final String UPGRADE_EXTENSION = ".sql";

    public void openRepositoryRegDialog(DBObject object) {
        RepositoryDialog dlg = new RepositoryDialog(object);
        m_dbObject = object;
        dlg.setVisible(true);
    }

    private static String[] getAssociatedRepos() {
        MigrationConfig config = MigrationAddin.getMigrationConfig();
        String[] repos = config.getRepositories();
        return repos;
    }

    public static void installRepository(DBObject object) {
        RepositoryManager.findOrCreateRepositoryTables(object.getConnectionName());
    }

    public static boolean removeRepository(String dbName) {
        try {
            Connection conn = Connections.getInstance().getConnection(dbName);
            MigrationConfig config = MigrationAddin.getMigrationConfig();
            DeleteRepoProgressRunnable progressRunnable = new DeleteRepoProgressRunnable(conn);
            if (conn != null) {
                progressRunnable.setUseBuzyBar(false);
                progressRunnable.updateBelowPanel(MigrationAddinArb.getString(209));
                progressRunnable.setTitle(MigrationAddinArb.getString(46));
                progressRunnable.start(true);
                config.removeRepository(dbName);
                return progressRunnable.getStatus();
            }
            Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, "RepositoryManager.CONNECTION_ERROR", dbName);
        }
        catch (Exception e) {
            MigrationLogUtil.logThrowable(e.getMessage(), new Object[0], (Throwable)e);
        }
        return false;
    }

    public static void removeDbNameFromconfig(String dbName) {
        String[] repos;
        for (String repo : repos = RepositoryManager.getAssociatedRepos()) {
            if (!repo.equals(dbName)) continue;
            MigrationAddin.getMigrationConfig().removeRepository(repo);
        }
    }

    public static boolean findOrCreateRepositoryTables(String connName) {
        MigrationConfig config = MigrationAddin.getMigrationConfig();
        RunRepositoryScripts rrs = null;
        try {
            Connection conn = Connections.getInstance().getConnection(connName);
            if (conn != null) {
                if (RepositoryManager.doesRepositoryExist(conn)) {
                    config.addRepository(connName);
                    config.setDefaultRepository(connName);
                    return true;
                }
            } else {
                throw new Exception("null returned from getConnection()");
            }
            rrs = new RunRepositoryScripts(conn);
            CallRunScripts crs = new CallRunScripts(rrs, 1);
            crs.setScript("CREATE_REPOSITORY.sql");
            crs.start(true);
            if (rrs.getSuccess().equals(Boolean.TRUE)) {
                config.addRepository(connName);
                config.setDefaultRepository(connName);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean doesRepositoryExist(Connection conn) {
        if (conn == null) {
            return false;
        }
        boolean retVal = false;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = conn.createStatement();
                rs = stmt.executeQuery("select count(*) from md_connections");
                if (rs.next()) {
                    retVal = true;
                }
                retVal = false;
            }
            catch (SQLException e) {
                retVal = false;
                Object var6_5 = null;
                CloseableResultSet.close(stmt, rs);
                return retVal;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close(stmt, rs);
        return retVal;
    }

    public static boolean purgeRepository(Connection conn) {
        block4: {
            RunRepositoryScripts rrs = null;
            try {
                if (conn == null) break block4;
                if (RepositoryManager.doesRepositoryExist(conn)) {
                    rrs = new RunRepositoryScripts(conn);
                    CallRunScripts crs = new CallRunScripts(rrs, 4);
                    crs.setScript(PURGE_SCRIPT_NAME);
                    crs.start(true);
                    if (!rrs.wasCancelled() && rrs.getSuccess().equals(Boolean.TRUE)) {
                        String name = Connections.getInstance().getConnectionName(conn);
                        MigrationAddin.disconnectRepository();
                        MigrationAddin.openRepository(name);
                    }
                    break block4;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static void checkRepository(DBObject object) {
        MigrationConfig config = MigrationAddin.getMigrationConfig();
        Connections cm = Connections.getInstance();
        Connection conn = null;
        try {
            conn = cm.getConnection(object.getConnectionName());
        }
        catch (DBException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        String connName = object.getConnectionName();
        if (!RepositoryManager.repoAssociated(connName)) {
            config.addRepository(connName);
        }
        if (RepositoryManager.doesRepositoryExist(conn)) {
            if (RepositoryManager.checkRepoVersion(conn)) {
                if (RepositoryManager.checkRepoValid(conn)) {
                    return;
                }
                RepositoryManager.removeRepository(connName);
                RepositoryManager.installRepository(object);
            } else {
                int currentRepoVersion = RepositoryManager.getCurentRepoVersion(conn);
                if (currentRepoVersion < 19) {
                    RepositoryManager.upgradeRepository(object.getConnectionName(), currentRepoVersion);
                }
            }
        } else {
            RepositoryManager.installRepository(object);
        }
    }

    public static boolean upgradeRepository(String connName, int currentRepoVersion) {
        int softwareVsn = 19;
        RunRepositoryScripts rrs = null;
        ArrayList<String> upgradeScripts = null;
        Connections cm = Connections.getInstance();
        Connection conn = null;
        try {
            upgradeScripts = RepositoryManager.getUpgradeScripts();
            conn = cm.getConnection(connName);
        }
        catch (RepositoryException re) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(58), null, null);
            return false;
        }
        catch (DBException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        rrs = new RunRepositoryScripts(conn);
        UpgradeRunner runner = new UpgradeRunner(currentRepoVersion, softwareVsn, upgradeScripts, rrs);
        try {
            runner.start(true);
        }
        catch (Exception e) {
            Logger.getLogger(RepositoryManager.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            return false;
        }
        return !rrs.getSuccess().equals(Boolean.FALSE);
    }

    public static String findNextUpgradeScript(int cuurentRepoVsn, ArrayList<String> upgradeScripts) {
        for (String s : upgradeScripts) {
            if (!s.startsWith(UPGRADE_STUB + cuurentRepoVsn + "_")) continue;
            return s;
        }
        return null;
    }

    public static ArrayList<String> getUpgradeScripts() throws RepositoryException {
        ArrayList<String> fileList = new ArrayList<String>();
        String packageDir = "oracle.dbtools.metadata.createRepository";
        try {
            for (URL u : FileUtils.getFilesInPackage((String)packageDir, (String)"sql")) {
                File file = new File(u.getFile());
                if (!file.getName().startsWith(UPGRADE_STUB) || !file.getName().endsWith(UPGRADE_EXTENSION)) continue;
                fileList.add(file.getName());
            }
        }
        catch (Exception e) {
            throw new RepositoryException();
        }
        return fileList;
    }

    private static boolean checkRepoValid(Connection conn) {
        return RepositoryManager.getCurentRepoVersion(conn) <= 19;
    }

    private static boolean repoAssociated(String connName) {
        String[] repos;
        for (String repo : repos = RepositoryManager.getAssociatedRepos()) {
            if (!repo.equals(connName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCurentRepoVersion(Connection conn) {
        int revision = 0;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            block4: {
                try {
                    if (conn == null) break block4;
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery("SELECT REVISION FROM MD_REPOVERSIONS");
                    rs.next();
                    revision = rs.getInt("REVISION");
                }
                catch (SQLException se) {
                    int n = FAILED_TO_GET_VERSION;
                    Object var7_5 = null;
                    CloseableResultSet.close(stmt, rs);
                    return n;
                }
            }
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            CloseableResultSet.close(stmt, rs);
            throw throwable;
        }
        CloseableResultSet.close(stmt, rs);
        return revision;
    }

    private static boolean checkRepoVersion(Connection conn) {
        return RepositoryManager.getCurentRepoVersion(conn) == 19;
    }

    public static boolean gotUserPermission(DBObject object) {
        String[] o = new String[]{"TABLE", "VIEW", "SEQUENCE", "PROCEDURE", "TYPE"};
        String[] privs = RepositoryManager.getUserPrivileges(object);
        for (int i = 0; i < o.length; ++i) {
            boolean found = false;
            for (int j = 0; j < privs.length; ++j) {
                if (!privs[j].contains(o[i])) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean testUserPrivileges(DBObject dbObject, String type) {
        HashMap<String, String> binds = new HashMap<String, String>();
        Statement stmt = null;
        ResultSet rset = null;
        boolean flag = false;
        String sql = "select PRIVILEGE from role_sys_privs where role in (select role from session_roles)AND PRIVILEGE LIKE '%:TYPE%' UNION select privilege from user_sys_privs WHERE PRIVILEGE LIKE '%TYPE%'";
        try {
            try {
                binds.clear();
                binds.put("OWNER", dbObject.getSchemaName());
                binds.put("TYPE", type);
                stmt = dbObject.getConnection().prepareStatement(sql);
                DBUtil.getInstance().bind((PreparedStatement)stmt, binds);
                rset = stmt.executeQuery();
                flag = rset.next();
            }
            catch (SQLException e) {
                boolean bl = flag;
                Object var10_8 = null;
                try {
                    rset.close();
                    stmt.close();
                    return bl;
                }
                catch (SQLException e2) {
                    return flag;
                }
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            try {}
            catch (SQLException e2) {
                return flag;
            }
            rset.close();
            stmt.close();
            throw throwable;
        }
        try {}
        catch (SQLException e2) {
            return flag;
        }
        rset.close();
        stmt.close();
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String[] getUserPrivileges(Connection conn) {
        ArrayList<String> privs;
        block10: {
            if (conn == null) {
                return new String[0];
            }
            privs = new ArrayList<String>();
            HashMap binds = new HashMap();
            PreparedStatement stmt = null;
            ResultSet rset = null;
            String sql = "select PRIVILEGE from role_sys_privs where role in (select role from session_roles)UNION select PRIVILEGE from user_sys_privs";
            binds.clear();
            stmt = conn.prepareStatement(sql);
            DBUtil.getInstance().bind(stmt, binds);
            rset = stmt.executeQuery();
            while (rset.next()) {
                privs.add(rset.getString("PRIVILEGE"));
            }
            Object var8_6 = null;
            try {
                rset.close();
                stmt.close();
            }
            catch (Exception e2) {}
            break block10;
            {
                catch (SQLException e) {
                    Object var8_7 = null;
                    try {
                        rset.close();
                        stmt.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    rset.close();
                    stmt.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return privs.toArray(new String[privs.size()]);
    }

    public static String[] getUserPrivileges(DBObject dbObject) {
        return RepositoryManager.getUserPrivileges(dbObject.getConnection());
    }

    public static void renameConnection(String oldName, String newName) {
        RepositoryManager.removeDbNameFromconfig(oldName);
        MigrationAddin.getMigrationConfig().addRepository(newName);
        if (Connections.getInstance().isConnectionOpen(newName)) {
            MigrationAddin.openRepository(newName);
        }
    }

    static {
        FAILED_TO_GET_VERSION = 999;
    }
}

