/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.Component;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationRepositoryDatabases;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class UpdateColumnDefaultAction
extends AbstractMenuAction {
    private MigrationRepositoryDatabases m_instance;
    private static final String TITLE = MigrationAddinArb.getString(178);

    public void launch() {
        DBObject dbo = this.getDBObject();
        if (dbo.getElement() instanceof ChildObjectElement) {
            try {
                ChildObjectElement node = (ChildObjectElement)dbo.getElement();
                DBObjectId objectId = MigrationURLFormatHelper.getColumnId(dbo.getURL());
                SimpleInputDialog dlg = new SimpleInputDialog((Component)Ide.getMainWindow());
                MdColumn columnInstance = MdColumn.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objectId);
                dlg.setInputValue(columnInstance.getDefaultValue());
                if (dlg.show(TITLE, MigrationAddinArb.getString(179), null)) {
                    String newDefault = dlg.getInputValue();
                    columnInstance.setDefaultValue(newDefault);
                    columnInstance.save(MigrationAddin.getPersistenceManager());
                    UpdateMessage.fireObjectRenamed((Subject)this.m_instance);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setArgs(String args) {
        this.m_instance = args.equals("CONVERTED") ? ConvertedDatabases.getInstance() : null;
    }
}

