/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationRepositoryDatabases;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.migration.workbench.core.repository.UpdateTypePanel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class UpdateColumnTypeAction
extends AbstractMenuAction {
    private MigrationRepositoryDatabases m_instance;

    public void launch() {
        DBObject dbo = this.getDBObject();
        if (dbo.getElement() instanceof ChildObjectElement) {
            DBObjectId objectId = MigrationURLFormatHelper.getColumnId(dbo.getURL());
            try {
                final MdColumn columnInstance = MdColumn.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), objectId);
                SupportedDataTypesMap supportedDataTypeMap = this.getSupportedDataTypeMap();
                DataTypeSpecification[] sourceDataTypes = null;
                sourceDataTypes = this.m_instance instanceof ConvertedDatabases ? this.getAllTargetDataType(supportedDataTypeMap) : supportedDataTypeMap.getSourceDataTypes();
                final UpdateTypePanel updatePanel = new UpdateTypePanel(sourceDataTypes);
                updatePanel.setCurrentColumnType(columnInstance.getColumnType(), columnInstance.getPrecision(), columnInstance.getScale());
                int buttonMask = 14;
                ActionListener close = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (e.getActionCommand() == "apply") {
                            String newType = updatePanel.getTypeName();
                            Integer newPrecision = updatePanel.getPrecision();
                            Integer newScale = updatePanel.getScale();
                            columnInstance.setColumnType(newType);
                            columnInstance.setPrecision(newPrecision);
                            columnInstance.setScale(newScale);
                            try {
                                columnInstance.save(MigrationAddin.getPersistenceManager());
                            }
                            catch (PersistenceException e1) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e1.getStackTrace()[0].toString(), e1);
                            }
                            UpdateMessage.fireStructureChanged((Subject)UpdateColumnTypeAction.this.m_instance);
                            ((JEWTDialog)e.getSource()).closeDialog(true);
                            UpdateMessage.fireStructureChanged((Subject)UpdateColumnTypeAction.this.m_instance);
                        }
                    }
                };
                HelpSystem.getHelpSystem().registerTopic((JComponent)updatePanel, "f1_updatecolumntype_html");
                String title = "Change Type";
                UIUtils.showPanelAsDialog((JPanel)updatePanel, (String)title, (ActionListener)close, (int)buttonMask, (boolean)true);
            }
            catch (PersistenceException pex) {
                MigrationLogUtil.logThrowable(pex.getMessage(), "", (Throwable)pex);
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, pex.getStackTrace()[0].toString(), pex);
            }
            catch (NoSuchObjectException nsoe) {
                MigrationLogUtil.logThrowable(nsoe.getMessage(), "", (Throwable)nsoe);
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, nsoe.getStackTrace()[0].toString(), nsoe);
            }
        }
    }

    private DataTypeSpecification[] getAllTargetDataType(SupportedDataTypesMap supportedDataTypeMap) {
        ArrayList<DataTypeSpecification> allTargetValueList = new ArrayList<DataTypeSpecification>();
        if (supportedDataTypeMap == null) {
            return new DataTypeSpecification[0];
        }
        for (DataTypeSpecification srcDataTypeSpecification : supportedDataTypeMap.getSourceDataTypes()) {
            DataTypeMappingRule[] rulesForDataType = supportedDataTypeMap.getRulesForDataType(srcDataTypeSpecification);
            for (int i = 0; i < rulesForDataType.length; ++i) {
                allTargetValueList.add(rulesForDataType[i].getTargetDataType());
            }
        }
        return allTargetValueList.toArray(new DataTypeSpecification[0]);
    }

    private SupportedDataTypesMap getSupportedDataTypeMap() throws PersistenceException, NoSuchObjectException {
        SupportedDataTypesMap supportedDataTypesMap = null;
        try {
            Element element = this.getDBObject().getElement();
            DBObjectId s = MigrationURLFormatHelper.getSchemaId(((ChildObjectElement)element).getURL());
            MdSchema schema = MdSchema.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), s);
            MdCatalog catalog = MdCatalog.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), schema.getCatalogId());
            MdConnection mdConnection = MdConnection.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), catalog.getConnectionId());
            String sPluginId = mdConnection.getProperty("PLUGIN_ID");
            if (sPluginId == null) {
                return null;
            }
            MigrationPlugin plugin = MigrationAddin.findPlugin(sPluginId);
            if (plugin == null) {
                return null;
            }
            supportedDataTypesMap = plugin.getSupportedDataTypesMap();
        }
        catch (MigrationPluginException migrationPluginException) {
            MigrationLogUtil.logThrowable(migrationPluginException.getMessage(), "", (Throwable)migrationPluginException);
            return null;
        }
        return supportedDataTypesMap;
    }

    public void setArgs(String args) {
        this.m_instance = args.equals("CAPTURED") ? CapturedDatabases.getInstance() : ConvertedDatabases.getInstance();
    }
}

