/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.IntegerDocument;

class UpdateTypePanel
extends JPanel {
    private JComboBox _cmbSourceField;
    private JTextField _txfSourcePrecision;
    private JTextField _txfSourceScale;
    private Set<DataTypeSpecification> _availableDataTypes;

    public UpdateTypePanel(DataTypeSpecification[] availableDataTypes) {
        super(new BorderLayout());
        this.initGUI();
        this._availableDataTypes = new HashSet<DataTypeSpecification>();
        for (DataTypeSpecification specification : availableDataTypes) {
            boolean found = false;
            for (DataTypeSpecification existingSpecification : this._availableDataTypes) {
                if (!specification.getName().equals(existingSpecification.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this._availableDataTypes.add(specification);
        }
        this.initializeValues();
    }

    public Integer getScale() {
        if (this._txfSourceScale.getText().trim().length() > 0) {
            return Integer.valueOf(this._txfSourceScale.getText());
        }
        return null;
    }

    public Integer getPrecision() {
        if (this._txfSourcePrecision.getText().trim().length() > 0) {
            return Integer.valueOf(this._txfSourcePrecision.getText());
        }
        return null;
    }

    public String getTypeName() {
        return ((DataTypeSpecification)this._cmbSourceField.getSelectedItem()).getName();
    }

    public void setCurrentColumnType(String columnType, Integer precision, Integer scale) {
        for (int i = 0; i < this._cmbSourceField.getItemCount(); ++i) {
            if (!((DataTypeSpecification)this._cmbSourceField.getItemAt(i)).getName().equals(columnType)) continue;
            this._cmbSourceField.setSelectedIndex(i);
        }
        this._txfSourcePrecision.setText(precision == null ? "" : String.valueOf(precision));
        this._txfSourceScale.setText(scale == null ? "" : String.valueOf(scale));
    }

    private void initializeValues() {
        this._cmbSourceField.removeAllItems();
        for (DataTypeSpecification specifications : this._availableDataTypes) {
            this._cmbSourceField.addItem(specifications);
        }
        this._cmbSourceField.setSelectedIndex(0);
    }

    private void initGUI() {
        GridBagLayout gbLayout = new GridBagLayout();
        gbLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
        gbLayout.rowHeights = new int[]{7, 7, 7};
        gbLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
        JPanel lhsPanel = new JPanel();
        lhsPanel.setLayout(gbLayout);
        lhsPanel.setPreferredSize(new Dimension(150, 80));
        lhsPanel.add((Component)new JLabel(MigrationAddinArb.getString(182) + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._cmbSourceField = new JComboBox();
        this._cmbSourceField.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof DataTypeSpecification) {
                    return super.getListCellRendererComponent((JList<?>)list, ((DataTypeSpecification)value).getName(), index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        lhsPanel.add((Component)this._cmbSourceField, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        lhsPanel.add((Component)new JLabel(MigrationAddinArb.getString(184) + ":"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfSourcePrecision = new JTextField();
        this._txfSourcePrecision.setDocument(new IntegerDocument());
        lhsPanel.add((Component)this._txfSourcePrecision, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        lhsPanel.add((Component)new JLabel(MigrationAddinArb.getString(185) + ":"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfSourceScale = new JTextField();
        this._txfSourceScale.setDocument(new IntegerDocument());
        lhsPanel.add((Component)this._txfSourceScale, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._cmbSourceField.addItemListener(new ComboListener());
        this.add(lhsPanel);
    }

    private class ComboListener
    implements ItemListener {
        private ComboListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            DataTypeSpecification newSpec = (DataTypeSpecification)e.getItem();
            UpdateTypePanel.this._txfSourceScale.setText("");
            UpdateTypePanel.this._txfSourcePrecision.setText("");
            if (newSpec.getPrecision() != null) {
                UpdateTypePanel.this._txfSourcePrecision.setText(String.valueOf(newSpec.getPrecision()));
            }
            if (newSpec.getScale() != null) {
                UpdateTypePanel.this._txfSourceScale.setText(String.valueOf(newSpec.getScale()));
            }
        }
    }
}

