/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import javax.swing.JPanel;
import oracle.dbtools.migration.workbench.core.ui.MigrationProgressBar;
import oracle.ide.Ide;

public abstract class AbstractMigrationProgressRunnable
implements Runnable {
    private Exception _ex;
    private MigrationProgressBar _progBar;
    private boolean _canceled;
    private Thread _runnerThread;
    private boolean _useThread = true;
    private boolean _useBuzyBar = true;
    private String _title;
    private String _msg;
    private Object _result;

    public final void setTitle(String title) {
        this._title = title;
    }

    public final String getTitle() {
        return this._title;
    }

    public final void setMessage(String msg) {
        this._msg = msg;
    }

    public final String getMessage() {
        return this._msg;
    }

    public void updateProgress(int completionStatus, Object aboveInformation, Object belowInformation) {
        if (this._progBar == null) {
            return;
        }
        this._progBar.updateProgress(completionStatus, aboveInformation, belowInformation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(boolean useThread) throws Exception {
        this._useThread = useThread;
        if (useThread) {
            this._progBar = new MigrationProgressBar((Component)Ide.getMainWindow(), this._title, this, this._useBuzyBar);
            JPanel topPanel = this.getTopPanel();
            JPanel belowPanel = this.getDownPanel();
            this._progBar.setGUI(topPanel, belowPanel);
            this._progBar.start();
            AbstractMigrationProgressRunnable abstractMigrationProgressRunnable = this;
            synchronized (abstractMigrationProgressRunnable) {
                if (this._progBar.hasUserCancelled()) {
                    this._canceled = true;
                    this.doCancel();
                }
                this._progBar = null;
            }
        } else {
            this.run();
        }
        if (this._ex != null && !this._canceled) {
            throw new Exception(this._ex);
        }
        this.finish(this._result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Object result = null;
        try {
            AbstractMigrationProgressRunnable abstractMigrationProgressRunnable = this;
            synchronized (abstractMigrationProgressRunnable) {
                if (this._progBar != null) {
                    this._progBar.sleepForUIToRepaint();
                    this._runnerThread = Thread.currentThread();
                }
            }
            result = this.doWork();
            if (this._progBar != null) {
                this._result = result;
            }
        }
        catch (Exception ex) {
            this._ex = ex;
        }
        finally {
            AbstractMigrationProgressRunnable abstractMigrationProgressRunnable = this;
            synchronized (abstractMigrationProgressRunnable) {
                if (this._useThread && this._progBar != null && this._progBar.isExitClicked()) {
                    this._runnerThread = null;
                    this._progBar.setDoneStatus();
                }
            }
        }
    }

    protected abstract Object doWork() throws Exception;

    protected void finish(Object result) {
    }

    protected void doCancel() {
        if (this._runnerThread != null) {
            this._runnerThread.interrupt();
            this._runnerThread = null;
            this._result = Boolean.FALSE;
        }
    }

    protected final Thread getRunnerThread() {
        return this._runnerThread;
    }

    public abstract void updateAbovePanel(Object var1);

    public abstract JPanel getTopPanel();

    public abstract JPanel getDownPanel();

    public abstract void updateBelowPanel(Object var1);

    public MigrationProgressBar getProgBar() {
        return this._progBar;
    }

    public boolean isUseBuzyBar() {
        return this._useBuzyBar;
    }

    public void setUseBuzyBar(boolean buzyBar) {
        this._useBuzyBar = buzyBar;
    }
}

