/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureEventListener;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.ui.AbstractCommonMigrationProgressRunnable;

public class CaptureRunner
extends AbstractCommonMigrationProgressRunnable
implements CaptureEventListener {
    private int m_uaMask;
    private CaptureWorker m_worker;

    protected void finish(Object result) {
        super.finish(result);
        Boolean b = (Boolean)result;
        if (b != null && b.booleanValue()) {
            CapturedDatabases.getInstance().addMdConnection(this.m_worker.getCapturedConnection());
            MigrationAddin.getMigrationConfig().updateUACode(this.m_uaMask);
        }
    }

    public CaptureRunner(CaptureWorker worker, int uaMask) {
        this.m_worker = worker;
        this.m_uaMask = uaMask;
        this.setTitle(MigrationAddinArb.getString(158));
        this.setMessage(MigrationAddinArb.getString(159));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doWork() throws Exception {
        block3: {
            Boolean bl;
            try {
                this.m_worker.addActionListener(this);
                if (!this.m_worker.runCapture()) break block3;
                bl = Boolean.TRUE;
                Object var3_3 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                MigrationLogUtil.endMigrationLogSession();
                throw throwable;
            }
            MigrationLogUtil.endMigrationLogSession();
            return bl;
        }
        Boolean bl = Boolean.FALSE;
        Object var3_4 = null;
        MigrationLogUtil.endMigrationLogSession();
        return bl;
    }

    public void doCancel() {
        super.doCancel();
        this.m_worker.signalCancel();
    }

    public void raiseEvent(CaptureEvent event) {
        String progressLabel = "";
        switch (event.getEventId()) {
            case 1: {
                progressLabel = MigrationAddinArb.getString(81) + " " + event.getEventSource();
                this.updateProgress(1, event, progressLabel);
                break;
            }
            case 2: {
                progressLabel = event.getEventSource() + " " + MigrationAddinArb.getString(80);
                this.updateProgress(2, event, progressLabel);
                break;
            }
            case 3: {
                progressLabel = MigrationAddinArb.getString(84) + " " + event.getEventSource();
                this.updateProgress(3, event, progressLabel);
                break;
            }
            case 4: {
                progressLabel = MigrationAddinArb.getString(85) + " " + event.getEventSource();
                this.updateProgress(4, event, progressLabel);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                progressLabel = MigrationAddinArb.getString(86);
                this.updateProgress(6, event, progressLabel);
                break;
            }
            case 7: {
                progressLabel = MigrationAddinArb.getString(88);
                this.updateProgress(7, event, progressLabel);
                break;
            }
            case 8: {
                progressLabel = event.getEventSourceType();
                this.updateProgress(6, event, progressLabel);
            }
        }
    }

    public String[] getColumnNames() {
        return new String[]{MigrationAddinArb.getString(154), MigrationAddinArb.getString(160)};
    }

    public String getEventString(Object event) {
        if (event != null && event instanceof CaptureEvent) {
            CaptureEvent eve = (CaptureEvent)event;
            String objType = null;
            if (eve.getEventId() == 3) {
                for (int i = 0; i < CaptureEvent.CAPTURE_OBJECTS.length; ++i) {
                    if (!eve.getEventSourceType().equalsIgnoreCase(CaptureEvent.CAPTURE_OBJECTS[i])) continue;
                    objType = CaptureEvent.CAPTURE_OBJECTS[i];
                }
            }
            return objType;
        }
        return null;
    }

    public void setTableCellRenderer() {
    }

    public void setToolTip() {
    }
}

