/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.RepositoryDialog;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.javatools.db.DBException;

public class ClearRepositoryDialog
extends RepositoryDialog {
    private String m_repo = "";

    public ClearRepositoryDialog() {
        super(StringUtils.stripMnemonic((String)MigrationAddinArb.getString(52)), MigrationAddinArb.getString(53), "Repository");
        this.init();
        this.getGui().setVisible(true);
    }

    private void init() {
        this.setComboLabel(StringUtils.stripMnemonic((String)MigrationAddinArb.getString(52)));
        this.setHelpId("f1_deleterepository_html");
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClearRepositoryDialog.this.getGui().setVisible(false);
                if (ClearRepositoryDialog.this.getRepositoryCombo().getSelectedItem() != null) {
                    ClearRepositoryDialog.this.m_repo = (String)ClearRepositoryDialog.this.getRepositoryCombo().getSelectedItem();
                    String defRepo = MigrationAddin.getMigrationConfig().getDefaultRepository();
                    MigrationAddin.getMigrationConfig().setDefaultRepository(ClearRepositoryDialog.this.m_repo);
                    MigrationAddin.openRepository(ClearRepositoryDialog.this.m_repo);
                    Connection connection = null;
                    try {
                        connection = Connections.getInstance().getConnection(ClearRepositoryDialog.this.m_repo);
                    }
                    catch (DBException dbex) {
                        MigrationLogUtil.logThrowable(dbex.getMessage(), defRepo, (Throwable)dbex);
                        return;
                    }
                    if (connection == null) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(56), (String)StringUtils.stripMnemonic((String)MigrationAddinArb.getString(52)), (String)"f1_reponotopen_html");
                    } else if (!RepositoryManager.purgeRepository(connection)) {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(55), (String)StringUtils.stripMnemonic((String)MigrationAddinArb.getString(52)), (String)"f1_errortruncaterepo_html");
                    }
                    MigrationAddin.getMigrationConfig().setDefaultRepository(defRepo);
                    MigrationAddin.openRepository(defRepo);
                }
                ClearRepositoryDialog.this.getGui().setVisible(false);
                MigrationAddin.openRepository(ClearRepositoryDialog.this.m_repo);
            }
        };
        this.addokActionListener(l);
    }
}

