/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.workbench.core.ui.DataMapPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComboCellEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 3953230538755610540L;
    private Map<DataTypeSpecification, List<DataTypeSpecification>> _sourceTargetMap;

    public ComboCellEditor(JComboBox comboBox) {
        super(comboBox);
    }

    public void setSourceTargetMap(Map<DataTypeSpecification, List<DataTypeSpecification>> sourceTargetMap) {
        this._sourceTargetMap = sourceTargetMap;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JComboBox comboBox = (JComboBox)super.getComponent();
        DataTypeSpecification sourceDataSpec = (DataTypeSpecification)table.getValueAt(row, table.getColumnModel().getColumnIndex(DataMapPanel.SOURCE_DATA_TYPE));
        List<DataTypeSpecification> targetDataTypeSpecification = null;
        if (this._sourceTargetMap.containsKey(sourceDataSpec)) {
            targetDataTypeSpecification = this._sourceTargetMap.get(sourceDataSpec);
        } else {
            HashSet<DataTypeSpecification> uniqueSet = new HashSet<DataTypeSpecification>();
            for (List<DataTypeSpecification> specifications : this._sourceTargetMap.values()) {
                uniqueSet.addAll(specifications);
            }
            targetDataTypeSpecification = new ArrayList<DataTypeSpecification>(uniqueSet);
        }
        if (!targetDataTypeSpecification.contains(value)) {
            targetDataTypeSpecification.add((DataTypeSpecification)value);
        }
        this.fillCombo(comboBox, targetDataTypeSpecification);
        comboBox.setSelectedItem(value);
        return this.editorComponent;
    }

    private void fillCombo(JComboBox box, List<DataTypeSpecification> targetDataTypeSpecifications) {
        box.removeAllItems();
        for (DataTypeSpecification specification : targetDataTypeSpecifications) {
            box.addItem(specification);
        }
    }
}

