/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.convert.ConvertEvent;
import oracle.dbtools.migration.convert.ConvertEventListener;
import oracle.dbtools.migration.convert.ConverterWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.ui.AbstractCommonMigrationProgressRunnable;

public class ConvertRunner
extends AbstractCommonMigrationProgressRunnable
implements ConvertEventListener {
    private ConverterWorker m_worker;

    public ConvertRunner(ConverterWorker worker) {
        this.m_worker = worker;
        this.setTitle(MigrationAddinArb.getString(152));
        this.setMessage(MigrationAddinArb.getString(153));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doWork() throws Exception {
        this.m_worker.addEventListener(this);
        try {
            boolean completed = this.m_worker.runConvert();
            if (completed) {
                MdConnection mdconnection = this.m_worker.getConvertedConnection();
                ConvertedDatabases.getInstance().addMdConnection(mdconnection);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            MigrationLogUtil.endMigrationLogSession();
            throw throwable;
        }
        MigrationLogUtil.endMigrationLogSession();
        return null;
    }

    public void doCancel() {
        super.doCancel();
        this.m_worker.signalCancel();
    }

    public void raiseEvent(ConvertEvent event) {
        String desc = this.getDescription(event.getEventId());
        String source = event.getEventSource();
        source = source != null && source.trim().length() > 0 ? desc + ":" + source : desc;
        if (event.getEventId() == 19 || event.getEventId() == 20 || event.getEventId() == 2) {
            this.updateProgress(event.getEventId(), null, source);
        } else {
            this.updateProgress(event.getEventId(), desc, source);
        }
    }

    private String getDescription(int eventid) {
        String sDesc = "";
        switch (eventid) {
            case 1: {
                sDesc = MigrationAddinArb.getString(114);
                break;
            }
            case 2: {
                sDesc = MigrationAddinArb.getString(115);
                break;
            }
            case 6: {
                sDesc = MigrationAddinArb.getString(119);
                break;
            }
            case 7: {
                sDesc = MigrationAddinArb.getString(120);
                break;
            }
            case 10: {
                sDesc = MigrationAddinArb.getString(123);
                break;
            }
            case 12: {
                sDesc = MigrationAddinArb.getString(125);
                break;
            }
            case 3: {
                sDesc = MigrationAddinArb.getString(116);
                break;
            }
            case 4: {
                sDesc = MigrationAddinArb.getString(117);
                break;
            }
            case 8: {
                sDesc = MigrationAddinArb.getString(121);
                break;
            }
            case 9: {
                sDesc = MigrationAddinArb.getString(122);
                break;
            }
            case 13: {
                sDesc = MigrationAddinArb.getString(126);
                break;
            }
            case 14: {
                sDesc = MigrationAddinArb.getString(127);
                break;
            }
            case 15: {
                sDesc = MigrationAddinArb.getString(128);
                break;
            }
            case 16: {
                sDesc = MigrationAddinArb.getString(129);
                break;
            }
            case 17: {
                sDesc = MigrationAddinArb.getString(130);
                break;
            }
            case 18: {
                sDesc = MigrationAddinArb.getString(131);
                break;
            }
            case -1: {
                break;
            }
            case 5: {
                sDesc = MigrationAddinArb.getString(118);
                break;
            }
            case 11: {
                sDesc = MigrationAddinArb.getString(124);
                break;
            }
            case 19: {
                sDesc = MigrationAddinArb.getString(132);
                break;
            }
            case 20: {
                sDesc = MigrationAddinArb.getString(133);
                break;
            }
        }
        return sDesc;
    }

    public String[] getColumnNames() {
        return new String[]{MigrationAddinArb.getString(156), MigrationAddinArb.getString(157)};
    }

    public String getEventString(Object event) {
        if (event != null && event instanceof String) {
            return (String)event;
        }
        return null;
    }

    public void setTableCellRenderer() {
    }

    public void setToolTip() {
    }
}

