/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.util.ArrayList;
import oracle.dbtools.migration.workbench.core.ui.AbstractUpdatableTableModel;

public class CountEventModel
extends AbstractUpdatableTableModel {
    private ArrayList<IdAndCounter> m_data = new ArrayList();
    private String[] m_columnNames;

    public CountEventModel(String[] columnNames) {
        this.m_columnNames = columnNames;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    protected boolean updateImpl(Object o) {
        if (o == null || !(o instanceof String)) {
            return false;
        }
        String id = (String)o;
        for (IdAndCounter row : this.m_data) {
            if (!row.getId().equals(id)) continue;
            row.increment();
            return true;
        }
        IdAndCounter newRow = new IdAndCounter(id, 1);
        this.m_data.add(newRow);
        return true;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.m_data.size();
    }

    public Object getValueAt(int row, int col) {
        if (row > this.getRowCount() - 1 || col > this.getColumnCount() - 1) {
            return null;
        }
        IdAndCounter rowData = this.m_data.get(row);
        if (col == 0) {
            return rowData.getId();
        }
        return rowData.getCounter();
    }

    public String getColumnName(int column) {
        if (column < 0 || column > this.getColumnCount()) {
            return null;
        }
        return this.m_columnNames[column];
    }

    protected boolean clearImpl() {
        if (this.m_data.size() == 0) {
            return false;
        }
        while (this.m_data.size() > 0) {
            this.m_data.remove(0);
        }
        return true;
    }

    private static class IdAndCounter {
        private String m_id;
        private int m_counter;

        public IdAndCounter(String id, int count) {
            this.m_id = id;
            this.m_counter = count;
        }

        public void increment() {
            ++this.m_counter;
        }

        public int getCounter() {
            return this.m_counter;
        }

        public String getId() {
            return this.m_id;
        }
    }
}

