/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.RepositoryDialog;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class CreateRepositoryDialog
extends RepositoryDialog {
    public CreateRepositoryDialog() {
        super(StringUtils.stripMnemonic((String)MigrationAddinArb.getString(42)), MigrationAddinArb.getString(43), "Oracle");
        this.init();
        this.getGui().setVisible(true);
    }

    private void init() {
        this.setComboLabel(StringUtils.stripMnemonic((String)MigrationAddinArb.getString(42)));
        this.setHelpId("f1_createrepository_html");
        ActionListener l = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateRepositoryDialog.this.createRepository();
                CreateRepositoryDialog.this.getGui().setVisible(false);
            }
        };
        this.addokActionListener(l);
        this.setupData();
    }

    protected void createRepository() {
        if (this.getRepositoryCombo().getSelectedItem() != null) {
            String repoCreate = (String)this.getRepositoryCombo().getSelectedItem();
            DBObject dbo = null;
            Properties ci = Connections.getInstance().getConnectionInfo(repoCreate);
            URL r = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)repoCreate, null, (String)ci.getProperty("USERNAME"), null);
            dbo = new DBObject(r);
            if (RepositoryManager.gotUserPermission(dbo)) {
                if (!RepositoryManager.findOrCreateRepositoryTables(dbo.getConnectionName())) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(110), null, null);
                }
            } else {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(418), null, null);
            }
        }
    }

    public void setupData() {
        Connections inst = Connections.getInstance();
        ArrayList<String> onames = new ArrayList<String>();
        String[] names = inst.getConnNames();
        this.getRepositoryCombo().removeAllItems();
        for (int i = 0; i < names.length; ++i) {
            String connName = names[i];
            if (!inst.isOracle(connName)) continue;
            onames.add(connName);
            this.getRepositoryCombo().addItem(connName);
        }
    }
}

