/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.ComboCellEditor;
import oracle.dbtools.migration.workbench.core.ui.DataMapValidator;
import oracle.dbtools.migration.workbench.core.ui.FilteredTableModel;
import oracle.dbtools.migration.workbench.core.ui.NewFieldTypePanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.help.HelpSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataMapPanel
extends JPanel {
    private static final long serialVersionUID = -7491951044572680503L;
    static final String SOURCE_DATA_TYPE = MigrationAddinArb.getString(182);
    static final String TARGET_DATA_TYPE = MigrationAddinArb.getString(183);
    static final String TYPE = MigrationAddinArb.getString(192);
    private static final String RULE_TYPE_USER = MigrationAddinArb.getString(190);
    private static final String RULE_TYPE_SYSTEM = MigrationAddinArb.getString(191);
    static final String PRECISION = MigrationAddinArb.getString(184);
    static final String SCALE = MigrationAddinArb.getString(185);
    private JTable _tblDataMap;
    private Map<DataTypeSpecification, List<DataTypeSpecification>> _sourceTargetMap;
    private Set<DataTypeSpecification> _allTargetValueList;
    private Set<DataTypeSpecification> _completeTargetValues;
    private List<DataTypeSpecification> _relevantDataTypeSpecifications;
    private SupportedDataTypesMap _supportedDataTypeMap;
    private JLabel _lblErrorMessage;
    private FilteredTableModel _filteredModel;
    private DBObjectId _savedMapId;
    private JCheckBox _chkFilter;

    public DataMapPanel(SupportedDataTypesMap sDataTypeMap, DataTypeSpecification[] relevantDataTypeSpecifications) {
        super(new BorderLayout());
        this.initGUI();
        this._relevantDataTypeSpecifications = Arrays.asList(relevantDataTypeSpecifications);
        this._supportedDataTypeMap = sDataTypeMap;
        this.initializeValues(false);
        this.createTableModel();
        this._chkFilter.doClick();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_convertionDataMap_html");
    }

    private void initGUI() {
        BorderLayout thisLayout = new BorderLayout();
        this.setLayout(thisLayout);
        this.setPreferredSize(new Dimension(573, 394));
        JPanel northPanel = new JPanel(new GridLayout(2, 1));
        this._lblErrorMessage = new JLabel();
        this._lblErrorMessage.setForeground(Color.RED);
        northPanel.add(this._lblErrorMessage);
        this._chkFilter = new JCheckBox();
        this._chkFilter.setSelected(true);
        northPanel.add(this._chkFilter);
        this._chkFilter.setText(MigrationAddinArb.getString(189));
        this._chkFilter.setSelected(false);
        this._chkFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMapPanel.this.initializeValues(DataMapPanel.this._chkFilter.isSelected());
                TableColumn column = DataMapPanel.this._tblDataMap.getColumn(TARGET_DATA_TYPE);
                ComboCellEditor comboCellEditor = (ComboCellEditor)column.getCellEditor();
                if (DataMapPanel.this._chkFilter.isSelected()) {
                    DataMapPanel.this._filteredModel.setFilter(DataMapPanel.this._relevantDataTypeSpecifications);
                } else {
                    DataMapPanel.this._filteredModel.setFilter(Collections.EMPTY_LIST);
                }
                column = DataMapPanel.this._tblDataMap.getColumn(TARGET_DATA_TYPE);
                column.setCellEditor(comboCellEditor);
            }
        });
        this.add((Component)northPanel, "North");
        this.createTableUI();
    }

    private void createTableUI() {
        JPanel pnlView = new JPanel();
        this.add((Component)pnlView, "Center");
        BorderLayout lhsPanelLayout = new BorderLayout();
        pnlView.setLayout(lhsPanelLayout);
        JScrollPane scpLHSTable = new JScrollPane();
        pnlView.add((Component)scpLHSTable, "Center");
        scpLHSTable.setPreferredSize(new Dimension(573, 218));
        this._tblDataMap = this.createDataSpecTable();
        scpLHSTable.setViewportView(this._tblDataMap);
        final JButton btnEdit = new JButton(MigrationAddinArb.getString(188));
        final JButton btnRemove = new JButton(MigrationAddinArb.getString(187));
        this._tblDataMap.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (DataMapPanel.this._tblDataMap.getSelectedRowCount() > 0 && e.getClickCount() == 2) {
                    btnEdit.doClick();
                }
            }
        });
        this._tblDataMap.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\u007f') {
                    btnRemove.doClick();
                }
            }
        });
        this._tblDataMap.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    boolean isRuleSelected = DataMapPanel.this._tblDataMap.getSelectedRowCount() > 0;
                    boolean isSystemRuleNotSelected = DataMapPanel.this._tblDataMap.getSelectedRow() >= DataMapPanel.this._sourceTargetMap.size();
                    btnEdit.setEnabled(isRuleSelected);
                    btnRemove.setEnabled(isSystemRuleNotSelected);
                }
            }
        });
        JPanel lhsButtonPanel = new JPanel();
        pnlView.add((Component)lhsButtonPanel, "South");
        lhsButtonPanel.setLayout(new FlowLayout(2));
        JButton btnAdd = new JButton();
        lhsButtonPanel.add(btnAdd);
        btnAdd.setText(MigrationAddinArb.getString(186));
        btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (DataMapPanel.this._allTargetValueList.size() > 0) {
                    final NewFieldTypePanel fieldTypePanel = new NewFieldTypePanel(DataMapPanel.this._sourceTargetMap.keySet(), DataMapPanel.this._allTargetValueList, null, null);
                    int buttonMask = 10;
                    ActionListener close = new ActionListener(){

                        public void actionPerformed(ActionEvent actEvnt) {
                            if (actEvnt.getActionCommand() == "apply") {
                                if (DataMapPanel.this._tblDataMap.getCellEditor() != null) {
                                    DataMapPanel.this._tblDataMap.getCellEditor().stopCellEditing();
                                }
                                DataMapPanel.this._filteredModel.getDelegateModel().addRow(new Object[]{fieldTypePanel.getSourceSpecification(), fieldTypePanel.getTargetSpecification(), RULE_TYPE_USER});
                                ((JEWTDialog)actEvnt.getSource()).closeDialog(true);
                                DataMapPanel.this._tblDataMap.setRowSelectionInterval(DataMapPanel.this._filteredModel.getRowCount() - 1, DataMapPanel.this._filteredModel.getRowCount() - 1);
                                DataMapPanel.this._tblDataMap.scrollRectToVisible(DataMapPanel.this._tblDataMap.getCellRect(DataMapPanel.this._filteredModel.getRowCount() - 1, 0, true));
                            }
                        }
                    };
                    HelpSystem.getHelpSystem().registerTopic((JComponent)fieldTypePanel, "f1_newDataRule_html");
                    UIUtils.showPanelAsDialog((JPanel)fieldTypePanel, (String)MigrationAddinArb.getString(193), (ActionListener)close, (int)buttonMask, (boolean)true);
                } else {
                    System.err.println("No target field exists. Cannot add new mappings.");
                }
            }
        });
        lhsButtonPanel.add(btnEdit);
        btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                final int selectedRow = DataMapPanel.this._tblDataMap.getSelectedRow();
                if (selectedRow >= 0 && DataMapPanel.this._allTargetValueList.size() > 0) {
                    if (DataMapPanel.this._tblDataMap.getCellEditor() != null) {
                        DataMapPanel.this._tblDataMap.getCellEditor().stopCellEditing();
                    }
                    final TableModel model = DataMapPanel.this._tblDataMap.getModel();
                    final int srcColumn = DataMapPanel.this._tblDataMap.getColumnModel().getColumnIndex(SOURCE_DATA_TYPE);
                    final int targetColumn = DataMapPanel.this._tblDataMap.getColumnModel().getColumnIndex(TARGET_DATA_TYPE);
                    DataTypeSpecification srcSpec = (DataTypeSpecification)model.getValueAt(selectedRow, srcColumn);
                    ArrayList<DataTypeSpecification> sourceList = new ArrayList<DataTypeSpecification>();
                    sourceList.add(srcSpec);
                    Set targetList = DataMapPanel.this._completeTargetValues;
                    final NewFieldTypePanel fieldTypePanel = new NewFieldTypePanel(sourceList, targetList, srcSpec, (DataTypeSpecification)model.getValueAt(selectedRow, targetColumn));
                    if (selectedRow < DataMapPanel.this._sourceTargetMap.size()) {
                        fieldTypePanel.setSourceEditable(false);
                    }
                    int buttonMask = 10;
                    ActionListener close = new ActionListener(){

                        public void actionPerformed(ActionEvent actEvnt) {
                            if (actEvnt.getActionCommand() == "apply") {
                                model.setValueAt(fieldTypePanel.getSourceSpecification(), selectedRow, srcColumn);
                                model.setValueAt(fieldTypePanel.getTargetSpecification(), selectedRow, targetColumn);
                                ((JEWTDialog)actEvnt.getSource()).closeDialog(true);
                                DataMapPanel.this._tblDataMap.repaint();
                            }
                        }
                    };
                    HelpSystem.getHelpSystem().registerTopic((JComponent)fieldTypePanel, "f1_newDataRule_html");
                    UIUtils.showPanelAsDialog((JPanel)fieldTypePanel, (String)MigrationAddinArb.getString(193), (ActionListener)close, (int)buttonMask, (boolean)true);
                }
            }
        });
        lhsButtonPanel.add(btnRemove);
        btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int selectedRow = DataMapPanel.this._tblDataMap.getSelectedRow();
                if (selectedRow >= DataMapPanel.this._sourceTargetMap.size()) {
                    TableModel model = DataMapPanel.this._tblDataMap.getModel();
                    DataMapPanel.this._filteredModel.removeRow(selectedRow);
                    if (model.getRowCount() > 0) {
                        int newSelection = Math.max(selectedRow - 1, 0);
                        if (model.getRowCount() > 0) {
                            DataMapPanel.this._tblDataMap.setRowSelectionInterval(newSelection, newSelection);
                        }
                    }
                }
            }
        });
        btnEdit.setEnabled(false);
        btnRemove.setEnabled(false);
    }

    private JTable createDataSpecTable() {
        Object[] columnNames = new String[]{SOURCE_DATA_TYPE, TARGET_DATA_TYPE, TYPE};
        DefaultTableModel model = new DefaultTableModel(null, columnNames){

            public boolean isCellEditable(int row, int column) {
                int targetColumnIndex = DataMapPanel.this._tblDataMap.getColumnModel().getColumnIndex(TARGET_DATA_TYPE);
                return targetColumnIndex == column;
            }
        };
        this._filteredModel = new FilteredTableModel(model);
        JTable table = new JTable(this._filteredModel);
        table.setToolTipText(MigrationAddinArb.getString(195));
        table.setPreferredScrollableViewportSize(new Dimension(100, 70));
        table.getSelectionModel().setSelectionMode(0);
        TableColumn column = table.getColumn(TARGET_DATA_TYPE);
        ComboCellEditor comboCellEditor = new ComboCellEditor(new JComboBox());
        column.setCellEditor(comboCellEditor);
        return table;
    }

    private void initializeValues(boolean doFilter) {
        this._sourceTargetMap = new HashMap<DataTypeSpecification, List<DataTypeSpecification>>();
        this._allTargetValueList = new HashSet<DataTypeSpecification>();
        this._completeTargetValues = new HashSet<DataTypeSpecification>();
        if (this._supportedDataTypeMap == null) {
            return;
        }
        for (DataTypeSpecification srcDataTypeSpecification : this._supportedDataTypeMap.getSourceDataTypes()) {
            DataTypeSpecification specToMatch = new DataTypeSpecification(srcDataTypeSpecification.getName());
            List<DataTypeSpecification> targetDataTypeSpecification = this.getTargetDataTypeSpecification(this._supportedDataTypeMap, srcDataTypeSpecification);
            if (doFilter && this._relevantDataTypeSpecifications.contains(specToMatch) || !doFilter) {
                this._sourceTargetMap.put(srcDataTypeSpecification, targetDataTypeSpecification);
                this._allTargetValueList.addAll(targetDataTypeSpecification);
            }
            this._completeTargetValues.addAll(targetDataTypeSpecification);
        }
        TableColumn column = this._tblDataMap.getColumn(TARGET_DATA_TYPE);
        ComboCellEditor comboCellEditor = (ComboCellEditor)column.getCellEditor();
        comboCellEditor.setSourceTargetMap(this._sourceTargetMap);
    }

    private List<DataTypeSpecification> getTargetDataTypeSpecification(SupportedDataTypesMap dataTypeMap, DataTypeSpecification srcDataTypeSpecification) {
        DataTypeMappingRule[] rulesForDataType = dataTypeMap.getRulesForDataType(srcDataTypeSpecification);
        ArrayList<DataTypeSpecification> dataSpecification = new ArrayList<DataTypeSpecification>(rulesForDataType.length);
        for (int i = 0; i < rulesForDataType.length; ++i) {
            dataSpecification.add(rulesForDataType[i].getTargetDataType());
        }
        return dataSpecification;
    }

    private void createTableModel() {
        this._filteredModel.getDelegateModel().setRowCount(0);
        for (DataTypeSpecification srcDataTypeSpecification : this._sourceTargetMap.keySet()) {
            List<DataTypeSpecification> targetDataTypeSpecification = this._sourceTargetMap.get(srcDataTypeSpecification);
            this._filteredModel.getDelegateModel().addRow(new Object[]{srcDataTypeSpecification, targetDataTypeSpecification.get(0), RULE_TYPE_SYSTEM});
        }
    }

    public DataTypeConversionMap getDataTypeConversionMap() {
        DataTypeConversionMap resultMap = new DataTypeConversionMap();
        DefaultTableModel srcModel = this._filteredModel.getDelegateModel();
        int srcColumn = this._tblDataMap.getColumnModel().getColumnIndex(SOURCE_DATA_TYPE);
        int targetColumn = this._tblDataMap.getColumnModel().getColumnIndex(TARGET_DATA_TYPE);
        for (int row = 0; row < srcModel.getRowCount(); ++row) {
            DataTypeSpecification srcSpec = (DataTypeSpecification)srcModel.getValueAt(row, srcColumn);
            DataTypeSpecification targetSpec = (DataTypeSpecification)srcModel.getValueAt(row, targetColumn);
            try {
                resultMap.addRule(new DataTypeMappingRule(srcSpec, targetSpec));
                continue;
            }
            catch (IllegalStateException ise) {
                this.setMessage("Duplicate rule:" + srcSpec + " at row:" + (row + 1));
                return null;
            }
        }
        return resultMap;
    }

    public DBObjectId save(DBObject dbObject) {
        DataTypeConversionMap dataTypeConversionMap = this.getDataTypeConversionMap();
        if (dataTypeConversionMap == null) {
            return null;
        }
        String validateMsg = DataMapValidator.validate(dataTypeConversionMap, this._supportedDataTypeMap);
        if (validateMsg != null) {
            this.setMessage(validateMsg);
            return null;
        }
        MdConnection mdConnection = MigrationUtils.getConnforDBObject(dbObject);
        try {
            DBObjectId id;
            this._savedMapId = id = ConvertUtils.persistMap(MigrationAddin.getPersistenceManager(), mdConnection.getProjectId(), "SQLServerDataMap", dataTypeConversionMap);
            return id;
        }
        catch (PersistenceException e) {
            this.setMessage(e.getMessage());
            Logger.getLogger("oracle.dbtools.migration").warning("DataMap.SAVE_FAILED");
            return null;
        }
    }

    private void setMessage(String validateMsg) {
        this._lblErrorMessage.setText(validateMsg);
    }

    public void setPersistedRules(DataTypeMappingRule[] currentDataTypeRules) {
        int targetColumn = this._tblDataMap.getColumnModel().getColumnIndex(TARGET_DATA_TYPE);
        for (DataTypeMappingRule specMappingRule : currentDataTypeRules) {
            int updateRow = this.searchInModel(this._filteredModel.getDelegateModel(), specMappingRule.getSourceDataType());
            if (updateRow >= 0) {
                this._filteredModel.getDelegateModel().setValueAt(specMappingRule.getTargetDataType(), updateRow, targetColumn);
            } else {
                this._filteredModel.getDelegateModel().addRow(new Object[]{specMappingRule.getSourceDataType(), specMappingRule.getTargetDataType(), RULE_TYPE_USER});
            }
            updateRow = this.searchInModel(this._filteredModel, specMappingRule.getSourceDataType());
            if (updateRow < 0) continue;
            this._filteredModel.setValueAt(specMappingRule.getTargetDataType(), updateRow, targetColumn);
        }
    }

    private int searchInModel(TableModel tableModel, DataTypeSpecification sourceDataTypeToSearch) {
        int srcColumn = this._tblDataMap.getColumnModel().getColumnIndex(SOURCE_DATA_TYPE);
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            if (!tableModel.getValueAt(i, srcColumn).equals(sourceDataTypeToSearch)) continue;
            return i;
        }
        return -1;
    }

    public DBObjectId getSavedMapId() {
        return this._savedMapId;
    }
}

