/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.DataTypeMappingRule;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.convert.ValidDataTypeSpecification;

public class DataMapValidator {
    public static String validate(DataTypeConversionMap dataTypeConversionMap, SupportedDataTypesMap dataTypeMap) {
        if (dataTypeConversionMap == null || dataTypeConversionMap.values().size() <= 0) {
            return "No data conversion rule defined";
        }
        String msg = DataMapValidator.validateDuplication(dataTypeConversionMap);
        if (msg != null) {
            return msg;
        }
        msg = DataMapValidator.validateName(dataTypeConversionMap, dataTypeMap);
        if (msg != null) {
            return msg;
        }
        msg = DataMapValidator.validateRange(dataTypeConversionMap, dataTypeMap);
        if (msg != null) {
            return msg;
        }
        return null;
    }

    private static String validateRange(DataTypeConversionMap dataTypeConversionMap, SupportedDataTypesMap supportedDataTypeMap) {
        DataTypeMappingRule[] rules = dataTypeConversionMap.values().toArray(new DataTypeMappingRule[0]);
        for (int i = 0; i < rules.length; ++i) {
            DataTypeSpecification newDataType = rules[i].getSourceDataType();
            for (ValidDataTypeSpecification vDataTypeSpecification : supportedDataTypeMap.getValidDataTypes()) {
                if (!vDataTypeSpecification.getName().equals(newDataType.getName())) continue;
                if (vDataTypeSpecification.isPrecisionMandatory() && newDataType.getPrecision() == null) {
                    return "Precision is mandatory for data type:" + newDataType;
                }
                if (newDataType.getPrecision() != null) {
                    if (vDataTypeSpecification.getMaxPrecision() != null && newDataType.getPrecision() > vDataTypeSpecification.getMaxPrecision()) {
                        return "Precision for data type:" + newDataType + " should be between " + vDataTypeSpecification.getMinPrecision() + " and " + vDataTypeSpecification.getMaxPrecision();
                    }
                    if (vDataTypeSpecification.getMinPrecision() != null && newDataType.getPrecision() < vDataTypeSpecification.getMinPrecision()) {
                        return "Precision for data type:" + newDataType + " should be between " + vDataTypeSpecification.getMinPrecision() + " and " + vDataTypeSpecification.getMaxPrecision();
                    }
                }
                if (vDataTypeSpecification.isScaleMandatory() && newDataType.getScale() == null) {
                    return "Scale is mandatory for data type:" + newDataType;
                }
                if (newDataType.getScale() == null) continue;
                if (vDataTypeSpecification.getMaxScale() != null && newDataType.getScale() > vDataTypeSpecification.getMaxScale()) {
                    return "Scale for data type:" + newDataType + " should be between " + vDataTypeSpecification.getMinScale() + " and " + vDataTypeSpecification.getMaxScale();
                }
                if (vDataTypeSpecification.getMinScale() == null || newDataType.getScale() >= vDataTypeSpecification.getMinScale()) continue;
                return "Scale for data type:" + newDataType + " should be between " + vDataTypeSpecification.getMinScale() + " and " + vDataTypeSpecification.getMaxScale();
            }
        }
        return null;
    }

    private static String validateDuplication(DataTypeConversionMap dataTypeConversionMap) {
        DataTypeMappingRule[] rules = dataTypeConversionMap.values().toArray(new DataTypeMappingRule[0]);
        for (int i = 0; i < rules.length; ++i) {
            DataTypeSpecification sourceDataType = rules[i].getSourceDataType();
            for (int j = i + 1; j < rules.length; ++j) {
                if (!sourceDataType.toString().equals(rules[j].toString())) continue;
                return "Duplicate rule:" + sourceDataType.toString();
            }
        }
        return null;
    }

    private static String validateName(DataTypeConversionMap dataTypeConversionMap, SupportedDataTypesMap supportedDataTypeMap) {
        DataTypeMappingRule[] rules = dataTypeConversionMap.values().toArray(new DataTypeMappingRule[0]);
        for (int i = 0; i < rules.length; ++i) {
            DataTypeSpecification newDataType = rules[i].getSourceDataType();
            boolean found = false;
            for (DataTypeSpecification srcDataTypeSpecification : supportedDataTypeMap.getSourceDataTypes()) {
                if (!srcDataTypeSpecification.getName().equals(newDataType.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return "Source data type not supported:" + newDataType;
        }
        return null;
    }
}

