/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.online.DataMoveRunner;
import oracle.dbtools.migration.datamove.online.DataMoveWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.DataMoveSelectionPanel;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public class DataMoveDialog
extends AbstractMenuAction {
    private MdConnection m_mdConnection = null;
    private JEWTDialog m_dlg;
    private static final long serialVersionUID = 5025669709731183466L;
    private DataMoveSelectionPanel m_dmsp;
    private JButton m_okButton;

    public DataMoveDialog(MdConnection convcon) {
        this.m_mdConnection = convcon;
        this.setupDialog();
    }

    public DataMoveDialog() {
        this.setupDialog();
    }

    private void setupDialog() {
        MigrationConfig config = MigrationAddin.getMigrationConfig();
        final int numThreads = config.getNumDataMoveThreads();
        final int commitInterval = config.getDataMoveCommitInterval();
        this.m_dmsp = new DataMoveSelectionPanel(this.m_mdConnection);
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this.m_dmsp, null, (String)MigrationAddinArb.getString(261), (int)6);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_dmsp, "f1_onlinedatamove_html");
        this.m_okButton = new JButton("OK");
        this.m_dlg.addCustomButton((Component)this.m_okButton);
        this.m_okButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void actionPerformed(ActionEvent e) {
                block7: {
                    block6: {
                        try {
                            try {
                                if (DataMoveDialog.this.m_dmsp.getSourceConnectionName() == null || DataMoveDialog.this.m_dmsp.getTargetConnectionName() == null || DataMoveDialog.this.m_dmsp.getTargetConnectionName() == null || DataMoveDialog.this.m_dmsp.getConvertedConnection() == null) {
                                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(296), (String)MigrationAddinArb.getString(295), (String)"f1_chooseDataMove");
                                    Object var5_2 = null;
                                    break block6;
                                }
                                DataMoveWorker dmw = new DataMoveWorker(MigrationAddin.getPersistenceManager(), DataMoveDialog.this.m_dmsp.getSourceConnectionName(), DataMoveDialog.this.m_dmsp.getTargetConnectionName(), DataMoveDialog.this.m_dmsp.getConvertedConnection().getKey(), numThreads, commitInterval, DataMoveDialog.this.m_dmsp.getUseQualifiedNames());
                                DataMoveRunner dmr = new DataMoveRunner(dmw);
                                DataMoveDialog.this.m_dlg.closeDialog(true);
                                MigrationLogUtil.startMigrationLogSession(DataMoveDialog.this.m_dmsp.getConvertedConnection().getKey());
                                dmr.start(true);
                                break block7;
                            }
                            catch (Exception ex) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ex.getStackTrace()[0].toString(), ex);
                                Object var5_4 = null;
                                MigrationLogUtil.endMigrationLogSession();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            MigrationLogUtil.endMigrationLogSession();
                            throw throwable;
                        }
                    }
                    MigrationLogUtil.endMigrationLogSession();
                    return;
                }
                Object var5_3 = null;
                MigrationLogUtil.endMigrationLogSession();
            }
        });
        this.m_dlg.pack();
        this.m_dlg.setResizable(false);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.m_dlg);
    }

    public void setVisible(boolean visible) {
        this.m_dlg.setVisible(visible);
    }

    public void launch() {
        MdConnection mdConnection;
        DBObject dbo = this.getDBObject();
        this.m_mdConnection = mdConnection = MigrationUtils.getConnforDBObject(dbo);
        DataMoveDialog dialog = new DataMoveDialog(this.m_mdConnection);
        dialog.setVisible(true);
    }

    public void setArgs(String args) {
    }
}

