/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.ui.MdConnectionRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;

public class DataMoveSelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1010952975618088521L;
    private JComboBox m_convertedModelcomboBox;
    private JComboBox m_targetConnectionComboBox;
    private JComboBox m_sourceComboBox;
    private JCheckBox m_checkUseQualifiedNames;
    private String m_oracle;
    private String m_nonoracle;
    private MdConnection m_captured;
    private MdConnection m_converted;

    public DataMoveSelectionPanel(MdConnection convertedConnection) {
        this.setLayout(new GridBagLayout());
        JLabel sourceConnectionLabel = new JLabel();
        sourceConnectionLabel.setText(MigrationAddinArb.getString(427));
        GridBagConstraints sourceConnectionLabelConstraints = new GridBagConstraints();
        sourceConnectionLabelConstraints.insets = new Insets(5, 5, 5, 5);
        sourceConnectionLabelConstraints.gridy = 0;
        sourceConnectionLabelConstraints.gridx = 0;
        sourceConnectionLabelConstraints.anchor = 13;
        this.add((Component)sourceConnectionLabel, sourceConnectionLabelConstraints);
        this.m_sourceComboBox = new JComboBox<String>(this.getNonOracleConnections());
        this.m_sourceComboBox.setRenderer(new comboRenderer());
        this.m_sourceComboBox.setToolTipText(MigrationAddinArb.getString(428));
        this.m_sourceComboBox.setActionCommand("m_sourceComboBoxChanged");
        GridBagConstraints sourceComboBoxConstraints = new GridBagConstraints();
        sourceComboBoxConstraints.weightx = 1.0;
        sourceComboBoxConstraints.fill = 2;
        sourceComboBoxConstraints.gridy = 0;
        sourceComboBoxConstraints.gridx = 1;
        sourceComboBoxConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.m_sourceComboBox, sourceComboBoxConstraints);
        JLabel targetConnectionLabel = new JLabel();
        targetConnectionLabel.setText(MigrationAddinArb.getString(429));
        GridBagConstraints targetConnectionLabelConstraints = new GridBagConstraints();
        targetConnectionLabelConstraints.insets = new Insets(5, 5, 5, 5);
        targetConnectionLabelConstraints.gridy = 1;
        targetConnectionLabelConstraints.gridx = 0;
        this.add((Component)targetConnectionLabel, targetConnectionLabelConstraints);
        this.m_targetConnectionComboBox = new JComboBox<String>(this.getOracleConnections());
        this.m_targetConnectionComboBox.setRenderer(new comboRenderer());
        this.m_targetConnectionComboBox.setToolTipText(MigrationAddinArb.getString(430));
        this.m_targetConnectionComboBox.setActionCommand("m_targetConnectionComboBoxChanged");
        GridBagConstraints targetConnectionComboBoxConstraints = new GridBagConstraints();
        targetConnectionComboBoxConstraints.insets = new Insets(5, 5, 5, 5);
        targetConnectionComboBoxConstraints.weightx = 1.0;
        targetConnectionComboBoxConstraints.fill = 2;
        targetConnectionComboBoxConstraints.gridy = 1;
        targetConnectionComboBoxConstraints.gridx = 1;
        this.add((Component)this.m_targetConnectionComboBox, targetConnectionComboBoxConstraints);
        JLabel convertedModelLabel = new JLabel();
        convertedModelLabel.setText(MigrationAddinArb.getString(431));
        GridBagConstraints convertedModelLabelConstraints = new GridBagConstraints();
        convertedModelLabelConstraints.anchor = 13;
        convertedModelLabelConstraints.insets = new Insets(5, 5, 5, 5);
        convertedModelLabelConstraints.gridy = 2;
        convertedModelLabelConstraints.gridx = 0;
        if (convertedConnection == null) {
            this.add((Component)convertedModelLabel, convertedModelLabelConstraints);
        }
        this.m_convertedModelcomboBox = new JComboBox<MigrationConnectionNode>(ConvertedDatabases.getInstance().getMigrationConnectionNodes());
        this.m_convertedModelcomboBox.setRenderer(new MdConnectionRenderer());
        this.m_convertedModelcomboBox.setToolTipText(MigrationAddinArb.getString(433));
        this.m_convertedModelcomboBox.setActionCommand("m_convertedComboBoxChanged");
        GridBagConstraints convertedModelcomboBoxConstraints = new GridBagConstraints();
        convertedModelcomboBoxConstraints.insets = new Insets(5, 5, 5, 5);
        convertedModelcomboBoxConstraints.fill = 2;
        convertedModelcomboBoxConstraints.gridy = 2;
        convertedModelcomboBoxConstraints.gridx = 1;
        if (convertedConnection == null) {
            this.add((Component)this.m_convertedModelcomboBox, convertedModelcomboBoxConstraints);
            if (this.m_convertedModelcomboBox.getSelectedItem() != null) {
                this.m_converted = ((MigrationConnectionNode)((Object)this.m_convertedModelcomboBox.getSelectedItem())).getMdConnection();
            }
        } else {
            this.m_converted = convertedConnection;
        }
        this.m_checkUseQualifiedNames = new JCheckBox();
        this.m_checkUseQualifiedNames.setSelected(true);
        this.m_checkUseQualifiedNames.setText(MigrationAddinArb.getString(432));
        GridBagConstraints cbConstraints = new GridBagConstraints();
        cbConstraints.insets = new Insets(5, 5, 5, 5);
        cbConstraints.fill = 2;
        cbConstraints.gridx = 0;
        cbConstraints.gridy = 3;
        cbConstraints.gridwidth = 3;
        this.add((Component)this.m_checkUseQualifiedNames, cbConstraints);
        this.m_targetConnectionComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMoveSelectionPanel.this.m_oracle = ((JComboBox)e.getSource()).getSelectedItem().toString();
            }
        });
        this.m_convertedModelcomboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMoveSelectionPanel.this.m_converted = ((MigrationConnectionNode)((Object)((JComboBox)e.getSource()).getSelectedItem())).getMdConnection();
            }
        });
        this.m_sourceComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DataMoveSelectionPanel.this.m_nonoracle = ((JComboBox)e.getSource()).getSelectedItem().toString();
            }
        });
        if (this.m_targetConnectionComboBox.getSelectedItem() != null) {
            this.m_oracle = this.m_targetConnectionComboBox.getSelectedItem().toString();
        }
        if (this.m_sourceComboBox.getSelectedItem() != null) {
            this.m_nonoracle = this.m_sourceComboBox.getSelectedItem().toString();
        }
    }

    private String[] getOracleConnections() {
        Connections inst = Connections.getInstance();
        ArrayList<String> onames = new ArrayList<String>();
        String[] names = inst.getConnNames();
        for (int i = 0; i < names.length; ++i) {
            String connName = names[i];
            if (!inst.isOracle(connName)) continue;
            onames.add(connName);
        }
        return onames.toArray(new String[onames.size()]);
    }

    private String[] getNonOracleConnections() {
        Connections inst = Connections.getInstance();
        ArrayList<String> names = new ArrayList<String>();
        String[] connNames = inst.getConnNames();
        for (int i = 0; i < connNames.length; ++i) {
            String connName = connNames[i];
            if (inst.isOracle(connName)) continue;
            names.add(connName);
        }
        return names.toArray(new String[names.size()]);
    }

    public Connection getTargetConnection() throws DBException {
        return Connections.getInstance().getConnection(this.m_oracle);
    }

    public Connection getSourceConnection() throws DBException {
        return Connections.getInstance().getConnection(this.m_nonoracle);
    }

    public String getSourceConnectionName() {
        return this.m_nonoracle;
    }

    public String getTargetConnectionName() {
        return this.m_oracle;
    }

    public MdConnection getCapturedConnection() {
        return this.m_captured;
    }

    public MdConnection getConvertedConnection() {
        return this.m_converted;
    }

    public boolean getUseQualifiedNames() {
        return this.m_checkUseQualifiedNames.isSelected();
    }

    private class comboRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 6863349475776521119L;

        private comboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, Connections.getDisplayName((String)((String)value)), index, isSelected, cellHasFocus);
        }
    }
}

