/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.util.ArrayList;
import oracle.dbtools.migration.workbench.core.ui.AbstractUpdatableTableModel;

public class EventStatusModel
extends AbstractUpdatableTableModel {
    private static final long serialVersionUID = -6725611704614187433L;
    private ArrayList<String[]> m_data;
    private String[] m_columnNames;

    public EventStatusModel(String[] columnNames) {
        this.m_columnNames = columnNames;
        this.m_data = new ArrayList();
    }

    public String getColumnName(int column) {
        if (column < 0 || column > this.getColumnCount()) {
            return null;
        }
        return this.m_columnNames[column];
    }

    protected boolean updateImpl(Object o) {
        if (o == null || !(o instanceof String[])) {
            return false;
        }
        String[] updateData = (String[])o;
        String key = updateData[0];
        for (int i = 0; i < this.m_data.size(); ++i) {
            String[] row = this.m_data.get(i);
            if (!row[0].equals(key)) continue;
            if (row.length == updateData.length) {
                for (int j = 1; j < row.length; ++j) {
                    row[j] = updateData[j];
                }
                return true;
            }
            String[] newRow = new String[updateData.length];
            System.arraycopy(updateData, 0, newRow, 0, updateData.length);
            this.m_data.remove(i);
            this.m_data.add(i, newRow);
            return true;
        }
        String[] newRow = new String[updateData.length];
        System.arraycopy(updateData, 0, newRow, 0, updateData.length);
        this.m_data.add(newRow);
        return true;
    }

    public int getColumnCount() {
        return this.m_columnNames.length;
    }

    public int getRowCount() {
        return this.m_data.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount() || columnIndex >= this.getColumnCount() || rowIndex < 0 || columnIndex < 0) {
            return null;
        }
        String[] row = this.m_data.get(rowIndex);
        if (columnIndex >= row.length) {
            return null;
        }
        return row[columnIndex];
    }

    protected boolean clearImpl() {
        if (this.m_data.size() == 0) {
            return false;
        }
        while (this.m_data.size() > 0) {
            this.m_data.remove(0);
        }
        return true;
    }
}

