/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.migration.convert.DataTypeSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredTableModel
extends AbstractTableModel
implements TableModelListener {
    private DefaultTableModel _delegateModel;
    private List<Integer> _mappedIndexes = new ArrayList<Integer>();
    private Set<String> _filteredSpecifications;

    public FilteredTableModel(DefaultTableModel delegateModel) {
        this._delegateModel = delegateModel;
        int rowCount = delegateModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this._mappedIndexes.add(i);
        }
        this._filteredSpecifications = Collections.EMPTY_SET;
        delegateModel.addTableModelListener(this);
    }

    @Override
    public String getColumnName(int column) {
        return this._delegateModel.getColumnName(column);
    }

    public void setFilter(List<DataTypeSpecification> filteredSpecifications) {
        this._filteredSpecifications = new HashSet<String>();
        for (DataTypeSpecification specification : filteredSpecifications) {
            this._filteredSpecifications.add(specification.getName().toLowerCase());
        }
        this.reallocateIndexes();
        this.fireTableDataChanged();
    }

    private void reallocateIndexes() {
        int rowCount = this._delegateModel.getRowCount();
        this._mappedIndexes.clear();
        for (int i = 0; i < rowCount; ++i) {
            DataTypeSpecification sourceSpec = (DataTypeSpecification)this._delegateModel.getValueAt(i, 0);
            if (this._filteredSpecifications.size() != 0 && !this._filteredSpecifications.contains(sourceSpec.getName().toLowerCase())) continue;
            this._mappedIndexes.add(i);
        }
    }

    @Override
    public int getRowCount() {
        if (this._filteredSpecifications == null || this._filteredSpecifications.size() == 0) {
            return this._delegateModel.getRowCount();
        }
        return this._mappedIndexes.size();
    }

    public DefaultTableModel getDelegateModel() {
        return this._delegateModel;
    }

    @Override
    public int getColumnCount() {
        return this._delegateModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._filteredSpecifications == null || this._filteredSpecifications.size() == 0) {
            return this._delegateModel.getValueAt(rowIndex, columnIndex);
        }
        int newIndex = this._mappedIndexes.get(rowIndex);
        return this._delegateModel.getValueAt(newIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this._filteredSpecifications == null || this._filteredSpecifications.size() == 0) {
            this._delegateModel.setValueAt(aValue, rowIndex, columnIndex);
            return;
        }
        int newIndex = this._mappedIndexes.get(rowIndex);
        this._delegateModel.setValueAt(aValue, newIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this._delegateModel.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        this.fireTableChanged(e);
    }

    public void removeRow(int rowIndex) {
        if (this._filteredSpecifications == null || this._filteredSpecifications.size() == 0) {
            this._delegateModel.removeRow(rowIndex);
            return;
        }
        int newIndex = this._mappedIndexes.get(rowIndex);
        this._delegateModel.removeRow(newIndex);
    }
}

