/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.createRepository.RepositoryRegistry;
import oracle.dbtools.metadata.createRepository.RunRepositoryScripts;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.capture.OnlineCaptureWorker;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.ConverterWorker;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.datamove.DataMoveException;
import oracle.dbtools.migration.datamove.online.DataMoveGui;
import oracle.dbtools.migration.datamove.online.DataMoveWorker;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.generate.GenerationOutputStream;
import oracle.dbtools.migration.generate.SimpleGenerationOutputStream;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;
import oracle.dbtools.migration.workbench.core.ui.CaptureEventListenerPanel;
import oracle.dbtools.migration.workbench.core.ui.ConvertEventListenerPanel;
import oracle.dbtools.migration.workbench.core.ui.FullMigrationTopPanel;
import oracle.dbtools.migration.workbench.core.ui.GenerateEventListenerPanel;
import oracle.dbtools.migration.workbench.core.ui.RunRepoScriptPanel;
import oracle.dbtools.raptor.dialogs.user.ResultPanel;
import oracle.dbtools.raptor.scriptrunner.OutputRedirector;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.db.ConnectionException;

public class FullMigrateProgressRunnable
extends AbstractMigrationProgressRunnable {
    private static final String CURRENTSTEP_CREATE = "CREATEREPO";
    private static final String CURRENTSTEP_REMOVE = "REMOVEREPO";
    private FullMigrationTopPanel m_topPanel;
    private CaptureWorker m_captureWorker;
    private MigrationPlugin m_plugin;
    private URL m_url;
    private String m_generationConnectionName;
    private String m_sourceConnectionName;
    private static Logger s_logger = Logger.getLogger("oracle.dbtools.migration");
    private File m_generateSQLFile;
    private boolean m_leastPrivilege = false;
    private boolean m_needToCreateARepo = false;
    private boolean m_needToDropARepo = false;
    private String m_currentStep = null;
    private RunRepoScriptPanel m_currentRepoPanel;
    private ThirdPartyDbProvider m_provider;
    private String m_migrationType;
    private Context m_context;

    public FullMigrateProgressRunnable(MigrationPlugin plugin, Connection sourceConn, String sourceConnectionName, String generateConnectionName, boolean dropRepoAfterwards, String migrationType) throws MigrationPluginException {
        this.m_plugin = plugin;
        this.m_sourceConnectionName = sourceConnectionName;
        this.m_generationConnectionName = generateConnectionName;
        if (MigrationAddin.getPersistenceManager() == null || !RepositoryManager.doesRepositoryExist(MigrationAddin.getPersistenceManager().getConn())) {
            this.m_needToCreateARepo = true;
            this.m_needToDropARepo = dropRepoAfterwards;
        }
        this.m_provider = this.m_plugin.getProvider(sourceConn);
        this.m_migrationType = migrationType;
        this.setTitle(MigrationAddinArb.getString(380));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doWork() throws Exception {
        block14: {
            MdConnection convertedConnection;
            PersistenceManager pman;
            block13: {
                Boolean bl;
                pman = null;
                if (this.m_needToCreateARepo ? (pman = this.doCreateRepo()) == null : (pman = MigrationAddin.getPersistenceManager()) == null) {
                    return Boolean.FALSE;
                }
                MdConnection capturedConnection = this.doCapture(pman);
                if (capturedConnection == null) {
                    return Boolean.FALSE;
                }
                convertedConnection = this.doConvert(pman, capturedConnection);
                if (convertedConnection == null) {
                    return Boolean.FALSE;
                }
                if (!this.doGenerate(convertedConnection)) {
                    return Boolean.FALSE;
                }
                try {
                    if (this.runGenerateScript()) break block13;
                    boolean response = MessageDialog.confirm((Component)this.getTopPanel(), (Object)MigrationAddinArb.getString(441), (String)MigrationAddinArb.getString(440), (String)"help_drop_out_of_quick");
                    if (response) {
                        SqlNode node = null;
                        node = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)this.m_url);
                        final SqlNode sn = node;
                        if (sn != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                                        public void run() {
                                            EditorUtil.openDefaultEditorInFrame((Node)sn);
                                        }
                                    });
                                }
                            });
                        }
                    }
                    bl = Boolean.FALSE;
                    Object var8_8 = null;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    MigrationLogUtil.endMigrationLogSession();
                    throw throwable;
                }
                MigrationLogUtil.endMigrationLogSession();
                return bl;
            }
            if (this.m_migrationType.equals(MigrationAddinArb.getString(377)) || this.doDataMove(pman, convertedConnection.getKey())) break block14;
            Boolean bl = Boolean.FALSE;
            Object var8_9 = null;
            MigrationLogUtil.endMigrationLogSession();
            return bl;
        }
        Object var8_10 = null;
        MigrationLogUtil.endMigrationLogSession();
        if (this.m_needToDropARepo) {
            if (this.m_migrationType.equals(MigrationAddinArb.getString(377))) {
                this.m_topPanel.nextStep();
            }
            if (!this.dropTheRepo()) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private boolean runRepositoryScripts(String scriptName, int mode, String tabLabel, String stepKey) {
        Connection repoConn;
        this.m_currentRepoPanel = new RunRepoScriptPanel();
        this.m_topPanel.addTab(null, tabLabel, this.m_currentRepoPanel.getPanel());
        this.m_topPanel.nextStep();
        try {
            repoConn = Connections.getInstance().getConnection(this.m_generationConnectionName);
        }
        catch (DBException dbe) {
            Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, MigrationAddinArb.format(417, new Object[]{scriptName, dbe.getLocalizedMessage()}));
            return false;
        }
        RunRepositoryScripts rrs = new RunRepositoryScripts(repoConn);
        rrs.setProgressBar(this);
        rrs.setMode(mode);
        rrs.setScript(scriptName);
        this.setUseBuzyBar(false);
        this.m_currentStep = stepKey;
        JProgressBar actualProgressBar = this.getProgBar().getProgressBar();
        actualProgressBar.setIndeterminate(false);
        actualProgressBar.setMinimum(0);
        actualProgressBar.setMaximum(100);
        actualProgressBar.setStringPainted(true);
        rrs.run();
        actualProgressBar.setStringPainted(false);
        actualProgressBar.setIndeterminate(true);
        this.m_currentStep = null;
        this.setUseBuzyBar(true);
        return rrs.getSuccess() != false;
    }

    private PersistenceManager doCreateRepo() {
        if (this.runRepositoryScripts("CREATE_REPOSITORY.sql", 1, MigrationAddinArb.getString(360), CURRENTSTEP_CREATE)) {
            MigrationConfig config = MigrationAddin.getMigrationConfig();
            config.addRepository(this.m_generationConnectionName);
            config.setDefaultRepository(this.m_generationConnectionName);
            return MigrationAddin.getPersistenceManager();
        }
        return null;
    }

    private boolean dropTheRepo() {
        this.m_currentRepoPanel = new RunRepoScriptPanel();
        this.m_topPanel.addTab(null, MigrationAddinArb.getString(361), this.m_currentRepoPanel.getPanel());
        this.m_currentStep = CURRENTSTEP_REMOVE;
        this.m_topPanel.nextStep();
        Connection repoConn = null;
        try {
            repoConn = Connections.getInstance().getConnection(this.m_generationConnectionName);
        }
        catch (DBException dbe) {
            MigrationLogUtil.logThrowable(MigrationAddinArb.getString(421), CURRENTSTEP_REMOVE, (Throwable)dbe);
            return false;
        }
        boolean success = RepositoryRegistry.dropRepository(repoConn, this);
        MigrationConfig config = MigrationAddin.getMigrationConfig();
        config.removeRepository(this.m_generationConnectionName);
        this.m_currentStep = null;
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MdConnection doCapture(PersistenceManager pman) {
        block6: {
            MdConnection mdConnection;
            BasicMigrationStorer storer = new BasicMigrationStorer(pman);
            MigrationObjectFilterList filter = null;
            filter = this.m_migrationType.equals(MigrationAddinArb.getString(379)) ? (this.m_context != null ? MigrationFilterUtil.generateFilters(this.m_context) : MigrationFilterUtil.getFullFilter()) : MigrationFilterUtil.getProgramLessFilter();
            this.m_captureWorker = new OnlineCaptureWorker(this.m_provider.getCapturer(storer), this.m_plugin.getPlatformName(), this.m_plugin.getClass().getName(), filter);
            CaptureEventListenerPanel capListener = new CaptureEventListenerPanel(this);
            this.m_captureWorker.addActionListener(capListener);
            this.m_topPanel.addTab(null, capListener.getPanelName(), capListener.getPanel());
            this.m_topPanel.nextStep();
            try {
                try {
                    if (this.m_captureWorker.runCapture()) break block6;
                    mdConnection = null;
                    Object var8_9 = null;
                }
                catch (PersistenceException e) {
                    s_logger.log(Level.WARNING, "Capture.EXCEPTION", e.getLocalizedMessage());
                    MdConnection mdConnection2 = null;
                    Object var8_11 = null;
                    MigrationLogUtil.endMigrationLogSession();
                    return mdConnection2;
                }
                catch (CaptureException e) {
                    s_logger.log(Level.WARNING, "Capture.EXCEPTION", e.getLocalizedMessage());
                    MdConnection mdConnection3 = null;
                    Object var8_12 = null;
                    MigrationLogUtil.endMigrationLogSession();
                    return mdConnection3;
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                MigrationLogUtil.endMigrationLogSession();
                throw throwable;
            }
            MigrationLogUtil.endMigrationLogSession();
            return mdConnection;
        }
        Object var8_10 = null;
        MigrationLogUtil.endMigrationLogSession();
        MdConnection capturedConnection = this.m_captureWorker.getCapturedConnection();
        MigrationAddin.getMigrationConfig().updateUACode(this.m_plugin.getPlatformMask());
        CapturedDatabases.getInstance().addMdConnection(capturedConnection);
        return capturedConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MdConnection doConvert(PersistenceManager pman, MdConnection capturedConnection) {
        MdConnection mdConnection;
        ConverterWorker convWorker;
        block8: {
            try {
                DBObjectId mapId = this.storeDefaultMap(pman, this.m_plugin, capturedConnection.getProjectId());
                MigrationObjectFilterList filter = null;
                filter = this.m_migrationType.equals(MigrationAddinArb.getString(379)) ? MigrationFilterUtil.getFullFilter() : MigrationFilterUtil.getProgramLessFilter();
                convWorker = new ConverterWorker(pman, capturedConnection.getKey(), this.m_plugin.getConverter(), mapId, filter);
            }
            catch (PersistenceException e1) {
                s_logger.log(Level.WARNING, "Convert.EXCEPTION", e1.getLocalizedMessage());
                return null;
            }
            catch (MigrationPluginException e1) {
                s_logger.log(Level.WARNING, "Convert.EXCEPTION", e1.getLocalizedMessage());
                return null;
            }
            ConvertEventListenerPanel convertListener = new ConvertEventListenerPanel();
            convWorker.addEventListener(convertListener);
            this.m_topPanel.addTab(null, convertListener.getPanelName(), convertListener.getPanel());
            this.m_topPanel.nextStep();
            if (convWorker.runConvert()) break block8;
            MdConnection mdConnection2 = null;
            Object var9_11 = null;
            MigrationLogUtil.endMigrationLogSession();
            return mdConnection2;
        }
        try {
            MdConnection mdconnection = convWorker.getConvertedConnection();
            ConvertedDatabases.getInstance().addMdConnection(mdconnection);
            mdConnection = mdconnection;
            Object var9_12 = null;
        }
        catch (Exception e) {
            try {
                s_logger.log(Level.WARNING, "Convert.EXCEPTION", e.getLocalizedMessage());
                Object var9_13 = null;
            }
            catch (Throwable throwable) {
                Object var9_14 = null;
                MigrationLogUtil.endMigrationLogSession();
                throw throwable;
            }
            MigrationLogUtil.endMigrationLogSession();
            return null;
        }
        MigrationLogUtil.endMigrationLogSession();
        return mdConnection;
    }

    private DBObjectId storeDefaultMap(PersistenceManager pman, MigrationPlugin plugin, DBObjectId projectId) throws PersistenceException, MigrationPluginException {
        SupportedDataTypesMap supportedMap = plugin.getSupportedDataTypesMap();
        DataTypeConversionMap defaultMap = ConvertUtils.getDefaultMapFromSupportedMap(supportedMap);
        DBObjectId mapId = ConvertUtils.persistMap(pman, projectId, "quickmigr", defaultMap);
        return mapId;
    }

    protected boolean doGenerate(MdConnection convertedConnection) {
        try {
            GenerationOutputStream outputStream = this.createPrintStream();
            MigrationObjectFilterList filter = null;
            filter = this.m_context != null ? MigrationFilterUtil.generateFilters(this.m_context) : MigrationFilterUtil.getFullFilter();
            GenerateWorker worker = new GenerateWorker(MigrationAddin.getPersistenceManager(), convertedConnection.getKey(), outputStream, filter);
            GenerateEventListenerPanel listener = new GenerateEventListenerPanel();
            worker.addEventListener(listener);
            this.m_topPanel.addTab(null, listener.getPanelName(), listener.getPanel());
            this.m_topPanel.nextStep();
            this.m_leastPrivilege = worker.findSchemaCount() == 1;
            return worker.runGenerate(this.m_leastPrivilege);
        }
        catch (IOException ioe) {
            s_logger.log(Level.WARNING, "Generate.EXCEPTION", ioe.getLocalizedMessage());
        }
        catch (Exception e) {
            s_logger.log(Level.WARNING, "Generate.EXCEPTION", e.getLocalizedMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected boolean runGenerateScript() {
        boolean bl;
        BufferedOutputStream out;
        Connection conn = null;
        try {
            conn = Connections.getInstance().isConnectionOpen(this.m_generationConnectionName) ? Connections.getInstance().cloneConnection(Connections.getInstance().getConnection(this.m_generationConnectionName)) : Connections.getInstance().getConnection(this.m_generationConnectionName);
        }
        catch (DBException e1) {
            s_logger.log(Level.WARNING, "RunScript.EXCEPTION", e1.getLocalizedMessage());
            return false;
        }
        catch (ConnectionException e) {
            s_logger.log(Level.WARNING, "RunScript.EXCEPTION", e.getLocalizedMessage());
        }
        ScriptRunnerContext context = new ScriptRunnerContext();
        context.setTopLevel(true);
        context.setLastUrl(this.m_url);
        context.setSqlError(5);
        context.setOsError(5);
        PipedInputStream in = new PipedInputStream();
        String encoding = Ide.getEnvironOptions().getEncoding();
        ScriptRunner runner = null;
        try {
            runner = encoding == null ? new ScriptRunner(this.m_url, conn) : new ScriptRunner((Reader)new BufferedReader(new InputStreamReader(this.m_url.openStream(), encoding)), conn);
        }
        catch (UnsupportedEncodingException e1) {
            s_logger.log(Level.WARNING, "RunScript.EXCEPTION", e1.getLocalizedMessage());
            boolean bl2 = false;
            Object var14_14 = null;
            try {
                conn.close();
            }
            catch (SQLException sqlex) {
                // empty catch block
            }
            return bl2;
        }
        catch (IOException e1) {
            s_logger.log(Level.WARNING, "RunScript.EXCEPTION", e1.getLocalizedMessage());
            boolean bl3 = false;
            Object var14_15 = null;
            try {
                conn.close();
            }
            catch (SQLException sqlex) {
                // empty catch block
            }
            return bl3;
        }
        runner.setScriptRunnerContext(context);
        runner.setName(MigrationAddinArb.getString(371));
        ResultPanel resPanel = new ResultPanel();
        BasicEditorPane sqlPanel = resPanel.getSqlPane();
        JScrollPane sp = new JScrollPane((Component)sqlPanel, 22, 32);
        sp.setPreferredSize(sqlPanel.getPreferredSize());
        sp.setSize(sp.getPreferredSize());
        this.m_topPanel.addTab(null, MigrationAddinArb.getString(354), sp);
        this.m_topPanel.nextStep();
        OutputRedirector outputRedirector = new OutputRedirector(in, resPanel.getSqlPane().getDocument(), resPanel.getSqlPane());
        outputRedirector.setName(MigrationAddinArb.getString(372));
        outputRedirector.start();
        try {
            out = new BufferedOutputStream(new PipedOutputStream(in));
        }
        catch (IOException e) {
            s_logger.log(Level.WARNING, "RunScript.EXCEPTION", e.getLocalizedMessage());
            boolean bl4 = false;
            Object var14_16 = null;
            try {
                conn.close();
            }
            catch (SQLException sqlex) {
                // empty catch block
            }
            return bl4;
        }
        runner.setOut(out);
        runner.run();
        if (!context.getReturnExited()) break block21;
        boolean bl5 = false;
        Object var14_17 = null;
        try {
            conn.close();
        }
        catch (SQLException sqlex) {
            // empty catch block
        }
        {
            block21: {
                return bl5;
            }
            this.m_generateSQLFile.deleteOnExit();
            bl = true;
        }
        Object var14_18 = null;
        try {
            conn.close();
        }
        catch (SQLException sqlex) {
            // empty catch block
        }
        return bl;
        catch (Throwable throwable) {
            Object var14_19 = null;
            try {
                conn.close();
            }
            catch (SQLException sqlex) {}
            throw throwable;
        }
    }

    private GenerationOutputStream createPrintStream() throws IOException, UnsupportedEncodingException {
        this.m_generateSQLFile = File.createTempFile("generated-", "sql");
        this.m_url = this.m_generateSQLFile.toURL();
        SimpleGenerationOutputStream retVal = null;
        String encoding = Ide.getEnvironOptions().getEncoding();
        retVal = encoding == null ? new SimpleGenerationOutputStream(new PrintStream(this.m_generateSQLFile)) : new SimpleGenerationOutputStream(new PrintStream(this.m_generateSQLFile, encoding));
        return retVal;
    }

    private boolean doDataMove(PersistenceManager pman, DBObjectId convertedConnectionId) {
        DataMoveGui dmg = new DataMoveGui();
        try {
            DataMoveWorker worker = new DataMoveWorker(pman, this.m_sourceConnectionName, this.m_generationConnectionName, convertedConnectionId, MigrationAddin.getMigrationConfig().getNumDataMoveThreads(), MigrationAddin.getMigrationConfig().getDataMoveCommitInterval(), !this.m_leastPrivilege);
            worker.addListener(dmg);
            JPanel panel = new JPanel();
            BorderLayout layout = new BorderLayout();
            layout.setVgap(10);
            panel.setLayout(layout);
            panel.add((Component)dmg.getCurrentActivityPanel(), "North");
            panel.add((Component)dmg.getCompletedActivityPanel(), "Center");
            this.m_topPanel.addTab(null, MigrationAddinArb.getString(356), panel);
            this.m_topPanel.nextStep();
            worker.doWork();
        }
        catch (DataMoveException dmex) {
            s_logger.log(Level.WARNING, "DataMove.EXCEPTION", dmex.getLocalizedMessage());
            return false;
        }
        catch (PersistenceException e) {
            s_logger.log(Level.WARNING, "DataMove.EXCEPTION", e.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public JPanel getDownPanel() {
        return null;
    }

    public JPanel getTopPanel() {
        if (this.m_topPanel == null) {
            this.m_topPanel = new FullMigrationTopPanel(this.m_needToCreateARepo, this.m_needToDropARepo);
        }
        return this.m_topPanel;
    }

    public void updateAbovePanel(Object object) {
    }

    public void updateBelowPanel(Object object) {
    }

    public void updateProgress(int completionStatus, Object aboveInformation, Object belowInformation) {
        if (this.m_currentStep != null) {
            if (this.m_currentStep.equals(CURRENTSTEP_CREATE) || this.m_currentStep.equals(CURRENTSTEP_REMOVE)) {
                this.getProgBar().getProgressBar().setValue(completionStatus);
                this.getProgBar().getProgressBar().setString("(" + completionStatus + "%)");
                this.m_currentRepoPanel.update(completionStatus, (String)belowInformation);
                if (completionStatus == 100) {
                    this.m_currentRepoPanel.complete();
                }
            } else {
                super.updateProgress(completionStatus, aboveInformation, belowInformation);
            }
        }
    }

    public void setContext(Context context) {
        this.m_context = context;
    }
}

