/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.EventStatusModel;
import oracle.dbtools.migration.workbench.core.ui.FullMigrationPreRequisiteChecker;
import oracle.dbtools.migration.workbench.core.ui.PreReqListener;
import oracle.dbtools.migration.workbench.core.ui.SimpleTablePanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.DatabaseConnectionEditor;

public class FullMigrationChoiceDialog
extends JEWTDialog {
    private static final String HTMLCONTENT = "text/html";
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTextPane m_txtSourceDescription = new JTextPane();
    private JComboBox m_cmbSourceConnection = new JComboBox();
    private JComboBox m_cmbTarget = new JComboBox();
    private JLabel m_lblSourceConnection = new JLabel();
    private JButton m_btnAddSource = new JButton();
    private JSeparator m_jSeparator1 = new JSeparator();
    private JTextPane m_txtRepoDesc = new JTextPane();
    private JComboBox m_cmbRepo = new JComboBox();
    private JSeparator m_jSeparator2 = new JSeparator();
    private JTextPane m_txtTargetDesc = new JTextPane();
    private JButton m_btnAddTarget = new JButton();
    private JSeparator jSeparator3 = new JSeparator();
    private JButton m_btnTest = new JButton();
    private JTextPane m_txtTestDesc = new JTextPane();
    private PreReqResultsPanel m_testResultsPanel = new PreReqResultsPanel();
    private JTextArea m_lblRepo = new JTextArea();
    private JCheckBox m_checkKeepRepo = new JCheckBox();
    private FullMigrationPreRequisiteChecker m_checker = null;
    private JLabel m_lblMigrationType = new JLabel();
    private JComboBox m_cmbMigrationType = new JComboBox();
    private String m_sourceConnectionName;
    private String m_targetConnectionName;
    private String m_repositoryName;
    private boolean m_sourceIsPreSelected = false;

    public FullMigrationChoiceDialog(Frame f, String sourceConnectionName) {
        super(f);
        this.setButtonMask(7);
        this.setOKButtonEnabled(false);
        this.setOKButtonText(MigrationAddinArb.getString(387));
        this.setOKButtonMnemonic(MigrationAddinArb.getMnemonic(388));
        this.setTitle(MigrationAddinArb.getString(380));
        this.setResizable(true);
        this.setModal(true);
        this.setCancelButtonMnemonic(MigrationAddinArb.getMnemonic(389));
        if (sourceConnectionName != null) {
            this.m_sourceConnectionName = sourceConnectionName;
            this.m_sourceIsPreSelected = true;
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void jbInit() throws Exception {
        JComponent sourceComponent;
        JPanel panel = new JPanel();
        this.m_lblRepo.setWrapStyleWord(true);
        this.m_lblRepo.setLineWrap(true);
        this.m_lblRepo.setEditable(false);
        this.m_lblRepo.setOpaque(false);
        this.m_lblRepo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Font f = this.m_btnAddSource.getFont();
        String fontStyle = MigrationUtils.fontToCSSString(f);
        panel.setLayout(this.gridBagLayout1);
        this.m_txtSourceDescription.setContentType(HTMLCONTENT);
        this.m_txtSourceDescription.setText(MigrationAddinArb.format(401, fontStyle));
        this.m_txtSourceDescription.setEditable(false);
        this.m_txtSourceDescription.setOpaque(false);
        this.m_txtSourceDescription.setRequestFocusEnabled(false);
        this.m_txtSourceDescription.setFocusable(false);
        Dimension jewtButtonSize = new Dimension(72, 22);
        this.m_btnAddSource.setMinimumSize(jewtButtonSize);
        this.m_btnAddSource.setMaximumSize(jewtButtonSize);
        this.m_btnAddSource.setPreferredSize(jewtButtonSize);
        this.m_btnAddSource.setMnemonic(MigrationAddinArb.getMnemonic(382));
        this.m_btnAddTarget.setMinimumSize(jewtButtonSize);
        this.m_btnAddTarget.setMaximumSize(jewtButtonSize);
        this.m_btnAddTarget.setPreferredSize(jewtButtonSize);
        this.m_btnAddTarget.setMnemonic(MigrationAddinArb.getMnemonic(384));
        this.m_btnTest.setMinimumSize(jewtButtonSize);
        this.m_btnTest.setMaximumSize(jewtButtonSize);
        this.m_btnTest.setPreferredSize(jewtButtonSize);
        this.m_btnTest.setMnemonic(MigrationAddinArb.getMnemonic(386));
        this.m_lblMigrationType.setText(MigrationAddinArb.getString(376));
        this.m_cmbMigrationType.addItem(MigrationAddinArb.getString(377));
        this.m_cmbMigrationType.addItem(MigrationAddinArb.getString(378));
        this.m_cmbMigrationType.addItem(MigrationAddinArb.getString(379));
        this.m_cmbRepo.setRenderer(new DBConnComboRenderer());
        this.m_cmbSourceConnection.setRenderer(new DBConnComboRenderer());
        this.m_cmbTarget.setRenderer(new DBConnComboRenderer());
        panel.add((Component)this.m_txtSourceDescription, new GridBagConstraints(0, 0, 1, 1, 3.0, 0.0, 18, 1, new Insets(0, 5, 0, 5), 0, 0));
        if (this.m_sourceIsPreSelected) {
            sourceComponent = this.m_lblSourceConnection;
            this.m_lblSourceConnection.setText(Connections.getDisplayName((String)this.m_sourceConnectionName));
        } else {
            sourceComponent = this.m_cmbSourceConnection;
            this.m_cmbSourceConnection.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FullMigrationChoiceDialog.this.sourceConnectionSelectionChange();
                }
            });
        }
        panel.add((Component)sourceComponent, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (!this.m_sourceIsPreSelected) {
            panel.add((Component)this.m_btnAddSource, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        panel.add((Component)this.m_jSeparator1, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_txtTargetDesc, new GridBagConstraints(0, 2, 1, 1, 3.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_cmbTarget, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_btnAddTarget, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_jSeparator2, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_txtRepoDesc, new GridBagConstraints(0, 4, 1, 2, 3.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_cmbRepo, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_lblRepo, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), -200, 0));
        this.m_checkKeepRepo.setVisible(false);
        panel.add((Component)this.m_checkKeepRepo, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.jSeparator3, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_btnTest, new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_txtTestDesc, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.m_testResultsPanel.getPanel(), new GridBagConstraints(0, 8, 4, 1, 0.0, 0.0, 11, 2, new Insets(10, 20, 10, 20), 0, 73));
        JPanel typPanel = new JPanel();
        typPanel.setLayout(new FlowLayout());
        typPanel.add(this.m_lblMigrationType);
        typPanel.add(this.m_cmbMigrationType);
        panel.add((Component)typPanel, new GridBagConstraints(2, 9, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_btnAddSource.setText(MigrationAddinArb.getString(381));
        this.m_btnAddSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FullMigrationChoiceDialog.this.newSourceOrTarget();
            }
        });
        this.m_txtTargetDesc.setContentType(HTMLCONTENT);
        this.m_txtTargetDesc.setText(MigrationAddinArb.format(402, fontStyle));
        this.m_txtTargetDesc.setEditable(false);
        this.m_txtTargetDesc.setOpaque(false);
        this.m_txtTargetDesc.setRequestFocusEnabled(false);
        this.m_txtTargetDesc.setFocusable(false);
        this.m_btnAddTarget.setText(MigrationAddinArb.getString(383));
        this.m_btnAddTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FullMigrationChoiceDialog.this.newSourceOrTarget();
            }
        });
        this.m_btnTest.setText(MigrationAddinArb.getString(385));
        this.m_btnTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FullMigrationChoiceDialog.this.performTest();
            }
        });
        this.m_txtTestDesc.setContentType(HTMLCONTENT);
        this.m_txtTestDesc.setText(MigrationAddinArb.format(404, fontStyle));
        this.m_txtTestDesc.setEditable(false);
        this.m_txtTestDesc.setOpaque(false);
        this.m_txtTestDesc.setRequestFocusEnabled(false);
        this.m_txtTestDesc.setFocusable(false);
        this.populatecConnectionCombos(false);
        this.populateRepositoryField(fontStyle);
        this.setButtonStates();
        this.m_cmbTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FullMigrationChoiceDialog.this.targetConnectionSelectionChange();
            }
        });
        this.setContent(panel);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_quickmigrate_html");
        this.pack();
        this.setResizable(false);
    }

    private void populatecConnectionCombos(boolean setAsBefore) {
        String[] allConns;
        String grabSourceConnectionName = null;
        String grabTargetConnectionName = null;
        if (setAsBefore) {
            if (!this.m_sourceIsPreSelected) {
                grabSourceConnectionName = (String)this.m_cmbSourceConnection.getSelectedItem();
            }
            grabTargetConnectionName = (String)this.m_cmbTarget.getSelectedItem();
        }
        this.m_cmbSourceConnection.removeAllItems();
        this.m_cmbTarget.removeAllItems();
        Connections conns = Connections.getInstance();
        for (String s : allConns = conns.getConnNames()) {
            if (conns.isOracle(s)) {
                this.m_cmbTarget.addItem(s);
                continue;
            }
            this.m_cmbSourceConnection.addItem(s);
        }
        if (setAsBefore) {
            if (grabSourceConnectionName != null && !this.m_sourceIsPreSelected) {
                this.m_cmbSourceConnection.setSelectedItem(grabSourceConnectionName);
            }
            if (grabTargetConnectionName != null) {
                this.m_cmbTarget.setSelectedItem(grabTargetConnectionName);
            }
        }
        if (!this.m_sourceIsPreSelected) {
            this.sourceConnectionSelectionChange();
        }
        this.targetConnectionSelectionChange();
    }

    private void populateRepositoryField(String fontStyle) {
        String status;
        String[] allRepos = this.getConfiguredRepositories();
        if (allRepos == null || allRepos.length == 0) {
            status = MigrationAddinArb.getString(405);
            this.m_cmbRepo.setVisible(false);
            this.m_checkKeepRepo.setText(MigrationAddinArb.getString(390));
            this.m_checkKeepRepo.setHorizontalAlignment(2);
            this.m_checkKeepRepo.setVerticalAlignment(1);
            this.m_checkKeepRepo.setVerticalTextPosition(1);
            this.m_checkKeepRepo.setVisible(true);
        } else if (allRepos.length == 1) {
            String repoName = Connections.getDisplayName((String)allRepos[0]);
            status = MigrationAddinArb.format(406, repoName);
            this.m_cmbRepo.setVisible(false);
            this.m_checkKeepRepo.setVisible(false);
            this.m_repositoryName = allRepos[0];
        } else {
            this.m_cmbRepo.removeAllItems();
            for (String s : allRepos) {
                this.m_cmbRepo.addItem(s);
            }
            status = MigrationAddinArb.getString(407);
            this.m_checkKeepRepo.setVisible(false);
        }
        this.m_lblRepo.setText(status);
        this.m_lblRepo.setVisible(true);
        this.m_txtRepoDesc.setContentType(HTMLCONTENT);
        this.m_txtRepoDesc.setText(MigrationAddinArb.format(403, fontStyle));
        this.m_txtRepoDesc.setOpaque(false);
        this.m_txtRepoDesc.setEditable(false);
        this.m_txtRepoDesc.setRequestFocusEnabled(false);
        this.m_txtRepoDesc.setFocusable(false);
    }

    private String[] getConfiguredRepositories() {
        ArrayList<String> ret = new ArrayList<String>();
        MigrationConfig config = MigrationAddin.getMigrationConfig();
        String[] allRepos = config.getRepositories();
        if (allRepos == null || allRepos.length == 0) {
            return null;
        }
        String[] allConns = Connections.getInstance().getConnNames();
        block0: for (String s : allRepos) {
            for (String toCheck : allConns) {
                if (!toCheck.equalsIgnoreCase(s) || !Connections.getInstance().isOracle(toCheck)) continue;
                ret.add(toCheck);
                continue block0;
            }
        }
        if (ret.size() == 0) {
            return null;
        }
        return ret.toArray(new String[ret.size()]);
    }

    private void newSourceOrTarget() {
        DatabaseConnectionEditor.editConnection((String)"IdeConnections", null);
        this.populatecConnectionCombos(true);
    }

    private void setButtonStates() {
        if ((this.m_cmbSourceConnection.getSelectedIndex() != -1 || this.m_sourceIsPreSelected) && this.m_cmbTarget.getSelectedIndex() != -1) {
            this.m_btnTest.setEnabled(true);
        } else {
            this.m_btnTest.setEnabled(false);
        }
    }

    private String getRepoName() {
        if (this.m_repositoryName == null) {
            return (String)this.m_cmbRepo.getSelectedItem();
        }
        return this.m_repositoryName;
    }

    protected void performTest() {
        this.setOKButtonEnabled(false);
        if (this.m_checker != null) {
            this.m_checker.allDone();
        }
        this.m_checker = new FullMigrationPreRequisiteChecker(this.m_sourceConnectionName, this.m_targetConnectionName, this.getRepoName());
        this.m_testResultsPanel.reset();
        this.m_checker.addListener(this.m_testResultsPanel);
        int result = this.m_checker.runTests();
        if (result == 2) {
            StringBuffer multiPrivMsg = new StringBuffer(MigrationAddinArb.getString(448));
            multiPrivMsg.append("\n");
            multiPrivMsg.append(this.m_checker.getPrivWarning());
            MessageDialog.information((Component)((Object)this), (Object)multiPrivMsg.toString(), (String)MigrationAddinArb.getString(449), (String)"help_migrate_privileges");
        }
        this.setOKButtonEnabled(result != 1);
    }

    private void resetTest() {
        this.m_btnTest.setEnabled(true);
        this.setOKButtonEnabled(false);
    }

    private void sourceConnectionSelectionChange() {
        String currentSelection = (String)this.m_cmbSourceConnection.getSelectedItem();
        if (FullMigrationChoiceDialog.stringsDiffer(currentSelection, this.m_sourceConnectionName)) {
            this.resetTest();
            this.m_sourceConnectionName = currentSelection;
        }
    }

    private void targetConnectionSelectionChange() {
        String currentSelection = (String)this.m_cmbTarget.getSelectedItem();
        if (FullMigrationChoiceDialog.stringsDiffer(currentSelection, this.m_targetConnectionName)) {
            this.resetTest();
            this.m_targetConnectionName = currentSelection;
        }
    }

    private static boolean stringsDiffer(String s1, String s2) {
        if (s1 == null) {
            return s2 != null;
        }
        if (s2 == null) {
            return true;
        }
        return !s1.equals(s2);
    }

    public MigrationPlugin getPlugin() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getPlugin();
    }

    public Connection getSourceConnection() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getSourceConnection();
    }

    public Connection getTargetConnection() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getTargetConnection();
    }

    public String getSourceConnectionName() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getSrcConnName();
    }

    public String getTargetConnectionName() {
        if (this.m_checker == null) {
            return null;
        }
        return this.m_checker.getTrgConnName();
    }

    public boolean getCleanupRepoFlag() {
        if (this.m_checkKeepRepo.isVisible()) {
            return !this.m_checkKeepRepo.isSelected();
        }
        return false;
    }

    public String getMigrationType() {
        return (String)this.m_cmbMigrationType.getSelectedItem();
    }

    public void resetChecker() {
        if (this.m_checker != null) {
            this.m_checker.allDone();
        }
    }

    private class DBConnComboRenderer
    extends DefaultListCellRenderer {
        private DBConnComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String nVal = value == null ? "" : Connections.getDisplayName((String)((String)value));
            return super.getListCellRendererComponent((JList<?>)list, nVal, index, isSelected, cellHasFocus);
        }
    }

    private static class PreReqResultsPanel
    implements PreReqListener {
        private EventStatusModel m_model = new EventStatusModel(new String[]{MigrationAddinArb.getString(391), MigrationAddinArb.getString(392), MigrationAddinArb.getString(393)});
        private SimpleTablePanel m_eventPanel = new SimpleTablePanel(600, null, this.m_model);

        public SimpleTablePanel getPanel() {
            return this.m_eventPanel;
        }

        public void testCompleted(String testName, boolean result, String optionalMessage) {
            String[] info = new String[]{testName, result ? MigrationAddinArb.getString(395) : MigrationAddinArb.getString(396), optionalMessage};
            this.m_eventPanel.updateProgress(info);
        }

        public void testStarted(String testName, String optionalMessage) {
            String[] info = new String[]{testName, MigrationAddinArb.getString(394), optionalMessage};
            this.m_eventPanel.updateProgress(info);
        }

        public void reset() {
            this.m_model.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MIGRATIONTYPE {
        TABLE,
        TABLEANDDATA,
        EVERYTHING;

    }
}

