/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.repository.PrivilegeManager;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.PreReqListener;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.db.DBException;

public class FullMigrationPreRequisiteChecker {
    public static final int ALL_OK = 0;
    public static final int FAIL = 1;
    public static final int WARN = 2;
    private static final String CREATE_USER_PRIV = "CREATE USER";
    private static final String CREATE_SEQUENCE_PRIV = "CREATE SEQUENCE";
    private static final String CREATE_TRIGGER_PRIV = "CREATE TRIGGER";
    private static final String CREATE_SESSION_PRIV = "CREATE SESSION";
    private static final String CREATE_VIEW_PRIV = "CREATE VIEW";
    private static final String CREATE_CLUSTER_PRIV = "CREATE CLUSTER";
    private static final String CREATE_PROCEDURE_PRIV = "CREATE PROCEDURE";
    private static final String CREATE_TYPE_PRIV = "CREATE TYPE";
    private static final String CREATE_OPERATOR_PRIV = "CREATE OPERATOR";
    private static final String CREATE_TABLE_PRIV = "CREATE TABLE";
    private static final String CREATE_INDEXTYPE_PRIV = "CREATE INDEXTYPE";
    private static final String RESOURCE_ROLE = "RESOURCE";
    private static final String CREATE_ROLE_PRIV = "CREATE ROLE";
    private static final String ALTER_ANY_TRIGGER_PRIV = "ALTER ANY TRIGGER";
    private String m_PrivilegeWarning;
    private static final String[] LEAST_PRIVILEGE_PRIVILEGES = new String[]{"CREATE SESSION", "CREATE SEQUENCE", "CREATE TRIGGER", "CREATE CLUSTER", "CREATE PROCEDURE", "CREATE TYPE", "CREATE OPERATOR", "CREATE INDEXTYPE", "CREATE VIEW"};
    private static final PrivilegeManager.Privilege[] MULTI_SCHEMA_PRIVILEGES = new PrivilegeManager.Privilege[]{new PrivilegeManager.Privilege("CREATE ROLE", true), new PrivilegeManager.Privilege("CREATE USER", false), new PrivilegeManager.Privilege("ALTER ANY TRIGGER", true)};
    private static final PrivilegeManager.Privilege[] MULTI_SCHEMA_ROLES = new PrivilegeManager.Privilege[]{new PrivilegeManager.Privilege("RESOURCE", true)};
    private String m_srcConnName;
    private String m_trgConnName;
    private String m_repoName;
    private ArrayList<PreReqListener> m_audience;
    private Connection m_sourceConnection;
    private Connection m_targetConnection;
    private Connection m_repoConnection;
    private MigrationPlugin m_plugin;
    private PrivilegeManager m_privilegeManager;

    public FullMigrationPreRequisiteChecker(String sourceConnName, String targConnName, String repoName) {
        this.setSrcConnName(sourceConnName);
        this.setTrgConnName(targConnName);
        this.setRepoName(repoName);
        this.m_audience = new ArrayList();
        this.cleanupOutputVars();
    }

    public void allDone() {
        this.cleanupOutputVars();
    }

    private void cleanupOutputVars() {
        if (this.m_sourceConnection != null) {
            Connections.getInstance().closeConnection(this.m_srcConnName);
            this.m_sourceConnection = null;
        }
        if (this.m_targetConnection != null) {
            Connections.getInstance().closeConnection(this.m_trgConnName);
            this.m_targetConnection = null;
        }
        if (this.m_repoConnection != null) {
            Connections.getInstance().closeConnection(this.m_repoName);
            this.m_repoConnection = null;
            MigrationAddin.disconnectRepository();
        }
        this.m_plugin = null;
    }

    public int runTests() {
        boolean bMinPrivsOK = false;
        boolean bMaxPrivsOK = false;
        boolean bSourceOK = this.checkSourceConnection();
        boolean bPluginAvailable = this.checkSourcePluginAvailable();
        boolean bTargetOK = this.checkTargetConnection();
        boolean bRepoOK = this.checkRepository();
        if (bTargetOK && (bMinPrivsOK = this.checkLeastPrivilegePerms())) {
            bMaxPrivsOK = this.checkMultiPrivileges();
        }
        if (bSourceOK && bPluginAvailable && bTargetOK && bRepoOK && bMinPrivsOK) {
            if (bMaxPrivsOK) {
                return 0;
            }
            return 2;
        }
        return 1;
    }

    private boolean checkMultiPrivileges() {
        String test = MigrationAddinArb.getString(442);
        String msg = "";
        this.fireStartTest(test, null);
        for (PrivilegeManager.Privilege p : MULTI_SCHEMA_PRIVILEGES) {
            if (!this.m_privilegeManager.hasPrivilege(p.getName())) {
                this.m_PrivilegeWarning = msg = MigrationAddinArb.format(444, p.getName());
                return this.fireEndTest(test, false, msg);
            }
            if (!p.isGrantable() || this.m_privilegeManager.hasPrivilegeWithAdmin(p.getName())) continue;
            this.m_PrivilegeWarning = msg = MigrationAddinArb.format(445, p.getName());
            return this.fireEndTest(test, false, msg);
        }
        this.fireEndTest(test, true, null);
        test = MigrationAddinArb.getString(443);
        this.fireStartTest(test, null);
        for (PrivilegeManager.Privilege p : MULTI_SCHEMA_ROLES) {
            if (!this.m_privilegeManager.hasRole(p.getName())) {
                this.m_PrivilegeWarning = msg = MigrationAddinArb.format(446, p.getName());
                return this.fireEndTest(test, false, msg);
            }
            if (!p.isGrantable() || this.m_privilegeManager.hasRoleWithAdmin(p.getName())) continue;
            this.m_PrivilegeWarning = msg = MigrationAddinArb.format(447, p.getName());
            return this.fireEndTest(test, false, msg);
        }
        return this.fireEndTest(test, true, null);
    }

    private boolean checkRepoPerms() {
        String test = MigrationAddinArb.format(414, Connections.getDisplayName((String)this.m_trgConnName));
        boolean result = true;
        this.fireStartTest(test, null);
        URL url = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)this.m_trgConnName);
        DBObject dbo = new DBObject(url);
        result = RepositoryManager.gotUserPermission(dbo);
        this.fireEndTest(test, result, null);
        return result;
    }

    private boolean checkLeastPrivilegePerms() {
        String test = "Checking target rights";
        this.fireStartTest(test, null);
        try {
            this.m_privilegeManager = new PrivilegeManager(this.m_targetConnection);
            String privs = "";
            for (String s : LEAST_PRIVILEGE_PRIVILEGES) {
                if (this.m_privilegeManager.hasPrivilege(s)) continue;
                privs = privs + s + " \n";
            }
            if (privs.length() > 0) {
                return this.fireEndTest(test, false, "Missing privilege(s) " + privs);
            }
            return this.fireEndTest(test, true, null);
        }
        catch (SQLException sqlex) {
            return this.fireEndTest(test, false, "Could not determine privileges " + sqlex.getLocalizedMessage());
        }
    }

    private Connection checkJDBCConnection(String testName, String connName) {
        this.fireStartTest(testName, null);
        String sMsg = null;
        Connection retConn = null;
        boolean res = true;
        try {
            ConnectionSelectorUI.SELECTOR_ACTIVE = true;
            retConn = Connections.getInstance().getConnection(connName);
        }
        catch (DBException dbe) {
            sMsg = dbe.getLocalizedMessage();
            res = false;
        }
        ConnectionSelectorUI.SELECTOR_ACTIVE = false;
        this.fireEndTest(testName, res, sMsg);
        return retConn;
    }

    private boolean checkRepository() {
        String[] allRepos;
        boolean bIsAConfiguredRepo = false;
        for (String s : allRepos = MigrationAddin.getMigrationConfig().getRepositories()) {
            if (!s.equals(this.m_repoName)) continue;
            bIsAConfiguredRepo = true;
            break;
        }
        String testName = MigrationAddinArb.getString(413);
        if (bIsAConfiguredRepo) {
            String repoName = MigrationAddin.getRepositoryConnectionName();
            if (repoName != null && repoName.equals(this.m_repoName)) {
                this.fireStartTest(testName, null);
                this.fireEndTest(testName, true, null);
                return true;
            }
            MigrationAddin.getMigrationConfig().setDefaultRepository(this.m_repoName);
            this.m_repoConnection = this.checkJDBCConnection(testName, this.m_repoName);
            return this.m_repoConnection != null;
        }
        this.fireStartTest(testName, null);
        boolean haveRepoPerms = this.checkRepoPerms();
        this.fireEndTest(testName, true, null);
        return haveRepoPerms;
    }

    private boolean checkTargetConnection() {
        String test = MigrationAddinArb.format(412, Connections.getDisplayName((String)this.m_trgConnName));
        this.m_targetConnection = this.checkJDBCConnection(test, this.m_trgConnName);
        return this.m_targetConnection != null;
    }

    private boolean checkSourceConnection() {
        String test = MigrationAddinArb.format(410, Connections.getDisplayName((String)this.m_srcConnName));
        this.m_sourceConnection = this.checkJDBCConnection(test, this.m_srcConnName);
        return this.m_sourceConnection != null;
    }

    private boolean checkSourcePluginAvailable() {
        String test = MigrationAddinArb.getString(411);
        this.m_plugin = MigrationAddin.getPluginForConnection(this.m_sourceConnection);
        this.fireEndTest(test, this.m_plugin != null, null);
        return this.m_plugin != null;
    }

    public void addListener(PreReqListener listener) {
        if (!this.m_audience.contains(listener)) {
            this.m_audience.add(listener);
        }
    }

    protected void setRepoName(String repoName) {
        this.m_repoName = repoName;
    }

    protected void setSrcConnName(String srcConnName) {
        if (srcConnName == null) {
            throw new IllegalArgumentException("source connection cannot be null");
        }
        this.m_srcConnName = srcConnName;
    }

    protected void setTrgConnName(String trgConnName) {
        if (trgConnName == null) {
            throw new IllegalArgumentException("target conncection cannot be null");
        }
        this.m_trgConnName = trgConnName;
    }

    protected void fireStartTest(String testName, String optionalMessage) {
        for (PreReqListener l : this.m_audience) {
            l.testStarted(testName, optionalMessage);
        }
    }

    protected boolean fireEndTest(String testName, boolean result, String optionalMessage) {
        for (PreReqListener l : this.m_audience) {
            l.testCompleted(testName, result, optionalMessage);
        }
        return result;
    }

    public MigrationPlugin getPlugin() {
        return this.m_plugin;
    }

    public Connection getSourceConnection() {
        return this.m_sourceConnection;
    }

    public Connection getTargetConnection() {
        return this.m_targetConnection;
    }

    public String getSrcConnName() {
        return this.m_srcConnName;
    }

    public String getTrgConnName() {
        return this.m_trgConnName;
    }

    public String getPrivWarning() {
        return this.m_PrivilegeWarning;
    }
}

