/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.raptor.controls.CustomTabbedPane;

public class FullMigrationTopPanel
extends JPanel {
    private static final String[] STEPS = new String[]{MigrationAddinArb.getString(346), MigrationAddinArb.getString(348), MigrationAddinArb.getString(350), MigrationAddinArb.getString(352), MigrationAddinArb.getString(354), MigrationAddinArb.getString(356), MigrationAddinArb.getString(358)};
    private static final String[] ICONS = new String[]{"repo_add", "capture", "convert", "generate", "create", "move", "repo_remove"};
    private JPanel m_statusPanel = new JPanel();
    private JLabel[] m_stepLabels;
    private CustomTabbedPane m_tabPane = new CustomTabbedPane();
    private int m_currentStep;

    public FullMigrationTopPanel(boolean createRepo, boolean removeRepo) {
        int numSteps = STEPS.length;
        if (!removeRepo) {
            --numSteps;
        }
        if (!createRepo) {
            --numSteps;
        }
        this.m_stepLabels = new JLabel[numSteps];
        this.m_currentStep = 0;
        try {
            this.jbInit(createRepo, removeRepo);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void jbInit(boolean createRepo, boolean removeRepo) throws Exception {
        BorderLayout borderLayout1 = new BorderLayout();
        Font font = new Font("Dialog", 0, 12);
        this.setLayout(borderLayout1);
        BoxLayout bl = new BoxLayout(this.m_statusPanel, 0);
        this.m_statusPanel.setLayout(bl);
        this.m_tabPane.setBounds(new Rectangle(0, 42, 500, 278));
        borderLayout1.setVgap(10);
        int endPoint = !removeRepo ? STEPS.length - 1 : STEPS.length;
        int startPoint = createRepo ? 0 : 1;
        int lblIndex = 0;
        for (int i = startPoint; i < endPoint; ++i) {
            this.m_stepLabels[lblIndex] = new GreyableLabel();
            this.m_stepLabels[lblIndex].setText(STEPS[i]);
            this.m_stepLabels[lblIndex].setFont(font);
            this.m_stepLabels[lblIndex].setEnabled(false);
            String sFilename = "images/" + ICONS[i] + ".png";
            URL url = this.getClass().getResource(sFilename);
            ImageIcon icon = new ImageIcon(url);
            this.m_stepLabels[lblIndex].setIcon(icon);
            sFilename = "images/" + ICONS[i] + "-des.png";
            url = this.getClass().getResource(sFilename);
            ImageIcon desIcon = new ImageIcon(url);
            this.m_stepLabels[lblIndex].setDisabledIcon(desIcon);
            this.m_stepLabels[lblIndex].setVerticalTextPosition(3);
            this.m_stepLabels[lblIndex].setHorizontalTextPosition(0);
            this.m_stepLabels[lblIndex].setAlignmentY(0.0f);
            this.m_statusPanel.add(this.m_stepLabels[lblIndex]);
            if (lblIndex < this.m_stepLabels.length - 1) {
                this.m_statusPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            }
            ++lblIndex;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        panel.add(this.m_statusPanel);
        this.add((Component)panel, "North");
        this.add((Component)this.m_tabPane, "Center");
        this.setPreferredSize(new Dimension(500, 350));
        this.setSize(this.getPreferredSize());
    }

    public void setCurrentStep(int step) {
        if (step < 0 || step >= this.m_stepLabels.length) {
            return;
        }
        for (int i = 0; i < this.m_stepLabels.length; ++i) {
            this.m_stepLabels[i].setEnabled(i <= step);
            FullMigrationTopPanel.setBold(this.m_stepLabels[i], i == step);
        }
        this.m_tabPane.setSelectedIndex(Math.min(step, this.m_tabPane.getNumberOfTabs() - 1));
    }

    public void nextStep() {
        this.setCurrentStep(this.m_currentStep++);
    }

    public CustomTabbedPane getTabbedPane() {
        return this.m_tabPane;
    }

    public void addTab(Icon icon, String title, Component component) {
        this.m_tabPane.addTab(icon, title, component);
    }

    private static void setBold(JLabel label, boolean b) {
        Font f = label.getFont();
        if (b) {
            label.setFont(f.deriveFont(1));
        } else {
            label.setFont(f.deriveFont(0));
        }
    }

    private static class GreyableLabel
    extends JLabel {
        private GreyableLabel() {
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
            this.setForeground(b ? (Color)UIManager.get("Label.foreground") : (Color)UIManager.get("Label.disabledForeground"));
        }
    }
}

