/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.generate.GenerateEvent;
import oracle.dbtools.migration.generate.GenerateEventListener;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.AbstractCommonMigrationProgressRunnable;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.IdeUtil;

public class GenerateRunner
extends AbstractCommonMigrationProgressRunnable
implements GenerateEventListener {
    private GenerateWorker m_worker;
    private URL m_url;

    public GenerateRunner(GenerateWorker worker, URL url) {
        this.m_worker = worker;
        this.m_url = url;
        this.setTitle(MigrationAddinArb.getString(167));
        this.setMessage(MigrationAddinArb.getString(168));
    }

    public GenerateRunner(GenerateWorker worker) {
        this(worker, null);
    }

    protected Object doWork() throws Exception {
        this.m_worker.addEventListener(this);
        if (this.m_worker.runGenerate(MigrationAddin.getMigrationConfig().getSingleSchemaLeastPrivilege())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected void doCancel() {
        super.doCancel();
        this.m_worker.signalCancel();
    }

    public void raiseEvent(GenerateEvent event) {
        String progressLabel = "";
        switch (event.getEventId()) {
            case 1: {
                progressLabel = MigrationAddinArb.getString(163) + " " + event.getEventSource();
                this.updateProgress(1, event, progressLabel);
                break;
            }
            case 2: {
                progressLabel = event.getEventSource() + " " + MigrationAddinArb.getString(164);
                this.updateProgress(2, event, progressLabel);
                break;
            }
            case 4: {
                progressLabel = MigrationAddinArb.getString(161);
                this.updateProgress(4, event, progressLabel);
                break;
            }
            case 5: {
                progressLabel = MigrationAddinArb.getString(162);
                this.updateProgress(5, event, progressLabel);
                break;
            }
            case 6: {
                progressLabel = MigrationAddinArb.getString(165);
                this.updateProgress(6, event, progressLabel);
            }
        }
    }

    protected void finish(Object result) {
        Boolean bObj;
        super.finish(result);
        if (result != null && (bObj = (Boolean)result).booleanValue() && this.m_url != null) {
            SqlNode node = null;
            try {
                final SqlNode sn = node = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)this.m_url);
                if (sn != null) {
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)sn);
                        }
                    });
                }
            }
            catch (InstantiationException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (IllegalAccessException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
    }

    public String[] getColumnNames() {
        return new String[]{MigrationAddinArb.getString(154), MigrationAddinArb.getString(166)};
    }

    public String getEventString(Object event) {
        if (event != null && event instanceof GenerateEvent) {
            GenerateEvent eve = (GenerateEvent)event;
            String objType = null;
            if (eve.getEventId() == 1) {
                for (int i = 0; i < GenerateEvent.GENERATE_OBJECTS.length; ++i) {
                    if (!eve.getEventSourceType().equalsIgnoreCase(GenerateEvent.GENERATE_OBJECTS[i])) continue;
                    objType = GenerateEvent.GENERATE_OBJECTS[i];
                }
            }
            return objType;
        }
        return null;
    }

    public void setTableCellRenderer() {
    }

    public void setToolTip() {
    }
}

