/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IntegerDocument
extends PlainDocument {
    int currentValue = 0;

    public int getValue() {
        return this.currentValue;
    }

    public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
        if (string != null) {
            String newValue;
            int length = this.getLength();
            if (length == 0) {
                newValue = string;
            } else {
                String currentContent = this.getText(0, length);
                StringBuffer currentBuffer = new StringBuffer(currentContent);
                currentBuffer.insert(offset, string);
                newValue = currentBuffer.toString();
            }
            this.currentValue = this.checkInput(newValue, offset);
            super.insertString(offset, string, attributes);
        }
    }

    public void remove(int offset, int length) throws BadLocationException {
        int currentLength = this.getLength();
        String currentContent = this.getText(0, currentLength);
        String before = currentContent.substring(0, offset);
        String after = currentContent.substring(length + offset, currentLength);
        String newValue = before + after;
        this.currentValue = this.checkInput(newValue, offset);
        super.remove(offset, length);
    }

    public int checkInput(String proposedValue, int offset) throws BadLocationException {
        if (proposedValue.length() > 0) {
            try {
                int newValue = Integer.parseInt(proposedValue);
                return newValue;
            }
            catch (NumberFormatException e) {
                throw new BadLocationException(proposedValue, offset);
            }
        }
        return 0;
    }
}

