/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationCapturePanel
extends JPanel {
    private JTree tree;
    private JComboBox m_connectionComboBox;
    private JComboBox m_pluginComboBox;

    public MigrationCapturePanel() {
        String[] plugins = this.getPluginList(MigrationAddin.getPlugins());
        String[] connString = new String[]{"MySQLConn", "SQLServer"};
        this.setLayout(new GridBagLayout());
        this.m_pluginComboBox = new JComboBox<String>(plugins);
        this.m_pluginComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object o = e.getSource();
                if (((JComboBox)o).getSelectedItem().toString().toLowerCase().contains("mysql")) {
                    MigrationCapturePanel.this.m_connectionComboBox.setSelectedIndex(0);
                } else {
                    MigrationCapturePanel.this.m_connectionComboBox.setSelectedIndex(0);
                }
            }
        });
        GridBagConstraints m_pluginComboBoxConstraints = new GridBagConstraints();
        m_pluginComboBoxConstraints.insets = new Insets(5, 5, 5, 10);
        m_pluginComboBoxConstraints.fill = 2;
        m_pluginComboBoxConstraints.gridwidth = 2;
        m_pluginComboBoxConstraints.gridy = 0;
        m_pluginComboBoxConstraints.gridx = 0;
        this.add((Component)this.m_pluginComboBox, m_pluginComboBoxConstraints);
        this.m_connectionComboBox = new JComboBox<String>(connString);
        this.m_connectionComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        GridBagConstraints m_connectionConstraints = new GridBagConstraints();
        m_connectionConstraints.insets = new Insets(0, 5, 0, 10);
        m_connectionConstraints.fill = 2;
        m_connectionConstraints.gridwidth = 2;
        m_connectionConstraints.gridy = 1;
        m_connectionConstraints.gridx = 0;
        this.add((Component)this.m_connectionComboBox, m_connectionConstraints);
        JCheckBox m_checkBox = new JCheckBox();
        m_checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        m_checkBox.setText("Full capture from selected connection");
        GridBagConstraints m_checkBoxConstraints = new GridBagConstraints();
        m_checkBoxConstraints.insets = new Insets(5, 10, 0, 0);
        m_checkBoxConstraints.ipadx = -5;
        m_checkBoxConstraints.fill = 2;
        m_checkBoxConstraints.gridwidth = 2;
        m_checkBoxConstraints.gridy = 2;
        m_checkBoxConstraints.gridx = 0;
        this.add((Component)m_checkBox, m_checkBoxConstraints);
        this.tree = new JTree();
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent e) {
            }

            public void treeCollapsed(TreeExpansionEvent e) {
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
            }
        });
        this.tree.setBorder(new BevelBorder(1));
        GridBagConstraints m_treeConstraints = new GridBagConstraints();
        m_treeConstraints.insets = new Insets(5, 5, 5, 5);
        m_treeConstraints.weighty = 1.0;
        m_treeConstraints.weightx = 1.0;
        m_treeConstraints.gridwidth = 2;
        m_treeConstraints.fill = 1;
        m_treeConstraints.gridy = 3;
        m_treeConstraints.gridx = 0;
        this.add((Component)this.tree, m_treeConstraints);
    }

    private String[] getPluginList(Collection<MigrationPlugin> plugins) {
        Object[] names = new String[plugins.size()];
        Iterator<MigrationPlugin> iter = plugins.iterator();
        int i = 0;
        while (iter.hasNext()) {
            names[i] = iter.next().getPlatformName();
            ++i;
        }
        Arrays.sort(names);
        return names;
    }
}

