/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.JPanel;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureEventListener;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.MigrationLogPanel;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogWindow;

public final class MigrationLogPage
extends AbstractLogPage
implements CaptureEventListener,
Cancelable {
    private static MigrationLogPage s_instance = null;
    public static final String MESSAGE_PAGE_ID = "MigrationLog";
    private Controller m_controller = new MigrationLogController();
    private JPanel _ui;

    public static MigrationLogPage getMigrationLog() {
        if (s_instance == null) {
            MigrationLogPage.addMigrationLogPage("Migration Log", true);
            return MigrationLogPage.getMigrationLog();
        }
        return s_instance;
    }

    public static void addMigrationLogPage(String title, boolean raise) {
        MigrationLogPage page = new MigrationLogPage();
        MigrationLogPage.setMigrationLogInstance(page);
        page.log(title);
        if (raise) {
            LogWindow logWindow = LogManager.getIdeLogWindow();
            DockStation.getDockStation().activateDockable((Dockable)logWindow);
        }
    }

    protected MigrationLogPage getMigrationLogInstance() {
        return s_instance;
    }

    protected static void setMigrationLogInstance(MigrationLogPage instance) {
        s_instance = instance;
    }

    private MigrationLogPage() {
        super(new ViewId(MESSAGE_PAGE_ID, "Migration Log"), null, true);
        ContextMenu cm = LogManager.getLogManager().getContextMenu();
        cm.addContextMenuListener(new ContextMenuListener(){

            public void poppingUp(ContextMenu popup) {
            }

            public void poppingDown(ContextMenu popup) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }

            public void menuWillShow(ContextMenu arg0) {
            }

            public void menuWillHide(ContextMenu arg0) {
            }
        });
    }

    public void signalCancel() {
    }

    protected void log(String logMessage) {
    }

    public void raiseEvent(CaptureEvent event) {
        String progressLabel = "";
        switch (event.getEventId()) {
            case 1: {
                progressLabel = MigrationAddinArb.getString(81) + " " + event.getEventSource();
                this.log(progressLabel);
                break;
            }
            case 2: {
                progressLabel = event.getEventSource() + " " + MigrationAddinArb.getString(80);
                this.log(progressLabel);
                break;
            }
            case 3: {
                progressLabel = MigrationAddinArb.getString(84) + " " + event.getEventSource();
                this.log(progressLabel);
                break;
            }
            case 4: {
                progressLabel = MigrationAddinArb.getString(85) + " " + event.getEventSource();
                this.log(progressLabel);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                progressLabel = MigrationAddinArb.getString(86);
                this.log(progressLabel);
                break;
            }
            case 7: {
                progressLabel = MigrationAddinArb.getString(86);
                this.log(progressLabel);
                break;
            }
        }
    }

    public Component getGUI() {
        if (this._ui == null) {
            this._ui = new MigrationLogPanel();
        }
        return this._ui;
    }

    private class MigrationLogController
    implements Controller {
        private MigrationLogController() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId != 18) {
                return false;
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("String Selected"), null);
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            int cmdId = action.getCommandId();
            if (cmdId != 18) {
                return false;
            }
            action.setEnabled(true);
            return true;
        }
    }
}

