/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.util.ModelUtil;

public class MigrationProgressBar
implements ActionListener,
Runnable {
    private Component _parent;
    private Object _belowInformation;
    private JProgressBar _progressBar;
    private boolean _useBusyBar;
    private JEWTDialog _statusDialog;
    private String _dialogTitle;
    private int _completionStatus;
    private Timer _labelTimer;
    private Timer _completionTimer;
    private boolean _userCancelled;
    private Runnable _runnable;
    private long _current = 0L;
    private long _lastPause = 0L;
    private boolean _done = false;
    private boolean _isExitClicked = false;
    private Component _topComponent;
    private Component _belowComponent;
    private JPanel _statusPanel;
    private boolean _isDismissed;
    private JCheckBox _exitCheckBox;
    private JButton _dismissButton;
    private JButton _cancelButton;
    private Object _aboveInformation;
    private static int s_topComponentWidth;
    private int m_topComponentHeight = 0;
    private int m_belowComponentHeight = 0;
    private int m_progressBarPanelHeight = 25;
    private int m_buttonPanelHeight = 55;
    private static int s_panelHeight;

    public MigrationProgressBar(Component parent, String dialogTitle, Runnable runnable, boolean useBusyBar) {
        this._parent = parent;
        this._dialogTitle = dialogTitle;
        this._runnable = runnable;
        this._useBusyBar = useBusyBar;
        s_topComponentWidth = 370;
        s_panelHeight = 0;
    }

    public void setRunnable(Runnable runnable) {
        this._runnable = runnable;
    }

    public void setGUI(Component topComponent, Component belowComponent) {
        this._belowComponent = belowComponent;
        this._topComponent = topComponent;
        if (this._topComponent != null) {
            s_topComponentWidth = topComponent.getPreferredSize().width;
            this.m_topComponentHeight = topComponent.getPreferredSize().height;
        }
        if (belowComponent != null) {
            this.m_belowComponentHeight = belowComponent.getPreferredSize().height;
        }
    }

    public void start() {
        this.start(0, 100);
    }

    public void start(int min, int max) {
        this._statusPanel = new JPanel(new FlowLayout());
        this.setPreferredSizeOfPanel(this._statusPanel);
        if (this._topComponent != null) {
            this._statusPanel.add(this._topComponent);
        }
        JPanel progressBarPanel = new JPanel(new FlowLayout());
        this._statusPanel.add(progressBarPanel);
        progressBarPanel.setPreferredSize(new Dimension(s_topComponentWidth, this.m_progressBarPanelHeight));
        this._progressBar = new JProgressBar(min, max);
        progressBarPanel.add(this._progressBar);
        this._progressBar.setPreferredSize(new Dimension(s_topComponentWidth, 15));
        if (this._belowComponent != null) {
            this._statusPanel.add(this._belowComponent);
        }
        JPanel buttonPanel = new JPanel();
        GridBagLayout buttonPanelLayout = new GridBagLayout();
        buttonPanelLayout.rowWeights = new double[]{0.1, 0.1};
        buttonPanelLayout.rowHeights = new int[]{7, 7};
        buttonPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1};
        buttonPanelLayout.columnWidths = new int[]{7, 7, 7};
        buttonPanel.setLayout(buttonPanelLayout);
        buttonPanel.setPreferredSize(new Dimension(s_topComponentWidth, this.m_buttonPanelHeight));
        this._exitCheckBox = new JCheckBox();
        buttonPanel.add((Component)this._exitCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 23, 0, new Insets(0, 0, 0, 0), 0, 0));
        GridBagLayout checkBoxLayout = new GridBagLayout();
        checkBoxLayout.rowWeights = new double[]{0.1};
        checkBoxLayout.rowHeights = new int[]{7};
        checkBoxLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
        checkBoxLayout.columnWidths = new int[]{7, 7, 7, 7};
        this._exitCheckBox.setLayout(checkBoxLayout);
        this._exitCheckBox.setText(MigrationAddinArb.getString(306));
        this._dismissButton = new JButton();
        BorderLayout dismissButtonLayout = new BorderLayout();
        this._dismissButton.setLayout(dismissButtonLayout);
        this._dismissButton.setEnabled(false);
        buttonPanel.add((Component)this._dismissButton, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._dismissButton.setText(MigrationAddinArb.getString(307));
        this._cancelButton = new JButton();
        buttonPanel.add((Component)this._cancelButton, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._cancelButton.setText(MigrationAddinArb.getString(308));
        this._statusPanel.add(buttonPanel);
        this.addListenersToButtons();
        if (!this._useBusyBar) {
            this._progressBar.setValue(0);
        }
        if (this._useBusyBar) {
            this._progressBar.setIndeterminate(true);
        } else {
            this._progressBar.setIndeterminate(false);
        }
        ((AbstractMigrationProgressRunnable)this._runnable).updateAbovePanel(this._aboveInformation);
        ((AbstractMigrationProgressRunnable)this._runnable).updateBelowPanel(this._belowInformation);
        this._labelTimer = new Timer(1, this);
        this._labelTimer.setRepeats(true);
        this._completionTimer = new Timer(1, this);
        this._completionTimer.setRepeats(false);
        this._userCancelled = false;
        try {
            this._statusDialog = ProgressDialog.createDialog(this._parent, this._dialogTitle, this._topComponent, this._belowComponent);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        if (this._statusDialog == null) {
            return;
        }
        this._statusDialog.add((Component)this._statusPanel);
        final Thread thread = new Thread((Runnable)this, "ProgressBarThread");
        thread.setPriority(5);
        this._statusDialog.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                thread.start();
                e.getWindow().removeWindowListener(this);
            }
        });
        boolean result = this._statusDialog.runDialog();
        this._userCancelled = !result;
        this.setDoneStatus();
        if (this._statusDialog != null) {
            this._statusDialog.dispose();
            this._statusDialog = null;
        }
    }

    private void setPreferredSizeOfPanel(JPanel panel) {
        s_panelHeight = this.m_topComponentHeight + this.m_progressBarPanelHeight + this.m_belowComponentHeight + this.m_buttonPanelHeight;
        if (this._topComponent == null) {
            this._statusPanel.setPreferredSize(new Dimension(s_topComponentWidth + 20, s_panelHeight));
        } else if (this._topComponent != null && this._belowComponent == null) {
            this._statusPanel.setPreferredSize(new Dimension(s_topComponentWidth + 70, s_panelHeight));
        } else {
            this._statusPanel.setPreferredSize(new Dimension(s_topComponentWidth + 70, s_panelHeight));
        }
    }

    private void addListenersToButtons() {
        this._dismissButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MigrationProgressBar.this._isDismissed = true;
                MigrationProgressBar.this.setDoneStatus();
                MigrationProgressBar.this._statusDialog.dispose();
                MigrationProgressBar.this._statusDialog = null;
            }
        });
        this._cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MigrationProgressBar.this._userCancelled = true;
                MigrationProgressBar.this.setDoneStatus();
                ((AbstractMigrationProgressRunnable)MigrationProgressBar.this._runnable).doCancel();
            }
        });
        this._exitCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MigrationProgressBar.this._isExitClicked = !MigrationProgressBar.this._isExitClicked;
            }
        });
    }

    public void updateProgress(int completionStatus, Object aboveInformation, Object belowInformation) {
        if (this._userCancelled) {
            return;
        }
        if (this._progressBar == null) {
            return;
        }
        this._completionStatus = completionStatus;
        if (!this._useBusyBar) {
            this._progressBar.setValue(this._completionStatus);
        }
        if (aboveInformation != null) {
            this._aboveInformation = aboveInformation;
            ((AbstractMigrationProgressRunnable)this._runnable).updateAbovePanel(this._aboveInformation);
        }
        if (belowInformation != null) {
            this._belowInformation = belowInformation;
            ((AbstractMigrationProgressRunnable)this._runnable).updateBelowPanel(this._belowInformation);
        }
        this._labelTimer.start();
    }

    public int getCompletionStatus() {
        return this._completionStatus;
    }

    public void updateProgress(String progressText, String stepText) {
        if (this._userCancelled) {
            if (this._aboveInformation != null) {
                ((AbstractMigrationProgressRunnable)this._runnable).updateAbovePanel(this._aboveInformation);
            }
            if (ModelUtil.hasLength((String)stepText)) {
                this._belowInformation = stepText;
            }
            this._labelTimer.start();
        }
    }

    public boolean hasUserCancelled() {
        if (this._userCancelled) {
            this.setDoneStatus();
        }
        return this._userCancelled;
    }

    public void sleepForUIToRepaint() {
        if (this._lastPause == 0L) {
            this._current = this._lastPause = System.currentTimeMillis();
        } else {
            this._current = System.currentTimeMillis();
            long elapsed = this._current - this._lastPause;
            if (elapsed > 1000L) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this._lastPause = this._current;
            }
        }
    }

    public synchronized void waitUntilDone() {
        while (!this._done) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.notifyAll();
    }

    public synchronized void setDoneStatus() {
        this._done = true;
        this.notifyAll();
        this.end();
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._labelTimer) {
            if (this._belowInformation != null) {
                ((AbstractMigrationProgressRunnable)this._runnable).updateBelowPanel(this._belowInformation);
            }
        } else if (source == this._completionTimer) {
            if (this._statusDialog != null && this._statusDialog.isVisible()) {
                this._statusDialog.hide();
            }
            if (this._labelTimer != null) {
                this._labelTimer.stop();
                this._labelTimer.removeActionListener(this);
                this._labelTimer = null;
            }
            this._completionTimer.stop();
            this._completionTimer.removeActionListener(this);
            this._completionTimer = null;
        }
    }

    public void run() {
        if (this._userCancelled) {
            return;
        }
        this._runnable.run();
        this._cancelButton.setEnabled(false);
        this._dismissButton.setEnabled(true);
        this._progressBar.setIndeterminate(false);
        this._progressBar.setValue(100);
    }

    private void end() {
        if (this._completionTimer != null) {
            this._completionTimer.start();
        }
    }

    public JDialog getStatusDialog() {
        return this._statusDialog;
    }

    public boolean isExitClicked() {
        return this._isExitClicked;
    }

    public void setExitOnDone(boolean exitOnDone) {
        if (exitOnDone != this._exitCheckBox.isSelected()) {
            this._exitCheckBox.doClick();
        }
    }

    public Component getBelowComponent() {
        return this._belowComponent;
    }

    public Component getTopComponent() {
        return this._topComponent;
    }

    public JProgressBar getProgressBar() {
        return this._progressBar;
    }

    public boolean isDismissed() {
        return this._isDismissed;
    }

    public JButton getCancelButton() {
        return this._cancelButton;
    }

    public JButton getDismissButton() {
        return this._dismissButton;
    }

    public void setSize(Dimension d) {
        this._statusPanel.setPreferredSize(d);
    }

    private static final class ProgressDialog
    extends JEWTDialog {
        private static final long serialVersionUID = 1L;

        static ProgressDialog createDialog(Component parent, String title, Component topComponent, Component belowComponent) {
            ProgressDialog dlg = null;
            Dialog dialog = DialogUtil.getAncestorDialog((Component)parent);
            if (dialog != null) {
                dlg = new ProgressDialog(dialog, title, topComponent, belowComponent);
            } else {
                Frame frame = DialogUtil.getAncestorFrame((Component)parent);
                if (frame != null) {
                    dlg = new ProgressDialog(frame, title, topComponent, belowComponent);
                }
            }
            return dlg;
        }

        private ProgressDialog(Dialog parent, String title, Component topComponent, Component belowComponent) {
            super(parent, title, 0);
            this.setLayout(this, topComponent, belowComponent);
        }

        private ProgressDialog(Frame frame, String title, Component topComponent, Component belowComponent) {
            super(frame, title, 0);
            this.setLayout(this, topComponent, belowComponent);
        }

        private void setLayout(ProgressDialog progressDialog, Component topComponent, Component belowComponent) {
            if (topComponent == null) {
                progressDialog.setPreferredSize(s_topComponentWidth + 50, s_panelHeight + 70);
            } else if (topComponent != null && belowComponent == null) {
                progressDialog.setPreferredSize(s_topComponentWidth + 50, s_panelHeight + 70);
            } else {
                progressDialog.setPreferredSize(s_topComponentWidth + 50, s_panelHeight + 70);
            }
        }

        protected void dismissDialog(boolean cancelled) {
            if (this.getDefaultCloseOperation() != 0) {
                super.dismissDialog(cancelled);
            }
        }

        public void dispose() {
            super.dispose();
        }

        public void removeNotify() {
            super.removeNotify();
        }
    }
}

