/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryStateListener;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogHandler;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.ui.TreeTableFilterImpl;
import oracle.dbtools.migration.workbench.core.ui.treeTable.FilteredMigrationLogModel;
import oracle.dbtools.migration.workbench.core.ui.treeTable.MigrationLogModel;
import oracle.dbtools.migration.workbench.core.ui.treeTable.MigrationTreeNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.JTreeTable;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.resource.LogArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.icons.OracleIcons;

public class MigrationTreeTableLogPage
extends AbstractLogPage {
    private static final String VIEW_LOG_DETAILS_CMD_ID_NAME = "ViewMigrationLogDetails";
    private static final int MAX_ASYNC_MESSAGES = 10;
    private static final int ASYNC_THREAD_SLEEP = 1000;
    private List<LogRecord> _asyncMessages = new ArrayList<LogRecord>(10);
    private Thread _updateThread = null;
    private JMenuItem _copyMenu;
    private JMenuItem _saveAsMenu;
    private JMenuItem _viewDetailsMenu;
    private boolean _popupMenuItemsInitialized;
    private JScrollPane _scrollPane;
    private MigrationLogPageController _controller;
    private JTreeTable _treeTable;
    private FilteredMigrationLogModel _filteredMigrationLogModel;
    private static URL s_lastSaveToFileURL = null;
    private Toolbar _toolbar;
    private JComboBox _migrationConnComboBox;

    public MigrationTreeTableLogPage() {
        super(new ViewId("MigrationTreeTablePageId", MigrationAddinArb.getString(95)), null, false);
        this.initGUI();
        this.initPopupMenuItems();
    }

    private void initGUI() {
        MigrationLogModel migrationLogModel = new MigrationLogModel();
        this._filteredMigrationLogModel = new FilteredMigrationLogModel(migrationLogModel, new TreeTableFilterImpl());
        this._treeTable = new JTreeTable((TreeTableModel)this._filteredMigrationLogModel);
        final JTreeTable.TreeTableCellRenderer defaultRenderer = (JTreeTable.TreeTableCellRenderer)this._treeTable.getDefaultRenderer(TreeTableModel.class);
        defaultRenderer.setRootVisible(false);
        defaultRenderer.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jtree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                this.setOpenIcon(OracleIcons.getIcon((String)"collapseall.png"));
                this.setClosedIcon(OracleIcons.getIcon((String)"expandall.png"));
                if (value instanceof MigrationTreeNode) {
                    LogRecord rec = ((MigrationTreeNode)value).getUserObject();
                    if (rec.getLevel() == Level.WARNING) {
                        this.setLeafIcon(OracleIcons.getIcon((String)"warning.png"));
                    } else if (rec.getLevel() == Level.SEVERE) {
                        this.setLeafIcon(OracleIcons.getIcon((String)"error.png"));
                    } else {
                        this.setLeafIcon(OracleIcons.getIcon((String)"info.png"));
                    }
                }
                return super.getTreeCellRendererComponent(jtree, value, isSelected, expanded, leaf, row, hasFocus);
            }
        });
        ToolTipManager.sharedInstance().registerComponent((JComponent)this._treeTable);
        this._scrollPane = new JScrollPane((Component)this._treeTable);
        this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        MouseAdapter defaultMouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e == null || e.getClickCount() != 2) {
                    return;
                }
                TreePath selectionPath = defaultRenderer.getSelectionPath();
                if (selectionPath != null && selectionPath.getLastPathComponent() != null) {
                    MigrationTreeTableLogPage.this.activateObject(selectionPath.getLastPathComponent());
                }
            }
        };
        KeyAdapter defaultKeyAdapter = new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e == null || e.isConsumed() || e.getKeyChar() != '\n') {
                    return;
                }
                Object obj = MigrationTreeTableLogPage.this._filteredMigrationLogModel.getValueAt(MigrationTreeTableLogPage.this._treeTable.getSelectedRow(), 0);
                if (obj != null) {
                    MigrationTreeTableLogPage.this.activateObject(obj);
                }
            }
        };
        this._treeTable.addMouseListener((MouseListener)defaultMouseAdapter);
        this._treeTable.addKeyListener((KeyListener)defaultKeyAdapter);
        this._treeTable.setShowVerticalLines(true);
        this._treeTable.setShowHorizontalLines(true);
        this._treeTable.setAutoResizeMode(0);
        this._scrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                MigrationTreeTableLogPage.this.initColumnSizes();
            }
        });
        this._treeTable.getColumn((Object)MigrationLogModel.SOURCE).setWidth(120);
        this._treeTable.getColumn((Object)MigrationLogModel.SOURCE).setPreferredWidth(120);
        this._treeTable.getColumn((Object)MigrationLogModel.DATE).setWidth(120);
        this._treeTable.getColumn((Object)MigrationLogModel.DATE).setPreferredWidth(120);
        this.addToolBar();
    }

    private void addToolBar() {
        this._toolbar = new Toolbar();
        this._toolbar.setLayout((LayoutManager)new BorderLayout());
        this._migrationConnComboBox = new JComboBox();
        this._toolbar.add((Component)this._migrationConnComboBox, (Object)"East");
        this._migrationConnComboBox.setSize(80, 30);
        this._migrationConnComboBox.setMaximumSize(this._migrationConnComboBox.getSize());
        this.setToolbarVisible(true);
        this._migrationConnComboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object newValue = value;
                if (value instanceof MdConnection) {
                    newValue = ((MdConnection)value).getName();
                }
                return super.getListCellRendererComponent((JList<?>)list, newValue, index, isSelected, cellHasFocus);
            }
        });
        this._migrationConnComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MigrationTreeTableLogPage.this._migrationConnComboBox.getSelectedItem() != null) {
                    MdConnection mdConnection = (MdConnection)MigrationTreeTableLogPage.this._migrationConnComboBox.getSelectedItem();
                    MigrationTreeTableLogPage.this._migrationConnComboBox.setToolTipText(mdConnection.getName());
                    MigrationTreeTableLogPage.this.setFilterBy(mdConnection.getKey());
                }
            }
        });
        this.addViewListener(new ViewListener(){

            public void viewActivated(ViewEvent e) {
                View.updateToolbarActions((Toolbar)MigrationTreeTableLogPage.this._toolbar);
            }

            public void viewClosed(ViewEvent e) {
            }

            public void viewDeactivated(ViewEvent e) {
            }
        });
        Observer observer = new Observer(){

            public void update(Object observed, UpdateMessage change) {
                ArrayList newList = new ArrayList(change.getAddObjects());
                if (change.getMessageID() == UpdateMessage.STRUCTURE_CHANGED || change.getMessageID() == UpdateMessage.OBJECT_RENAMED || newList.size() > 0 && newList.get(0) instanceof MigrationConnectionNode) {
                    MigrationTreeTableLogPage.this.refreshConnectionNodes();
                }
            }
        };
        CapturedDatabases.getInstance().attach(observer);
        ConvertedDatabases.getInstance().attach(observer);
        MigrationAddin.addMigrationRepositoryStateListener(new MigrationRepositoryStateListener(){

            public void repositoryClosed() {
                MigrationTreeTableLogPage.this.refreshConnectionNodes();
            }

            public void repositoryOpened(String name) {
                MigrationTreeTableLogPage.this.refreshConnectionNodes();
            }
        });
    }

    private void refreshConnectionNodes() {
        MdConnection[] migrationConnections;
        this._migrationConnComboBox.removeAllItems();
        for (MdConnection migrationConnectionNode : migrationConnections = this.getMigrationConnections()) {
            this._migrationConnComboBox.addItem(migrationConnectionNode);
        }
        if (migrationConnections.length > 0) {
            this._migrationConnComboBox.setToolTipText(migrationConnections[0].getName());
        }
    }

    private MdConnection[] getMigrationConnections() {
        ArrayList<MdConnection> migrNodes = new ArrayList<MdConnection>();
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        if (persistenceManager == null) {
            return new MdConnection[0];
        }
        PersistenceUtility utility = PersistenceUtility.getInstance(persistenceManager);
        try {
            CloseableIterator allCapturedConnections = utility.getAllCapturedConnections();
            while (allCapturedConnections.hasNext()) {
                migrNodes.add((MdConnection)allCapturedConnections.next());
            }
            CloseableIterator allConvertedConnections = utility.getAllConvertedConnections();
            while (allConvertedConnections.hasNext()) {
                migrNodes.add((MdConnection)allConvertedConnections.next());
            }
        }
        catch (PersistenceException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return migrNodes.toArray(new MdConnection[0]);
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    private void initColumnSizes() {
        int newWidth = this._scrollPane.getWidth() - this._scrollPane.getInsets().right - this._scrollPane.getInsets().left;
        int msgColumnIndex = this._treeTable.getColumnModel().getColumnIndex(MigrationLogModel.MESSAGE);
        for (int i = 0; i < this._treeTable.getColumnCount(); ++i) {
            if (i == msgColumnIndex) continue;
            newWidth -= this._treeTable.getColumnModel().getColumn(i).getWidth();
        }
        this._treeTable.getColumnModel().getColumn(msgColumnIndex).setPreferredWidth(newWidth);
    }

    private void initPopupMenuItems() {
        if (!this._popupMenuItemsInitialized) {
            this._popupMenuItemsInitialized = true;
            ContextMenu cm = LogManager.getLogManager().getContextMenu();
            IdeAction action = null;
            action = IdeAction.find((int)18);
            this._copyMenu = cm.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_EDIT_COPY);
            action = IdeAction.find((int)12);
            this._saveAsMenu = cm.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
            int aid = Ide.findOrCreateCmdID((String)VIEW_LOG_DETAILS_CMD_ID_NAME);
            IdeAction viewDetailsAction = IdeAction.get((int)aid, null, (String)MigrationAddinArb.getString(93), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)StringUtils.getMnemonicKeyCode((String)MigrationAddinArb.getString(93)), (ResourceBundle)MigrationAddinArb.getInstance(), null, null, (boolean)true);
            this._viewDetailsMenu = cm.createMenuItem((ToggleAction)viewDetailsAction);
            viewDetailsAction.addController(new Controller(){

                public boolean handleEvent(IdeAction ideAction, Context context) {
                    JTreeTable.TreeTableCellRenderer defaultRenderer;
                    TreePath[] selectionPath;
                    if (Ide.findCmdName((int)ideAction.getCommandId()).equals(MigrationTreeTableLogPage.VIEW_LOG_DETAILS_CMD_ID_NAME) && (selectionPath = (defaultRenderer = (JTreeTable.TreeTableCellRenderer)MigrationTreeTableLogPage.this._treeTable.getDefaultRenderer(TreeTableModel.class)).getSelectionPaths()) != null && selectionPath.length == 1) {
                        LogRecord logRecord = ((MigrationTreeNode)selectionPath[0].getLastPathComponent()).getUserObject();
                        String msg = selectionPath[0].getLastPathComponent().toString();
                        Throwable thrown = logRecord.getThrown();
                        if (thrown != null) {
                            ExceptionDialog.showExceptionDialog((Component)IdeUtil.getMainWindow(), (Throwable)thrown, (String)MigrationAddinArb.getString(93), (String)msg, null);
                        } else {
                            int type = 1;
                            Icon icon = OracleIcons.getIcon((String)"info.png");
                            if (logRecord.getLevel() == Level.WARNING) {
                                type = 2;
                                icon = OracleIcons.getIcon((String)"warning.png");
                            } else if (logRecord.getLevel() == Level.SEVERE) {
                                type = 0;
                                icon = OracleIcons.getIcon((String)"error.png");
                            }
                            JOptionPane.showMessageDialog(IdeUtil.getMainWindow(), msg, logRecord.getLevel().getLocalizedName(), type, icon);
                        }
                    }
                    return true;
                }

                public boolean update(IdeAction ideAction, Context context) {
                    return true;
                }
            });
            cm.addContextMenuListener((ContextMenuListener)new PrivateContextMenuListener());
        }
    }

    public ContextMenu getContextMenu() {
        ContextMenu cm = LogManager.getLogManager().getContextMenu();
        return cm;
    }

    public void addMouseListener(MouseListener listener) {
        if (listener != null) {
            this._treeTable.addMouseListener(listener);
        }
    }

    public void removeMouseListener(MouseListener listener) {
        if (listener != null) {
            this._treeTable.removeMouseListener(listener);
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (listener != null) {
            this._treeTable.addKeyListener(listener);
        }
    }

    public void removeKeyListener(KeyListener listener) {
        if (listener != null) {
            this._treeTable.removeKeyListener(listener);
        }
    }

    private void copy(TreePath[] selectedPaths) {
        StringBuffer copyBuff = new StringBuffer();
        for (TreePath path : selectedPaths) {
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof MigrationTreeNode)) continue;
            copyBuff.append(lastPathComponent.toString());
            copyBuff.append("\n");
        }
        StringSelection text = new StringSelection(copyBuff.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(text, null);
    }

    protected void saveToFile(Context context) {
        URL url;
        if (this._treeTable == null || this._treeTable.getRowCount() <= 0) {
            return;
        }
        String title = LogArb.getString((int)34);
        URLChooser chooser = DialogUtil.newURLChooser((Context)context);
        chooser.setHelpID("f1_idedsaveasrename_html");
        if (s_lastSaveToFileURL != null) {
            chooser.setSelectedURL(s_lastSaveToFileURL);
        }
        if (chooser.showSaveDialog((Component)Ide.getMainWindow(), title) == 0 && (url = chooser.getSelectedURL()) != null) {
            s_lastSaveToFileURL = url;
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            try {
                String encoding = Ide.getEnvironOptions().getEncoding();
                OutputStream os = URLFileSystem.openOutputStream((URL)url);
                PrintStream ps = encoding == null ? new PrintStream(os) : new PrintStream(os, false, encoding);
                for (int i = 0; i < this._treeTable.getRowCount(); ++i) {
                    ps.println(this._treeTable.getValueAt(i, 0).toString());
                }
                ps.flush();
                ps.close();
            }
            catch (Exception e) {
                String fileName = URLFileSystem.getPlatformPathName((URL)url);
                String msg = LogArb.format((int)2, (Object)fileName);
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), msg, IdeArb.getString((int)170), 0);
            }
            wc.hide();
        }
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new MigrationLogPageController();
        }
        return this._controller;
    }

    public void log(Object msg) {
        if (!(msg instanceof LogRecord)) {
            this.requestShow();
            this.activate();
        }
        this.logMsg(msg);
    }

    public Component getGUI() {
        return this._scrollPane;
    }

    protected String fixMessages(LogRecord rec, Formatter formatter) {
        String msg = rec.getMessage();
        if (msg == null) {
            msg = "";
        }
        if (formatter != null) {
            msg = formatter.format(rec);
        }
        msg = msg.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        return msg;
    }

    protected void activateObject(Object obj) {
        MigrationTreeNode tableRow;
        LogRecord logRecord;
        if (obj instanceof MigrationTreeNode && MigrationLogUtil.searchParameterByType((logRecord = (tableRow = (MigrationTreeNode)obj).getUserObject()).getParameters(), ClickableLogInfo.class).size() > 0) {
            MigrationLogHandler.getInstance().notifyListeners(logRecord);
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_com_logwindow_html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logMsg(Object msg) {
        if (msg instanceof LogRecord) {
            List<LogRecord> list = this._asyncMessages;
            synchronized (list) {
                this._asyncMessages.add((LogRecord)msg);
                if (this._asyncMessages.size() == 10) {
                    this.processAsyncMsgQueue(10);
                }
            }
        } else {
            super.logMsg(msg);
        }
    }

    public boolean isLogQueueEmpty() {
        return this._asyncMessages.size() == 0;
    }

    public void startAsynchronousLogging() {
        this._updateThread = new Thread("Log Page Updater"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (MigrationTreeTableLogPage.this._updateThread == this) {
                    try {
                        Thread.sleep(1000L);
                        List list = MigrationTreeTableLogPage.this._asyncMessages;
                        synchronized (list) {
                            if (MigrationTreeTableLogPage.this._asyncMessages.size() > 0) {
                                MigrationTreeTableLogPage.this.processAsyncMsgQueue(10);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        this._updateThread.setPriority(this._updateThread.getPriority() - 1);
        this._updateThread.start();
    }

    public void finishAsynchronousLogging() {
        this._updateThread = null;
        this.processAsyncMsgQueue(-1);
        if (this._treeTable.getRowCount() > 0) {
            this.requestShow();
        }
    }

    private void processAsyncMsgQueue(final int max) {
        Runnable runner = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List list = MigrationTreeTableLogPage.this._asyncMessages;
                synchronized (list) {
                    int size = MigrationTreeTableLogPage.this._asyncMessages.size();
                    int num = max > 0 && size > max ? max : size;
                    for (int i = 0; i < num; ++i) {
                        MigrationTreeTableLogPage.this.addMsg((LogRecord)MigrationTreeTableLogPage.this._asyncMessages.remove(0));
                    }
                    MigrationTreeTableLogPage.this._treeTable.updateUI();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    private void removeMessages(LogRecord rec) {
        int rowIndex = this.searchTableRow(rec);
        if (rowIndex < 0) {
            return;
        }
        this._filteredMigrationLogModel.getDelegateModel().getRoot().removeChildAt(rowIndex);
    }

    private int searchTableRow(LogRecord logRecord) {
        MigrationTreeNode root = this._filteredMigrationLogModel.getRoot();
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (root.getChildAt(i).getUserObject() != logRecord) continue;
            return i;
        }
        return -1;
    }

    private void addMsg(LogRecord msg) {
        int childIndex;
        Handler[] handlers;
        if (this._scrollPane.getViewport().getView() != this._treeTable) {
            this._scrollPane.setViewportView((Component)this._treeTable);
        }
        if (this.handleSpecialLog(msg)) {
            return;
        }
        if (this._treeTable.getRowCount() == 0) {
            if (!LogManager.getLogManager().isLogVisible()) {
                LogManager.getLogManager().showLog();
            }
            if (!this.isVisible()) {
                this.requestShow();
            }
        }
        if (Ide.getMainWindow().getLastActiveView() == LogManager.getLogManager().getLogWindow()) {
            IdeUtil.tryToRestoreFocus((Component)this._treeTable);
        } else {
            this.requestShow();
        }
        Formatter formatter = null;
        if (msg.getLoggerName() != null && (handlers = Logger.getLogger(msg.getLoggerName()).getHandlers()) != null && handlers.length > 0) {
            formatter = handlers[0].getFormatter();
        }
        if ((childIndex = this.insertLogRecursively(this._filteredMigrationLogModel.getRoot(), msg, formatter)) >= 0) {
            this._treeTable.scrollRectToVisible(this._treeTable.getCellRect(childIndex, 0, true));
        }
    }

    private int insertLogRecursively(MigrationTreeNode parent, LogRecord msg, Formatter formatter) {
        String str = this.fixMessages(msg, formatter);
        int lastError = 0;
        MigrationTreeNode child = null;
        lastError = 0;
        child = parent.insertChildAt(lastError, str, msg);
        List<LogInfo> childLogs = MigrationLogUtil.searchParameterByType(msg.getParameters(), LogInfo.class);
        if (childLogs.size() == 1) {
            for (LogRecord childRecord : childLogs.get(0).getChildRecords()) {
                this.insertLogRecursively(child, childRecord, formatter);
            }
        }
        return lastError;
    }

    private boolean handleSpecialLog(LogRecord msg) {
        List<ENUM_LogKind> cmdParamList = MigrationLogUtil.searchParameterByType(msg.getParameters(), ENUM_LogKind.class);
        if (cmdParamList.size() == 1) {
            ENUM_LogKind logKind = cmdParamList.get(0);
            if (logKind == ENUM_LogKind.START) {
                this.clearAll();
                return true;
            }
            if (logKind == ENUM_LogKind.REMOVE) {
                this.removeMessages(msg);
                return true;
            }
        }
        return false;
    }

    public void clearAll() {
        this._filteredMigrationLogModel.getRoot().removeAllChildren();
        this._treeTable.updateUI();
        super.clearAll();
    }

    public String getToolTip() {
        return "Log messages related to migration.";
    }

    public void setFilterBy(Object object) {
        this._filteredMigrationLogModel.setFiltered(object);
        this._treeTable.updateUI();
        if (this._migrationConnComboBox.getSelectedItem() == null) {
            return;
        }
        if (!((MdConnection)this._migrationConnComboBox.getSelectedItem()).getKey().equals(object)) {
            for (int i = 0; i < this._migrationConnComboBox.getItemCount(); ++i) {
                if (!((MdConnection)this._migrationConnComboBox.getItemAt(i)).getKey().equals(object)) continue;
                this._migrationConnComboBox.setSelectedIndex(i);
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class UpdateLogViewThread
    implements Runnable {
        private final List<LogRecord> _logRecList;

        public UpdateLogViewThread(List<LogRecord> msgs) {
            this._logRecList = msgs;
        }

        public UpdateLogViewThread(Collection<LogRecord> message) {
            this((List<LogRecord>)new ArrayList<LogRecord>(message));
        }

        @Override
        public void run() {
            if (this._logRecList == null) {
                return;
            }
            MigrationTreeTableLogPage.this.clearAll();
            for (LogRecord record : this._logRecList) {
                MigrationTreeTableLogPage.this.addMsg(record);
            }
        }
    }

    private class PrivateContextMenuListener
    implements ContextMenuListener {
        private PrivateContextMenuListener() {
        }

        public void menuWillShow(ContextMenu popup) {
            if (popup == null) {
                return;
            }
            Context ctxt = popup.getContext();
            if (ctxt == null || ctxt.getView() != MigrationTreeTableLogPage.this) {
                return;
            }
            if (MigrationTreeTableLogPage.this._copyMenu != null) {
                popup.add((Component)MigrationTreeTableLogPage.this._copyMenu, MenuConstants.SECTION_EDIT_CTXT_MENU);
            }
            if (MigrationTreeTableLogPage.this._saveAsMenu != null) {
                popup.add((Component)MigrationTreeTableLogPage.this._saveAsMenu, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
            if (MigrationTreeTableLogPage.this._viewDetailsMenu != null) {
                popup.add((Component)MigrationTreeTableLogPage.this._viewDetailsMenu, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            }
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class MigrationLogPageController
    implements Controller {
        private MigrationLogPageController() {
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (action != null) {
                int cmdId = action.getCommandId();
                if (cmdId == 18) {
                    JTreeTable.TreeTableCellRenderer defaultRenderer = (JTreeTable.TreeTableCellRenderer)MigrationTreeTableLogPage.this._treeTable.getDefaultRenderer(TreeTableModel.class);
                    TreePath[] selectionPath = defaultRenderer.getSelectionPaths();
                    if (selectionPath != null) {
                        MigrationTreeTableLogPage.this.copy(selectionPath);
                    }
                    return true;
                }
                if (cmdId == 12) {
                    MigrationTreeTableLogPage.this.saveToFile(context);
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction action, Context context) {
            if (action == null) {
                return true;
            }
            int cmdId = action.getCommandId();
            if (cmdId == 12) {
                action.setEnabled(MigrationTreeTableLogPage.this._treeTable != null && MigrationTreeTableLogPage.this._treeTable.getRowCount() > 0);
                return true;
            }
            if (cmdId == 18) {
                int selectedRow = MigrationTreeTableLogPage.this._treeTable.getSelectedRow();
                action.setEnabled(selectedRow >= 0);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ENUM_LogKind {
        START,
        END,
        REMOVE,
        CLEAR;

    }
}

