/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.workbench.core.ui.DataMapPanel;
import oracle.dbtools.migration.workbench.core.ui.IntegerDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewFieldTypePanel
extends JPanel {
    private JComboBox _cmbSourceField;
    private JTextField _txfSourcePrecision;
    private JTextField _txfSourceScale;
    private JComboBox _cmbTargetField;
    private JTextField _txfTargetPrecision;
    private JTextField _txfTargetScale;
    private Collection<DataTypeSpecification> _sourceList;
    private Collection<DataTypeSpecification> _targetList;

    public NewFieldTypePanel(Collection<DataTypeSpecification> sourceValueList, Collection<DataTypeSpecification> targetValueList, DataTypeSpecification srcSpec, DataTypeSpecification targetSpec) {
        super(new GridLayout(1, 2, 10, 5));
        this._sourceList = new HashSet<DataTypeSpecification>(sourceValueList);
        this._targetList = new HashSet<DataTypeSpecification>();
        for (DataTypeSpecification specification : targetValueList) {
            boolean found = false;
            for (DataTypeSpecification existingSpecification : this._targetList) {
                if (!specification.getName().equals(existingSpecification.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this._targetList.add(specification);
        }
        this.initGUI();
        this.initializeValues();
        this._cmbSourceField.addItemListener(new ComboListener(this._txfSourcePrecision, this._txfSourceScale));
        this._cmbTargetField.addItemListener(new ComboListener(this._txfTargetPrecision, this._txfTargetScale));
        if (srcSpec != null) {
            this._cmbSourceField.setSelectedItem(srcSpec);
            if (srcSpec.getPrecision() != null) {
                this._txfSourcePrecision.setText(String.valueOf(srcSpec.getPrecision()));
            }
            if (srcSpec.getScale() != null) {
                this._txfSourceScale.setText(String.valueOf(srcSpec.getScale()));
            }
        } else {
            this._cmbSourceField.setSelectedIndex(0);
        }
        if (targetSpec != null) {
            if (!this._targetList.contains(targetSpec)) {
                this._cmbTargetField.addItem(targetSpec);
            }
            this._cmbTargetField.setSelectedItem(targetSpec);
            if (targetSpec.getPrecision() != null) {
                this._txfTargetPrecision.setText(String.valueOf(targetSpec.getPrecision()));
            }
            if (targetSpec.getScale() != null) {
                this._txfTargetScale.setText(String.valueOf(targetSpec.getScale()));
            }
        } else {
            this._cmbTargetField.setSelectedIndex(0);
        }
    }

    private void initGUI() {
        this.setPreferredSize(new Dimension(320, 100));
        this.createSourceFieldUI();
        this.createTargetFieldUI();
    }

    private void createSourceFieldUI() {
        JPanel lhsPanel = new JPanel();
        GridBagLayout thisLayout = new GridBagLayout();
        thisLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
        thisLayout.rowHeights = new int[]{7, 7, 7};
        thisLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
        lhsPanel.setLayout(thisLayout);
        lhsPanel.setPreferredSize(new Dimension(150, 80));
        lhsPanel.add((Component)new JLabel(DataMapPanel.SOURCE_DATA_TYPE + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._cmbSourceField = new JComboBox();
        lhsPanel.add((Component)this._cmbSourceField, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        lhsPanel.add((Component)new JLabel(DataMapPanel.PRECISION + ":"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfSourcePrecision = new JTextField();
        this._txfSourcePrecision.setDocument(new IntegerDocument());
        lhsPanel.add((Component)this._txfSourcePrecision, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        lhsPanel.add((Component)new JLabel(DataMapPanel.SCALE + ":"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfSourceScale = new JTextField();
        this._txfSourceScale.setDocument(new IntegerDocument());
        lhsPanel.add((Component)this._txfSourceScale, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(lhsPanel);
    }

    private void createTargetFieldUI() {
        JPanel rhsPanel = new JPanel();
        GridBagLayout thisLayout = new GridBagLayout();
        thisLayout.rowWeights = new double[]{0.1, 0.1, 0.1};
        thisLayout.rowHeights = new int[]{7, 7, 7};
        thisLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
        rhsPanel.setLayout(thisLayout);
        rhsPanel.setPreferredSize(new Dimension(150, 80));
        rhsPanel.add((Component)new JLabel(DataMapPanel.TARGET_DATA_TYPE + ":"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._cmbTargetField = new JComboBox();
        this._cmbTargetField.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof DataTypeSpecification) {
                    return super.getListCellRendererComponent((JList<?>)list, ((DataTypeSpecification)value).getName(), index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        rhsPanel.add((Component)this._cmbTargetField, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        rhsPanel.add((Component)new JLabel(DataMapPanel.PRECISION + ":"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfTargetPrecision = new JTextField();
        this._txfTargetPrecision.setDocument(new IntegerDocument());
        rhsPanel.add((Component)this._txfTargetPrecision, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        rhsPanel.add((Component)new JLabel(DataMapPanel.SCALE + ":"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._txfTargetScale = new JTextField();
        this._txfTargetScale.setDocument(new IntegerDocument());
        rhsPanel.add((Component)this._txfTargetScale, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(rhsPanel);
    }

    private void initializeValues() {
        this._cmbSourceField.removeAllItems();
        for (DataTypeSpecification specifications : this._sourceList) {
            this._cmbSourceField.addItem(specifications);
        }
        this._cmbSourceField.setSelectedIndex(-1);
        this._cmbTargetField.removeAllItems();
        for (DataTypeSpecification specifications : this._targetList) {
            this._cmbTargetField.addItem(specifications);
        }
        this._cmbTargetField.setSelectedIndex(-1);
    }

    public DataTypeSpecification getDataTypeSpecification(JComboBox cmbSpec, JTextField txfPrec, JTextField txfScale) {
        DataTypeSpecification selectedItem = (DataTypeSpecification)cmbSpec.getSelectedItem();
        if (selectedItem != null) {
            DataTypeSpecification copiedSpec = this.getCopy(selectedItem);
            Integer newValue = null;
            if (txfPrec.getText().trim().length() > 0) {
                try {
                    newValue = Integer.valueOf(txfPrec.getText().trim());
                }
                catch (NumberFormatException ex) {
                    System.err.println(ex.getMessage());
                }
            }
            copiedSpec.setPrecision(newValue);
            newValue = null;
            if (txfScale.getText().trim().length() > 0) {
                try {
                    newValue = Integer.valueOf(txfScale.getText().trim());
                }
                catch (NumberFormatException ex) {
                    System.err.println(ex.getMessage());
                }
            }
            copiedSpec.setScale(newValue);
            return copiedSpec;
        }
        return null;
    }

    private DataTypeSpecification getCopy(DataTypeSpecification sourceSpec) {
        DataTypeSpecification copy = new DataTypeSpecification(sourceSpec.getName());
        copy.setPrecision(sourceSpec.getPrecision());
        copy.setScale(sourceSpec.getScale());
        return copy;
    }

    public void setSourceEditable(boolean isSourceEditable) {
        this._cmbSourceField.setEnabled(isSourceEditable);
        this._txfSourcePrecision.setEditable(isSourceEditable);
        this._txfSourceScale.setEditable(isSourceEditable);
    }

    public DataTypeSpecification getSourceSpecification() {
        return this.getDataTypeSpecification(this._cmbSourceField, this._txfSourcePrecision, this._txfSourceScale);
    }

    public DataTypeSpecification getTargetSpecification() {
        return this.getDataTypeSpecification(this._cmbTargetField, this._txfTargetPrecision, this._txfTargetScale);
    }

    private class ComboListener
    implements ItemListener {
        private JTextField _txfScale;
        private JTextField _txfPrecision;

        public ComboListener(JTextField txfPrc, JTextField txfScale) {
            this._txfScale = txfScale;
            this._txfPrecision = txfPrc;
        }

        public void itemStateChanged(ItemEvent e) {
            this._txfScale.setText("");
            this._txfPrecision.setText("");
        }
    }
}

