/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.DataMoveException;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.datamove.offline.OfflineDataMoveRunner;
import oracle.dbtools.migration.datamove.offline.OfflineDataMoveWorker;
import oracle.dbtools.migration.datamove.offline.OfflineDatamovePrintStream;
import oracle.dbtools.migration.datamove.offline.OfflineSQLLoaderPrintStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.MigrationConnectionNodeRenderer;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.util.IdeUtil;

public class OfflineDatamoveDialog
extends AbstractMenuAction {
    private static String s_title = "Generate Offline Data Move Files.";
    private JEWTDialog m_dlg;
    private JPanel m_panel;
    private boolean m_known = false;
    private int m_width;
    private int m_height;
    private JComboBox m_comboBox;
    private JLabel label;
    private JTextField directoryTextField;
    private JButton chooseDirectoryButton;
    private MdConnection m_mdConnection;

    private void dlgInit() {
        MigrationConnectionNode[] models = null;
        if (ConvertedDatabases.getInstance() != null) {
            models = ConvertedDatabases.getInstance().getMigrationConnectionNodes();
        }
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean conIdOk = OfflineDatamoveDialog.this.checkConvId();
                boolean dirOk = OfflineDatamoveDialog.this.checkDir();
                if (conIdOk && dirOk) {
                    try {
                        String dir = OfflineDatamoveDialog.this.directoryTextField.getText();
                        String fileTimeStamp = OfflineDatamovePrintStream.getTimeStamp();
                        fileTimeStamp = fileTimeStamp.replaceFirst(":", "h");
                        fileTimeStamp = fileTimeStamp.replaceFirst(":", "m");
                        fileTimeStamp = fileTimeStamp + "s";
                        String pluginType = MigrationUtils.getPluginForConnection(OfflineDatamoveDialog.this.m_mdConnection).getPlatformName();
                        if (pluginType.equals("sql server")) {
                            pluginType = "Sybase";
                        }
                        Offline3rdPartyPrintStream thirdPartyPrintStream = new Offline3rdPartyPrintStream(pluginType, fileTimeStamp, dir);
                        OfflineSQLLoaderPrintStream sqlLoaderPrintStream = new OfflineSQLLoaderPrintStream(pluginType, fileTimeStamp, dir);
                        OfflineDataMoveWorker oldmw = new OfflineDataMoveWorker(MigrationAddin.getPersistenceManager(), OfflineDatamoveDialog.this.m_mdConnection, OfflineDatamoveDialog.this.directoryTextField.getText(), thirdPartyPrintStream, sqlLoaderPrintStream);
                        OfflineDataMoveRunner oldmr = new OfflineDataMoveRunner(oldmw);
                        OfflineDatamoveDialog.this.m_dlg.closeDialog(true);
                        oldmr.start(true);
                    }
                    catch (DataMoveException oldme) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, oldme.getStackTrace()[0].toString(), oldme);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, ex.getStackTrace()[0].toString(), ex);
                    }
                    OfflineDatamoveDialog.this.m_dlg.setVisible(!conIdOk && !dirOk);
                }
            }
        };
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        if (!this.m_known) {
            this.label = new JLabel();
            this.label.setText("Converted Model");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 5, 0, 10);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 1;
            panel.add((Component)this.label, gridBagConstraints);
            this.m_comboBox = new JComboBox<MigrationConnectionNode>(models);
            this.m_comboBox.setRenderer(new MigrationConnectionNodeRenderer());
            if (models != null && models.length > 0) {
                this.m_comboBox.setToolTipText(models[0].getMdConnection().getName());
                this.m_comboBox.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (OfflineDatamoveDialog.this.m_comboBox.getSelectedItem() != null) {
                            OfflineDatamoveDialog.this.m_comboBox.setToolTipText(((MigrationConnectionNode)((Object)OfflineDatamoveDialog.this.m_comboBox.getSelectedItem())).getMdConnection().getName());
                        }
                    }
                });
            }
            GridBagConstraints comboConstraints = new GridBagConstraints();
            comboConstraints.insets = new Insets(5, 5, 0, 5);
            comboConstraints.fill = 2;
            comboConstraints.gridy = 0;
            comboConstraints.weightx = 4.0;
            comboConstraints.gridx = 0;
            panel.add((Component)this.m_comboBox, comboConstraints);
        }
        this.directoryTextField = new JTextField();
        this.directoryTextField.setEditable(false);
        this.directoryTextField.setEnabled(false);
        this.directoryTextField.setText(MigrationAddin.getMigrationConfig().getOfflineDataMoveScriptDirectory());
        GridBagConstraints textFieldConstraints = new GridBagConstraints();
        textFieldConstraints.anchor = 11;
        textFieldConstraints.insets = new Insets(5, 5, 0, 5);
        textFieldConstraints.weightx = 4.0;
        textFieldConstraints.fill = 2;
        textFieldConstraints.gridy = this.m_known ? 0 : 1;
        textFieldConstraints.gridx = 0;
        panel.add((Component)this.directoryTextField, textFieldConstraints);
        this.chooseDirectoryButton = new JButton();
        this.chooseDirectoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                URL selectedURL;
                int status;
                MigrationConfig options = MigrationAddin.getMigrationConfig();
                URLChooser fURLChooser = DialogUtil.newURLChooser();
                fURLChooser.clearChooseableURLFilters();
                fURLChooser.setSelectionScope(1);
                fURLChooser.setSelectionMode(0);
                String optDir = options.getOfflineDataMoveScriptDirectory();
                if (optDir != null && !optDir.equals("")) {
                    File f = new File(optDir);
                    try {
                        fURLChooser.setSelectedURL(f.toURL());
                    }
                    catch (MalformedURLException mue) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, mue.getStackTrace()[0].toString(), mue);
                    }
                }
                if ((status = fURLChooser.showOpenDialog((Component)Ide.getMainWindow(), MigrationAddinArb.getString(276))) == 0 && (selectedURL = fURLChooser.getSelectedURL()) != null && selectedURL.toString().length() > 0) {
                    File outputDir = new File(selectedURL.getPath());
                    if (!outputDir.exists() || !outputDir.canWrite()) {
                        oracle.javatools.dialogs.MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(275), (String)MigrationAddinArb.getString(276), null);
                    }
                    OfflineDatamoveDialog.this.directoryTextField.setText(outputDir.getAbsolutePath());
                }
            }
        });
        this.chooseDirectoryButton.setText(MigrationAddinArb.getString(276));
        GridBagConstraints gridBagConstraints_3 = new GridBagConstraints();
        gridBagConstraints_3.anchor = 11;
        gridBagConstraints_3.weighty = 0.0;
        gridBagConstraints_3.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints_3.gridy = this.m_known ? 0 : 1;
        gridBagConstraints_3.gridx = 1;
        panel.add((Component)this.chooseDirectoryButton, gridBagConstraints_3);
        if (this.m_known) {
            this.m_width = 500;
            this.m_height = 130;
            panel.setSize(this.m_width, this.m_height);
        } else {
            this.m_width = 500;
            this.m_height = 160;
            panel.setSize(this.m_width, this.m_height);
        }
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)s_title, (int)6);
        this.m_dlg.setSize(this.m_width, this.m_height);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(okListener);
        this.m_dlg.addCustomButton((Component)okButton);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_offlinedatamove_html");
        this.m_dlg.setSize(this.m_width, this.m_height);
        this.m_dlg.setPreferredSize(this.m_width, this.m_height);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.m_dlg);
    }

    private boolean checkConvId() {
        boolean conIdOk = false;
        DBObjectId convertedID = null;
        if (this.m_known) {
            conIdOk = true;
        } else if (this.m_comboBox.getSelectedItem() != null) {
            MigrationConnectionNode node = (MigrationConnectionNode)((Object)this.m_comboBox.getSelectedItem());
            this.m_mdConnection = node.getMdConnection();
            convertedID = this.m_mdConnection.getKey();
            if (convertedID != null) {
                conIdOk = true;
            }
        } else {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(282), (String)MigrationAddinArb.getString(281), (String)"f1_offlineDatamoveNoCovertID_html");
        }
        return conIdOk;
    }

    private boolean checkDir() {
        String dir = this.directoryTextField.getText();
        if (dir.equals("")) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(284), (String)MigrationAddinArb.getString(283), (String)"f1_offlineDatamoveNoGenDir_html");
            return false;
        }
        File directory = new File(dir);
        if (!directory.exists()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(293), (String)MigrationAddinArb.getString(283), (String)"f1_offlineDatamoveNoGenDir_html");
            return false;
        }
        if (!directory.canRead() || !directory.canWrite()) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(294), (String)MigrationAddinArb.getString(283), (String)"f1_offlineDatamoveNoGenDir_html");
            return false;
        }
        return true;
    }

    public void launch() {
        this.m_known = true;
        DBObject dbo = this.getDBObject();
        ConvertedConnectionNode conDb = (ConvertedConnectionNode)dbo.getElement();
        this.m_mdConnection = conDb.getMdConnection();
        this.dlgInit();
        this.m_dlg.setVisible(true);
    }

    public void launchunknownMenu() {
        this.dlgInit();
        this.m_dlg.setVisible(true);
    }

    public void setArgs(String args) {
    }
}

