/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.generate.OfflineGenerationOutputStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.GenerateRunner;
import oracle.dbtools.migration.workbench.core.ui.MigrationConnectionNodeRenderer;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;

public class OfflineOracleGenerationDialog {
    private JPanel m_panel;
    private JEWTDialog m_dlg;
    private JComboBox m_combo;

    public OfflineOracleGenerationDialog() {
        this.init();
    }

    private void init() {
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new GridBagLayout());
        JLabel label = new JLabel(MigrationAddinArb.getString(103));
        GridBagConstraints labelConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0);
        GridBagConstraints comboConstraints = new GridBagConstraints(1, 0, 1, 1, 4.0, 0.0, 18, 2, new Insets(5, 0, 0, 5), 0, 0);
        MigrationConnectionNode[] nodes = ConvertedDatabases.getInstance().getMigrationConnectionNodes();
        if (nodes != null) {
            this.m_combo = new JComboBox<MigrationConnectionNode>(nodes);
            if (nodes.length > 0) {
                this.m_combo.setSelectedIndex(0);
                this.m_combo.setToolTipText(nodes[0].getMdConnection().getName());
            }
            this.m_combo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (OfflineOracleGenerationDialog.this.m_combo.getSelectedItem() != null) {
                        OfflineOracleGenerationDialog.this.m_combo.setToolTipText(((MigrationConnectionNode)((Object)OfflineOracleGenerationDialog.this.m_combo.getSelectedItem())).getMdConnection().getName());
                    }
                }
            });
        }
        this.m_combo.setRenderer(new MigrationConnectionNodeRenderer());
        this.m_panel.add((Component)label, labelConstraints);
        this.m_panel.add((Component)this.m_combo, comboConstraints);
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this.m_panel, null, (String)StringUtils.stripMnemonic((String)MigrationAddinArb.getString(297)), (int)6);
        this.m_dlg.setSize(400, 120);
        this.m_dlg.setResizable(false);
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_panel, "f1_offlinegeneration_html");
        JButton okButton = new JButton(MigrationAddinArb.getString(75));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent okEvent) {
                Preferences p = Preferences.getPreferences();
                MigrationConfig options = MigrationConfig.getInstance((PropertyStorage)p);
                Dimension d = OfflineOracleGenerationDialog.this.m_combo.getSize();
                d.getHeight();
                OfflineGenerationOutputStream outputStream = new OfflineGenerationOutputStream(options);
                MigrationObjectFilterList filterList = null;
                MigrationConnectionNode node = (MigrationConnectionNode)((Object)OfflineOracleGenerationDialog.this.m_combo.getSelectedItem());
                MdConnection conn = node.getMdConnection();
                GenerateWorker worker = new GenerateWorker(MigrationAddin.getPersistenceManager(), conn.getKey(), outputStream, filterList);
                GenerateRunner runner = new GenerateRunner(worker);
                try {
                    OfflineOracleGenerationDialog.this.m_dlg.setVisible(false);
                    runner.start(true);
                    String msg = MessageFormat.format(MigrationAddinArb.getString(309), options.getOfflineGenerationDirectory());
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)msg, (String)MigrationAddinArb.getString(310), null);
                }
                catch (Exception e) {
                    MigrationLogUtil.logThrowable(e.getLocalizedMessage(), "Generation", (Throwable)e);
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString(312), (String)MigrationAddinArb.getString(311), (String)"help_need_output_access");
                }
            }
        });
        this.m_dlg.addCustomButton((Component)okButton);
    }

    public void launch() {
        if (this.m_dlg != null) {
            this.m_dlg.setLocationRelativeTo((Component)Ide.getMainWindow());
            this.m_dlg.setVisible(true);
        }
    }
}

