/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.ui.RepoRenderer;
import oracle.dbtools.raptor.connections.ConnectionComboRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;

public abstract class RepositoryDialog {
    private JEWTDialog m_dlg;
    private JPanel m_panel;
    private JComboBox m_repositoryCombo;
    private static final long serialVersionUID = 3721528190970465727L;
    private JButton m_btnSelect;
    private String[] m_repositoryTuples;
    private JLabel m_defaultRepositoryLabel;
    private String m_type;

    public RepositoryDialog(String dialogTitle, String buttonTitle, String type) {
        this.m_type = type;
        this.init(dialogTitle, buttonTitle);
    }

    private void init(String title, String buttonTitle) {
        this.m_panel = new JPanel();
        this.m_panel.setLayout(new GridBagLayout());
        this.m_defaultRepositoryLabel = new JLabel();
        this.m_defaultRepositoryLabel.setText(StringUtils.stripMnemonic((String)MigrationAddinArb.getString(49)));
        GridBagConstraints repositoryLabelConstraints = new GridBagConstraints();
        repositoryLabelConstraints.anchor = 11;
        repositoryLabelConstraints.weighty = 1.0;
        repositoryLabelConstraints.weightx = 0.0;
        repositoryLabelConstraints.insets = new Insets(10, 10, 0, 10);
        repositoryLabelConstraints.gridy = 0;
        repositoryLabelConstraints.gridx = 0;
        this.m_panel.add((Component)this.m_defaultRepositoryLabel, repositoryLabelConstraints);
        this.m_repositoryCombo = new JComboBox();
        this.m_repositoryCombo.setRenderer(new RepoRenderer());
        GridBagConstraints comboConstraints = new GridBagConstraints();
        comboConstraints.anchor = 11;
        comboConstraints.insets = new Insets(10, 0, 0, 10);
        comboConstraints.weightx = 4.0;
        comboConstraints.fill = 2;
        comboConstraints.gridy = 0;
        comboConstraints.gridx = 1;
        this.m_panel.add((Component)this.getRepositoryCombo(), comboConstraints);
        this.setupData();
        this.m_repositoryCombo.setRenderer(new ConnectionComboRenderer());
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)this.m_panel, null, (String)title, (int)6);
        this.getGui().setSize(500, 130);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.getGui());
        this.getGui().setResizable(false);
        this.m_btnSelect = new JButton(buttonTitle);
        this.getGui().addCustomButton((Component)this.m_btnSelect);
    }

    public void addokActionListener(ActionListener l) {
        this.m_btnSelect.addActionListener(l);
    }

    public void setComboLabel(String label) {
        this.m_defaultRepositoryLabel.setText(label);
    }

    public void setHelpId(String id) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)this.m_panel, id);
    }

    private void setupData() {
        if (this.m_type.toLowerCase().equals("oracle")) {
            Connections inst = Connections.getInstance();
            ArrayList<String> onames = new ArrayList<String>();
            String[] names = inst.getConnNames();
            this.getRepositoryCombo().removeAllItems();
            for (int i = 0; i < names.length; ++i) {
                String connName = names[i];
                if (!inst.isOracle(connName)) continue;
                onames.add(connName);
                this.getRepositoryCombo().addItem(connName);
            }
            if (this.getRepositoryCombo().getModel().getSize() > 0) {
                this.getRepositoryCombo().setSelectedIndex(0);
            }
        } else {
            MigrationConfig options = MigrationAddin.getMigrationConfig();
            this.m_repositoryTuples = options.getRepositories();
            this.getRepositoryCombo().removeAllItems();
            String defaultRepo = options.getDefaultRepository();
            for (String s : this.m_repositoryTuples) {
                this.getRepositoryCombo().addItem(s);
                if (!s.equals(defaultRepo)) continue;
                this.getRepositoryCombo().setSelectedItem(s);
            }
        }
    }

    public JComboBox getRepositoryCombo() {
        return this.m_repositoryCombo;
    }

    public JEWTDialog getGui() {
        return this.m_dlg;
    }
}

