/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import oracle.dbtools.migration.workbench.core.ui.AbstractUpdatableTableModel;

public class SimpleTablePanel
extends JPanel {
    private JTable m_table;

    public SimpleTablePanel(int panelWidth, String toolTipText, AbstractUpdatableTableModel model) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(panelWidth, 125));
        JScrollPane topPanelScrollPane = new JScrollPane();
        this.add((Component)topPanelScrollPane, "Center");
        topPanelScrollPane.setHorizontalScrollBarPolicy(30);
        topPanelScrollPane.setVerticalScrollBarPolicy(20);
        this.m_table = new JTable(){

            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                Object value = this.getValueAt(row, column);
                TableCellEditor ed = this.getDefaultEditor(value.getClass());
                Component c2 = ed.getTableCellEditorComponent(this, value, this.isCellSelected(row, column), row, column);
                if (c2 instanceof JTextComponent) {
                    ((JTextComponent)c2).setEditable(false);
                }
                return c2;
            }

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    if (this.getValueAt(rowIndex, vColIndex) instanceof Integer) {
                        jc.setToolTipText("<html>" + ((Integer)this.getValueAt(rowIndex, vColIndex)).toString().replaceAll("\n", "<br>") + "</html>");
                    } else if (this.getValueAt(rowIndex, vColIndex) != null) {
                        jc.setToolTipText("<html>" + ((String)this.getValueAt(rowIndex, vColIndex)).replaceAll("\n", "<br>") + "</html>");
                    }
                }
                return c;
            }
        };
        TableCellRenderer tcr = this.m_table.getTableHeader().getDefaultRenderer();
        if (tcr instanceof JLabel) {
            ((JLabel)((Object)tcr)).setHorizontalAlignment(10);
        }
        model.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
            }
        });
        this.setToolTipText(toolTipText);
        topPanelScrollPane.setViewportView(this.m_table);
        this.m_table.setModel(model);
    }

    public void updateProgress(Object o) {
        if (o != null) {
            AbstractUpdatableTableModel model = (AbstractUpdatableTableModel)this.m_table.getModel();
            model.update(o);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(model.getRowCount() - 1, 0, true));
        }
    }
}

