/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;

public class YesToAllDialog {
    private JLabel _lblDialogText;
    private JButton _btnYes;
    private JButton _btnNoToAll;
    private JButton _btnNo;
    private JButton _btnYesToAll;
    private Object _selectedButton;
    private JEWTDialog _jewtDialog;

    public YesToAllDialog(String title, String text, boolean isMultipleSelection) {
        JPanel yesToAllPanel = new JPanel();
        this.initGUI(yesToAllPanel);
        this.addActionListener();
        this.setText(text);
        this._jewtDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)yesToAllPanel, null, (String)title, (int)0);
        this._jewtDialog.addCustomButton((Component)this._btnYes);
        this._jewtDialog.addCustomButton((Component)this._btnNo);
        if (isMultipleSelection) {
            this._jewtDialog.addCustomButton((Component)this._btnYesToAll);
            this._jewtDialog.addCustomButton((Component)this._btnNoToAll);
        }
        this._jewtDialog.setSize(470, 150);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._jewtDialog);
        this._jewtDialog.setVisible(true);
    }

    public YesToAllDialog(String title, String text) {
        this(title, text, true);
    }

    private void setText(String text) {
        this._lblDialogText.setText(text);
    }

    private void addActionListener() {
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                YesToAllDialog.this._selectedButton = e.getSource();
                YesToAllDialog.this._jewtDialog.closeDialog(true);
            }
        };
        this._btnYes.addActionListener(listener);
        this._btnYesToAll.addActionListener(listener);
        this._btnNo.addActionListener(listener);
        this._btnNoToAll.addActionListener(listener);
    }

    public boolean isYes() {
        return this._selectedButton == this._btnYes;
    }

    public boolean isYesToAll() {
        return this._selectedButton == this._btnYesToAll;
    }

    public boolean isNo() {
        return this._selectedButton == this._btnNo;
    }

    public boolean isNoToAll() {
        return this._selectedButton == this._btnNoToAll;
    }

    private void initGUI(JPanel yesToAllPanel) {
        yesToAllPanel.setLayout(new BorderLayout());
        this._lblDialogText = new JLabel();
        yesToAllPanel.add((Component)this._lblDialogText, "Center");
        this._lblDialogText.setText("<No Text>");
        this._btnYes = new JButton(MigrationAddinArb.getString(64));
        this._btnYesToAll = new JButton(MigrationAddinArb.getString(65));
        this._btnNo = new JButton(MigrationAddinArb.getString(66));
        this._btnNoToAll = new JButton(MigrationAddinArb.getString(67));
    }
}

